/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.correlation.CorrelationInfoVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.correlation.HiveCorrelationInfo;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveFilter
extends Filter
implements HiveRelNode {
    private final CorrelationInfoSupplier correlationInfos = new CorrelationInfoSupplier(this.getCondition());

    public HiveFilter(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, condition);
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
        return new HiveFilter(this.getCluster(), traitSet, input, condition);
    }

    public Set<CorrelationId> getVariablesSet() {
        LinkedHashSet<CorrelationId> correlationIds = new LinkedHashSet<CorrelationId>();
        for (HiveCorrelationInfo h : this.correlationInfos.get()) {
            correlationIds.addAll(h.correlationIds);
        }
        return correlationIds;
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof HiveRelShuttle) {
            return ((HiveRelShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public List<HiveCorrelationInfo> getCorrelationInfos() {
        return this.correlationInfos.get();
    }

    private static class CorrelationInfoSupplier {
        private final RexNode condition;
        List<HiveCorrelationInfo> correlationInfos;

        public CorrelationInfoSupplier(RexNode condition) {
            this.condition = condition;
        }

        public List<HiveCorrelationInfo> get() {
            if (this.correlationInfos == null) {
                this.correlationInfos = CorrelationInfoVisitor.getCorrelationInfos(this.condition);
            }
            return this.correlationInfos;
        }
    }

    public static class StatEnhancedHiveFilter
    extends HiveFilter {
        private long rowCount;

        public StatEnhancedHiveFilter(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition, long rowCount) {
            super(cluster, traits, child, condition);
            this.rowCount = rowCount;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public double estimateRowCount(RelMetadataQuery mq) {
            return this.rowCount;
        }

        @Override
        public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
            return new StatEnhancedHiveFilter(this.getCluster(), traitSet, input, condition, this.rowCount);
        }
    }
}

