/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.IncompleteCb;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.orc.encoded.LlapDataReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.orc.encoded.StoppableAllocator;
import org.apache.hive.common.util.CleanerUtil;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.OrcCodecPool;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.RecordReaderUtils;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.WriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EncodedReaderImpl
implements EncodedReader {
    public static final Logger LOG = LoggerFactory.getLogger(EncodedReaderImpl.class);
    private static final Object POOLS_CREATION_LOCK = new Object();
    private static Pools POOLS;
    private static final DataCache.DiskRangeListFactory CC_FACTORY;
    private final Object fileKey;
    private final LlapDataReader dataReader;
    private boolean isDataReaderOpen = false;
    private CompressionCodec codec;
    private final boolean isCodecFromPool;
    private boolean isCodecFailure = false;
    private final boolean isCompressed;
    private final CompressionKind compressionKind;
    private final int bufferSize;
    private final List<OrcProto.Type> types;
    private final long rowIndexStride;
    private final DataCache cacheWrapper;
    private boolean isTracingEnabled;
    private final IoTrace trace;
    private final TypeDescription fileSchema;
    private final OrcFile.WriterVersion version;
    private final CacheTag tag;
    private AtomicBoolean isStopped;
    private StoppableAllocator allocator;
    private final boolean isReadCacheOnly;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodedReaderImpl(Object fileKey, List<OrcProto.Type> types, TypeDescription fileSchema, CompressionKind kind, OrcFile.WriterVersion version, int bufferSize, long strideRate, DataCache cacheWrapper, LlapDataReader dataReader, Reader.PoolFactory pf, IoTrace trace, boolean useCodecPool, CacheTag tag, boolean isReadCacheOnly) throws IOException {
        this.fileKey = fileKey;
        this.compressionKind = kind;
        this.isCompressed = kind != CompressionKind.NONE;
        this.isCodecFromPool = useCodecPool;
        this.codec = useCodecPool ? OrcCodecPool.getCodec((CompressionKind)kind) : WriterImpl.createCodec((CompressionKind)kind);
        this.types = types;
        this.fileSchema = fileSchema;
        this.version = version;
        this.bufferSize = bufferSize;
        this.rowIndexStride = strideRate;
        this.cacheWrapper = cacheWrapper;
        Allocator alloc = cacheWrapper.getAllocator();
        this.allocator = alloc instanceof StoppableAllocator ? (StoppableAllocator)alloc : null;
        this.dataReader = dataReader;
        this.trace = trace;
        this.tag = tag;
        this.isReadCacheOnly = isReadCacheOnly;
        if (POOLS != null) {
            return;
        }
        if (pf == null) {
            pf = new NoopPoolFactory();
        }
        Pools pools = EncodedReaderImpl.createPools(pf);
        Object object = POOLS_CREATION_LOCK;
        synchronized (object) {
            if (POOLS != null) {
                return;
            }
            POOLS = pools;
        }
    }

    private static boolean[] findPresentStreamsByColumn(List<OrcProto.Stream> streamList, List<OrcProto.Type> types) {
        boolean[] hasNull = new boolean[types.size()];
        for (OrcProto.Stream stream : streamList) {
            if (!stream.hasKind() || stream.getKind() != OrcProto.Stream.Kind.PRESENT) continue;
            hasNull[stream.getColumn()] = true;
        }
        return hasNull;
    }

    private static void addEntireStreamToRanges(long offset, long length, DiskRangeList.CreateHelper list, boolean doMergeBuffers) {
        list.addOrMerge(offset, offset + length, doMergeBuffers, false);
    }

    private static void addRgFilteredStreamToRanges(OrcProto.Stream stream, boolean[] includedRowGroups, boolean isCompressed, OrcProto.RowIndex index, OrcProto.ColumnEncoding encoding, TypeDescription.Category colType, int compressionSize, boolean hasNull, long offset, long length, DiskRangeList.CreateHelper list, boolean doMergeBuffers) {
        for (int group = 0; group < includedRowGroups.length; ++group) {
            if (!includedRowGroups[group]) continue;
            int posn = RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)encoding.getKind(), (TypeDescription.Category)colType, (OrcProto.Stream.Kind)stream.getKind(), (boolean)isCompressed, (boolean)hasNull);
            long start = index.getEntry(group).getPositions(posn);
            boolean isLast = group == includedRowGroups.length - 1;
            long nextGroupOffset = isLast ? length : index.getEntry(group + 1).getPositions(posn);
            long end = offset + EncodedReaderImpl.estimateRgEndOffset(isCompressed, isLast, nextGroupOffset, length, compressionSize);
            list.addOrMerge(start += offset, end, doMergeBuffers, true);
        }
    }

    private static long estimateRgEndOffset(boolean isCompressed, boolean isLast, long nextGroupOffset, long streamLength, int bufferSize) {
        long slop = isCompressed ? (long)(2 * (3 + bufferSize)) : 4098L;
        return isLast ? streamLength : Math.min(streamLength, nextGroupOffset + slop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readEncodedColumns(int stripeIx, StripeInformation stripe, OrcProto.RowIndex[] indexes, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Stream> streamList, boolean[] physicalFileIncludes, boolean[] rgs, Consumer<Reader.OrcEncodedColumnBatch> consumer) throws IOException {
        boolean hasFileId;
        long stripeOffset = stripe.getOffset();
        long offset = 0L;
        boolean[] hasNull = EncodedReaderImpl.findPresentStreamsByColumn(streamList, this.types);
        if (this.isTracingEnabled) {
            LOG.trace("The following columns have PRESENT streams: " + EncodedReaderImpl.arrayToString(hasNull));
        }
        ReadContext[] colCtxs = new ColumnReadContext[physicalFileIncludes.length];
        int colRgIx = -1;
        for (int i = 1; i < physicalFileIncludes.length; ++i) {
            if (!physicalFileIncludes[i]) continue;
            OrcProto.ColumnEncoding enc = encodings.get(i);
            colCtxs[i] = new ColumnReadContext(i, enc, indexes[i], ++colRgIx);
            if (this.isTracingEnabled) {
                LOG.trace("Creating context: " + colCtxs[i].toString());
            }
            this.trace.logColumnRead(i, colRgIx, enc.getKind());
        }
        DiskRangeList.CreateHelper listToRead = new DiskRangeList.CreateHelper();
        boolean hasIndexOnlyCols = false;
        boolean hasAnyNonData = false;
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int colIx = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            boolean isIndexCol = StreamName.getArea((OrcProto.Stream.Kind)streamKind) != StreamName.Area.DATA;
            hasAnyNonData = hasAnyNonData || isIndexCol;
            boolean bl = hasIndexOnlyCols = hasIndexOnlyCols || isIndexCol && physicalFileIncludes[colIx];
            if (!physicalFileIncludes[colIx] || isIndexCol) {
                if (this.isTracingEnabled) {
                    LOG.trace("Skipping stream for column " + colIx + ": " + String.valueOf(streamKind) + " at " + offset + ", " + length);
                }
                this.trace.logSkipStream(colIx, streamKind, offset, length);
                offset += length;
                continue;
            }
            ReadContext ctx = colCtxs[colIx];
            assert (ctx != null);
            int indexIx = RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)((ColumnReadContext)ctx).encoding.getKind(), (TypeDescription.Category)this.fileSchema.findSubtype(colIx).getCategory(), (OrcProto.Stream.Kind)streamKind, (boolean)this.isCompressed, (boolean)hasNull[colIx]);
            ((ColumnReadContext)ctx).addStream(offset, stream, indexIx);
            if (this.isTracingEnabled) {
                LOG.trace("Adding stream for column " + colIx + ": " + String.valueOf(streamKind) + " at " + offset + ", " + length + ", index position " + indexIx);
            }
            if (rgs == null || RecordReaderUtils.isDictionary((OrcProto.Stream.Kind)streamKind, (OrcProto.ColumnEncoding)encodings.get(colIx))) {
                this.trace.logAddStream(colIx, streamKind, offset, length, indexIx, true);
                EncodedReaderImpl.addEntireStreamToRanges(offset, length, listToRead, true);
                if (this.isTracingEnabled) {
                    LOG.trace("Will read whole stream " + String.valueOf(streamKind) + "; added to " + String.valueOf(listToRead.getTail()));
                }
            } else {
                this.trace.logAddStream(colIx, streamKind, offset, length, indexIx, false);
                EncodedReaderImpl.addRgFilteredStreamToRanges(stream, rgs, this.isCompressed, indexes[colIx], encodings.get(colIx), this.fileSchema.findSubtype(colIx).getCategory(), this.bufferSize, hasNull[colIx], offset, length, listToRead, true);
            }
            offset += length;
        }
        boolean bl = hasFileId = this.fileKey != null;
        if (listToRead.get() == null) {
            boolean nonProjectionRead;
            boolean hasAnyIncludes = false;
            if (!hasIndexOnlyCols) {
                for (int i = 0; i < physicalFileIncludes.length; ++i) {
                    if (!physicalFileIncludes[i]) {
                        continue;
                    }
                    hasAnyIncludes = true;
                    break;
                }
            }
            boolean bl2 = nonProjectionRead = hasIndexOnlyCols || !hasAnyNonData && hasAnyIncludes;
            if (nonProjectionRead && rgs == RecordReaderImpl.SargApplier.READ_ALL_RGS) {
                Reader.OrcEncodedColumnBatch ecb = (Reader.OrcEncodedColumnBatch)((Object)EncodedReaderImpl.POOLS.ecbPool.take());
                ecb.init(this.fileKey, stripeIx, -1, physicalFileIncludes.length);
                try {
                    consumer.consumeData(ecb);
                    return;
                }
                catch (InterruptedException e) {
                    LOG.error("IO thread interrupted while queueing data");
                    throw new IOException(e);
                }
            }
            LOG.warn("Nothing to read for stripe [" + String.valueOf(stripe) + "]");
            return;
        }
        IdentityHashMap<ByteBuffer, Boolean> toRelease = new IdentityHashMap<ByteBuffer, Boolean>();
        DiskRangeList.MutateHelper toRead = this.getDataFromCacheAndDisk(listToRead.get(), stripeOffset, hasFileId, toRelease);
        DiskRangeList iter = this.preReadUncompressedStreams(stripeOffset, colCtxs, toRead, toRelease);
        boolean hasError = true;
        try {
            int rgCount = this.rowIndexStride == 0L ? 1 : (int)Math.ceil((double)stripe.getNumberOfRows() / (double)this.rowIndexStride);
            for (int rgIx = 0; rgIx < rgCount; ++rgIx) {
                if (rgs != null && !rgs[rgIx]) continue;
                boolean isLastRg = rgIx == rgCount - 1;
                Reader.OrcEncodedColumnBatch ecb = (Reader.OrcEncodedColumnBatch)((Object)EncodedReaderImpl.POOLS.ecbPool.take());
                this.trace.logStartRg(rgIx);
                boolean hasErrorForEcb = true;
                try {
                    ecb.init(this.fileKey, stripeIx, rgIx, physicalFileIncludes.length);
                    for (int colIx = 0; colIx < colCtxs.length; ++colIx) {
                        OrcProto.RowIndexEntry nextIndex;
                        OrcProto.RowIndexEntry index;
                        ReadContext ctx = colCtxs[colIx];
                        if (ctx == null) continue;
                        if (((ColumnReadContext)ctx).rowIndex == null) {
                            if (this.isTracingEnabled) {
                                LOG.trace("Row index is null. Likely reading a file with indexes disabled.");
                            }
                            index = null;
                            nextIndex = null;
                        } else {
                            index = ((ColumnReadContext)ctx).rowIndex.getEntry(rgIx);
                            OrcProto.RowIndexEntry rowIndexEntry = nextIndex = isLastRg ? null : ((ColumnReadContext)ctx).rowIndex.getEntry(rgIx + 1);
                        }
                        if (this.isTracingEnabled) {
                            LOG.trace("ctx: {} rgIx: {} isLastRg: {} rgCount: {}", new Object[]{ctx, rgIx, isLastRg, rgCount});
                        }
                        ecb.initOrcColumn(((ColumnReadContext)ctx).colIx);
                        this.trace.logStartCol(((ColumnReadContext)ctx).colIx);
                        for (int streamIx = 0; streamIx < ((ColumnReadContext)ctx).streamCount; ++streamIx) {
                            StreamContext sctx = ((ColumnReadContext)ctx).streams[streamIx];
                            EncodedColumnBatch.ColumnStreamData cb = null;
                            try {
                                if (RecordReaderUtils.isDictionary((OrcProto.Stream.Kind)sctx.kind, (OrcProto.ColumnEncoding)((ColumnReadContext)ctx).encoding) || index == null) {
                                    if (sctx.stripeLevelStream == null) {
                                        if (this.isTracingEnabled) {
                                            LOG.trace("Getting stripe-level stream [" + String.valueOf(sctx.kind) + ", " + String.valueOf(((ColumnReadContext)ctx).encoding) + "] for column " + ((ColumnReadContext)ctx).colIx + " RG " + rgIx + " at " + sctx.offset + ", " + sctx.length);
                                        }
                                        this.trace.logStartStripeStream(sctx.kind);
                                        sctx.stripeLevelStream = (EncodedColumnBatch.ColumnStreamData)EncodedReaderImpl.POOLS.csdPool.take();
                                        sctx.stripeLevelStream.incRef();
                                        long unlockUntilCOffset = sctx.offset + sctx.length;
                                        DiskRangeList lastCached = this.readEncodedStream(stripeOffset, iter, sctx.offset, sctx.offset + sctx.length, sctx.stripeLevelStream, unlockUntilCOffset, sctx.offset, toRelease);
                                        if (lastCached != null) {
                                            iter = lastCached;
                                        }
                                    }
                                    sctx.stripeLevelStream.incRef();
                                    cb = sctx.stripeLevelStream;
                                } else {
                                    long unlockUntilCOffset;
                                    long nextCOffsetRel;
                                    long endCOffset;
                                    long cOffset;
                                    boolean isStartOfStream = sctx.bufferIter == null;
                                    DiskRangeList lastCached = this.readEncodedStream(stripeOffset, isStartOfStream ? iter : sctx.bufferIter, cOffset = sctx.offset + index.getPositions(sctx.streamIndexOffset), endCOffset = sctx.offset + EncodedReaderImpl.estimateRgEndOffset(this.isCompressed, isLastRg, nextCOffsetRel = isLastRg ? sctx.length : nextIndex.getPositions(sctx.streamIndexOffset), sctx.length, this.bufferSize), cb = this.createRgColumnStreamData(rgIx, isLastRg, ((ColumnReadContext)ctx).colIx, sctx, cOffset, endCOffset, this.isCompressed, unlockUntilCOffset = sctx.offset + nextCOffsetRel), unlockUntilCOffset, sctx.offset, toRelease);
                                    if (lastCached != null) {
                                        sctx.bufferIter = iter = lastCached;
                                    }
                                }
                                if (cb == null) continue;
                            }
                            catch (Exception ex) {
                                try {
                                    IOException iOException;
                                    DiskRangeList drl = toRead == null ? null : toRead.next;
                                    LOG.error("Error getting stream [" + String.valueOf(sctx.kind) + ", " + String.valueOf(((ColumnReadContext)ctx).encoding) + "] for column " + ((ColumnReadContext)ctx).colIx + " RG " + rgIx + " at " + sctx.offset + ", " + sctx.length + "; toRead " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)drl), (Throwable)ex);
                                    if (ex instanceof IOException) {
                                        iOException = (IOException)ex;
                                        throw iOException;
                                    }
                                    iOException = new IOException(ex);
                                    throw iOException;
                                }
                                catch (Throwable throwable) {
                                    if (cb == null) throw throwable;
                                    ecb.setStreamData(((ColumnReadContext)ctx).colIx, sctx.kind.getNumber(), cb);
                                    throw throwable;
                                }
                            }
                            ecb.setStreamData(((ColumnReadContext)ctx).colIx, sctx.kind.getNumber(), cb);
                        }
                    }
                    hasErrorForEcb = false;
                }
                finally {
                    if (hasErrorForEcb) {
                        this.releaseEcbRefCountsOnError(ecb);
                    }
                }
                try {
                    consumer.consumeData(ecb);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.error("IO thread interrupted while queueing data");
                    this.releaseEcbRefCountsOnError(ecb);
                    throw new IOException(e);
                }
            }
            if (this.isTracingEnabled) {
                LOG.trace("Disk ranges after preparing all the data " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)toRead.next));
            }
            this.trace.logRanges(this.fileKey, stripeOffset, toRead.next, IoTrace.RangesSrc.PREREAD);
            hasError = false;
        }
        catch (Throwable throwable) {
            try {
                int colIx = 0;
                while (true) {
                    if (colIx >= colCtxs.length) {
                        this.releaseInitialRefcounts(toRead.next);
                        this.releaseBuffers(toRelease.keySet(), true);
                        throw throwable;
                    }
                    ReadContext ctx = colCtxs[colIx];
                    if (ctx != null) {
                        for (int streamIx = 0; streamIx < ((ColumnReadContext)ctx).streamCount; ++streamIx) {
                            StreamContext sctx = ((ColumnReadContext)ctx).streams[streamIx];
                            if (sctx == null || sctx.stripeLevelStream == null || 0 != sctx.stripeLevelStream.decRef()) continue;
                            for (MemoryBuffer buf : sctx.stripeLevelStream.getCacheBuffers()) {
                                LOG.trace("Unlocking {} at the end of processing", (Object)buf);
                                this.cacheWrapper.releaseBuffer(buf);
                            }
                        }
                    }
                    ++colIx;
                }
            }
            catch (Throwable t) {
                if (!hasError) {
                    throw new IOException(t);
                }
                LOG.error("Error during the cleanup after another error; ignoring", t);
            }
            throw throwable;
        }
        try {
            int colIx = 0;
            while (true) {
                if (colIx >= colCtxs.length) {
                    this.releaseInitialRefcounts(toRead.next);
                    this.releaseBuffers(toRelease.keySet(), true);
                    return;
                }
                ReadContext ctx = colCtxs[colIx];
                if (ctx != null) {
                    for (int streamIx = 0; streamIx < ((ColumnReadContext)ctx).streamCount; ++streamIx) {
                        StreamContext sctx = ((ColumnReadContext)ctx).streams[streamIx];
                        if (sctx == null || sctx.stripeLevelStream == null || 0 != sctx.stripeLevelStream.decRef()) continue;
                        for (MemoryBuffer buf : sctx.stripeLevelStream.getCacheBuffers()) {
                            LOG.trace("Unlocking {} at the end of processing", (Object)buf);
                            this.cacheWrapper.releaseBuffer(buf);
                        }
                    }
                }
                ++colIx;
            }
        }
        catch (Throwable t) {
            if (!hasError) {
                throw new IOException(t);
            }
            LOG.error("Error during the cleanup after another error; ignoring", t);
            return;
        }
    }

    private static int countMaxStreams(StreamName.Area area) {
        int count = 0;
        for (OrcProto.Stream.Kind sk : OrcProto.Stream.Kind.values()) {
            if (StreamName.getArea((OrcProto.Stream.Kind)sk) != area) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskRangeList.MutateHelper getDataFromCacheAndDisk(DiskRangeList listToRead, long stripeOffset, boolean hasFileId, IdentityHashMap<ByteBuffer, Boolean> toRelease) throws IOException {
        DiskRangeList.MutateHelper toRead = new DiskRangeList.MutateHelper(listToRead);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting disk ranges to read (file " + String.valueOf(this.fileKey) + "): " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)toRead.next));
        }
        DataCache.BooleanRef isAllInCache = new DataCache.BooleanRef();
        if (hasFileId) {
            this.cacheWrapper.getFileData(this.fileKey, toRead.next, stripeOffset, CC_FACTORY, isAllInCache);
            if (!isAllInCache.value) {
                LlapHiveUtils.throwIfCacheOnlyRead(this.isReadCacheOnly);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disk ranges after cache (found everything " + isAllInCache.value + "; file " + String.valueOf(this.fileKey) + ", base offset " + stripeOffset + "): " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)toRead.next));
            }
            this.trace.logRanges(this.fileKey, stripeOffset, toRead.next, IoTrace.RangesSrc.CACHE);
        }
        if (!isAllInCache.value) {
            boolean hasError = true;
            try {
                if (!this.isDataReaderOpen) {
                    this.dataReader.open();
                    this.isDataReaderOpen = true;
                }
                this.dataReader.readFileData(toRead.next, stripeOffset, this.cacheWrapper.getAllocator().isDirectAlloc());
                DiskRangeList drl = toRead.next;
                while (drl != null) {
                    if (drl instanceof BufferChunk) {
                        toRelease.put(drl.getData(), true);
                    }
                    drl = drl.next;
                }
                hasError = false;
            }
            finally {
                if (hasError) {
                    this.releaseInitialRefcounts(toRead.next);
                }
            }
        }
        return toRead;
    }

    private void releaseEcbRefCountsOnError(Reader.OrcEncodedColumnBatch ecb) {
        try {
            if (this.isTracingEnabled) {
                LOG.trace("Unlocking the batch not sent to consumer, on error");
            }
            for (int colIx = 0; colIx < ecb.getTotalColCount(); ++colIx) {
                EncodedColumnBatch.ColumnStreamData[] datas;
                if (!ecb.hasData(colIx)) continue;
                for (EncodedColumnBatch.ColumnStreamData data : datas = ecb.getColumnData(colIx)) {
                    if (data == null || data.decRef() != 0) continue;
                    for (MemoryBuffer buf : data.getCacheBuffers()) {
                        if (buf == null) continue;
                        this.cacheWrapper.releaseBuffer(buf);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Error during the cleanup of an error; ignoring", t);
        }
    }

    private static String arrayToString(boolean[] a) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length; ++i) {
            b.append(a[i] ? "1" : "0");
        }
        b.append(']');
        return b.toString();
    }

    private EncodedColumnBatch.ColumnStreamData createRgColumnStreamData(int rgIx, boolean isLastRg, int colIx, StreamContext sctx, long cOffset, long endCOffset, boolean isCompressed, long unlockUntilCOffset) {
        EncodedColumnBatch.ColumnStreamData cb = (EncodedColumnBatch.ColumnStreamData)EncodedReaderImpl.POOLS.csdPool.take();
        cb.incRef();
        if (this.isTracingEnabled) {
            LOG.trace("Getting data for column " + colIx + " " + (isLastRg ? "last " : "") + "RG " + rgIx + " stream " + String.valueOf(sctx.kind) + " at " + sctx.offset + ", " + sctx.length + " index position " + sctx.streamIndexOffset + ": " + (isCompressed ? "" : "un") + "compressed [" + cOffset + ", " + endCOffset + ")");
        }
        this.trace.logStartStream(sctx.kind, cOffset, endCOffset, unlockUntilCOffset);
        return cb;
    }

    private void releaseInitialRefcounts(DiskRangeList current) {
        while (current != null) {
            CacheChunk cc;
            DiskRangeList toFree = current;
            current = current.next;
            if (toFree instanceof ProcCacheChunk) {
                ProcCacheChunk pcc = (ProcCacheChunk)toFree;
                if (pcc.originalData != null) {
                    if (pcc.getBuffer() == null) continue;
                    this.cacheWrapper.getAllocator().deallocate(pcc.getBuffer());
                    continue;
                }
            }
            if (!(toFree instanceof CacheChunk) || (cc = (CacheChunk)toFree).getBuffer() == null) continue;
            MemoryBuffer buffer = cc.getBuffer();
            this.cacheWrapper.releaseBuffer(buffer);
            cc.setBuffer(null);
        }
    }

    @Override
    public void setTracing(boolean isEnabled) {
        this.isTracingEnabled = isEnabled;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.codec != null) {
                if (this.isCodecFromPool && !this.isCodecFailure) {
                    OrcCodecPool.returnCodec((CompressionKind)this.compressionKind, (CompressionCodec)this.codec);
                } else {
                    this.codec.close();
                }
                this.codec = null;
            }
        }
        catch (Exception ex) {
            LOG.error("Ignoring error from codec", (Throwable)ex);
        }
        finally {
            this.dataReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DiskRangeList readEncodedStream(long baseOffset, DiskRangeList start, long cOffset, long endCOffset, EncodedColumnBatch.ColumnStreamData csd, long unlockUntilCOffset, long streamOffset, IdentityHashMap<ByteBuffer, Boolean> toRelease) throws IOException {
        void var23_26;
        DiskRange[] cacheKeys;
        MemoryBuffer[] targetBuffers;
        CacheChunk lastUncompressed;
        ArrayList<ByteBuffer> toReleaseCopies;
        ArrayList<ProcCacheChunk> toDecompress;
        block39: {
            if (csd.getCacheBuffers() == null) {
                csd.setCacheBuffers(new ArrayList());
            } else {
                csd.getCacheBuffers().clear();
            }
            if (cOffset == endCOffset) {
                return null;
            }
            toDecompress = null;
            ArrayList<IncompleteCb> badEstimates = null;
            toReleaseCopies = null;
            if (this.isCompressed) {
                toReleaseCopies = new ArrayList<ByteBuffer>();
                toDecompress = new ArrayList<ProcCacheChunk>();
                badEstimates = new ArrayList<IncompleteCb>();
            }
            DiskRangeList current = EncodedReaderImpl.findExactPosition(start, cOffset);
            if (this.isTracingEnabled) {
                LOG.trace("Starting read for [" + cOffset + "," + endCOffset + ") at " + String.valueOf(current));
            }
            this.trace.logStartRead(current);
            lastUncompressed = null;
            try {
                lastUncompressed = this.isCompressed ? this.prepareRangesForCompressedRead(cOffset, endCOffset, streamOffset, unlockUntilCOffset, current, csd, toRelease, toReleaseCopies, toDecompress, badEstimates) : this.prepareRangesForUncompressedRead(cOffset, endCOffset, streamOffset, unlockUntilCOffset, current, csd);
            }
            catch (Exception ex) {
                LOG.error("Failed " + (this.isCompressed ? "" : "un") + "compressed read; cOffset " + cOffset + ", endCOffset " + endCOffset + ", streamOffset " + streamOffset + ", unlockUntilCOffset " + unlockUntilCOffset + "; ranges passed in " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)start) + "; ranges passed to prepare " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)current));
                throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
            }
            if (badEstimates != null && !badEstimates.isEmpty()) {
                DiskRange[] cacheKeys2 = badEstimates.toArray(new DiskRange[badEstimates.size()]);
                long[] result = this.cacheWrapper.putFileData(this.fileKey, cacheKeys2, null, baseOffset, this.tag);
                assert (result == null);
            }
            if (toDecompress == null || toDecompress.isEmpty()) {
                this.releaseBuffers(toReleaseCopies, false);
                return lastUncompressed;
            }
            targetBuffers = new MemoryBuffer[toDecompress.size()];
            cacheKeys = new DiskRange[toDecompress.size()];
            int ix = 0;
            for (ProcCacheChunk procCacheChunk : toDecompress) {
                cacheKeys[ix] = procCacheChunk;
                targetBuffers[ix] = procCacheChunk.getBuffer();
                ++ix;
            }
            boolean isAllocated = false;
            try {
                this.allocateMultiple(targetBuffers, this.bufferSize);
                isAllocated = true;
                if (isAllocated) break block39;
            }
            catch (Throwable throwable) {
                if (!isAllocated) {
                    for (MemoryBuffer buf : targetBuffers) {
                        csd.getCacheBuffers().remove(buf);
                    }
                    for (ProcCacheChunk chunk : toDecompress) {
                        chunk.buffer = null;
                    }
                }
                throw throwable;
            }
            for (MemoryBuffer buf : targetBuffers) {
                csd.getCacheBuffers().remove(buf);
            }
            for (ProcCacheChunk chunk : toDecompress) {
                chunk.buffer = null;
            }
        }
        boolean bl = false;
        try {
            void var23_25;
            while (var23_25 < toDecompress.size()) {
                ProcCacheChunk chunk = (ProcCacheChunk)((Object)toDecompress.get((int)var23_25));
                ByteBuffer dest = chunk.getBuffer().getByteBufferRaw();
                if (chunk.isOriginalDataCompressed) {
                    boolean isOk = false;
                    try {
                        EncodedReaderImpl.decompressChunk(chunk.originalData, this.codec, dest);
                        isOk = true;
                    }
                    finally {
                        if (!isOk) {
                            this.isCodecFailure = true;
                        }
                    }
                } else {
                    EncodedReaderImpl.copyUncompressedChunk(chunk.originalData, dest);
                }
                if (this.isTracingEnabled) {
                    LOG.trace("Locking " + String.valueOf(chunk.getBuffer()) + " due to reuse (after decompression)");
                }
                try {
                    this.cacheWrapper.reuseBuffer(chunk.getBuffer());
                }
                finally {
                    chunk.originalData = null;
                }
                ++var23_25;
            }
        }
        catch (Throwable throwable) {
            void var23_27;
            while (var23_27 < toDecompress.size()) {
                ProcCacheChunk chunk = (ProcCacheChunk)((Object)toDecompress.get((int)var23_27));
                csd.getCacheBuffers().remove(chunk.getBuffer());
                try {
                    this.cacheWrapper.getAllocator().deallocate(chunk.getBuffer());
                }
                catch (Throwable t) {
                    LOG.error("Ignoring the cleanup error after another error", t);
                }
                chunk.setBuffer(null);
                ++var23_27;
            }
            throw throwable;
        }
        while (var23_26 < toDecompress.size()) {
            ProcCacheChunk chunk = (ProcCacheChunk)((Object)toDecompress.get((int)var23_26));
            csd.getCacheBuffers().remove(chunk.getBuffer());
            try {
                this.cacheWrapper.getAllocator().deallocate(chunk.getBuffer());
            }
            catch (Throwable t) {
                LOG.error("Ignoring the cleanup error after another error", t);
            }
            chunk.setBuffer(null);
            ++var23_26;
        }
        this.releaseBuffers(toReleaseCopies, false);
        if (this.fileKey != null) {
            long[] collisionMask = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, targetBuffers, baseOffset, this.tag);
            this.processCacheCollisions(collisionMask, toDecompress, targetBuffers, csd.getCacheBuffers());
        }
        for (ProcCacheChunk chunk : toDecompress) {
            this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, chunk);
        }
        return lastUncompressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preReadDataRanges(DiskRangeList ranges) throws IOException {
        boolean hasFileId = this.fileKey != null;
        long baseOffset = 0L;
        IdentityHashMap<ByteBuffer, Boolean> toRelease = new IdentityHashMap<ByteBuffer, Boolean>();
        DiskRangeList.MutateHelper toRead = this.getDataFromCacheAndDisk(ranges, 0L, hasFileId, toRelease);
        this.preReadUncompressedStreams(baseOffset, toRead, toRelease);
        EncodedColumnBatch.ColumnStreamData csd = (EncodedColumnBatch.ColumnStreamData)EncodedReaderImpl.POOLS.csdPool.take();
        try {
            csd.incRef();
            DiskRangeList drl = toRead.next;
            while (drl != null) {
                drl = this.readEncodedStream(baseOffset, drl, drl.getOffset(), drl.getEnd(), csd, drl.getOffset(), drl.getEnd(), toRelease);
                for (MemoryBuffer buf : csd.getCacheBuffers()) {
                    this.cacheWrapper.releaseBuffer(buf);
                }
                if (drl == null) continue;
                drl = drl.next;
            }
        }
        finally {
            if (toRead != null) {
                this.releaseInitialRefcounts(toRead.next);
            }
            if (toRelease != null) {
                this.releaseBuffers(toRelease.keySet(), true);
                toRelease.clear();
            }
            if (csd != null) {
                csd.decRef();
                EncodedReaderImpl.POOLS.csdPool.offer((Object)csd);
            }
        }
    }

    private void preReadUncompressedStreams(long baseOffset, DiskRangeList.MutateHelper toRead, IdentityHashMap<ByteBuffer, Boolean> toRelease) throws IOException {
        if (this.isCompressed) {
            return;
        }
        DiskRangeList iter = toRead.next;
        while (iter != null) {
            DiskRangeList newIter = this.preReadUncompressedStream(baseOffset, iter, iter.getOffset(), iter.getOffset() + (long)iter.getLength(), OrcProto.Stream.Kind.DATA);
            iter = newIter != null ? newIter.next : null;
        }
        if (toRelease != null) {
            this.releaseBuffers(toRelease.keySet(), true);
            toRelease.clear();
        }
    }

    private CacheChunk prepareRangesForCompressedRead(long cOffset, long endCOffset, long streamOffset, long unlockUntilCOffset, DiskRangeList current, EncodedColumnBatch.ColumnStreamData columnStreamData, IdentityHashMap<ByteBuffer, Boolean> toRelease, List<ByteBuffer> toReleaseCopies, List<ProcCacheChunk> toDecompress, List<IncompleteCb> badEstimates) throws IOException {
        if (cOffset > current.getOffset()) {
            current = current.split((long)cOffset).next;
        }
        long currentOffset = cOffset;
        CacheChunk lastUncompressed = null;
        while (true) {
            DiskRangeList next = null;
            if (current instanceof CacheChunk) {
                CacheChunk cc = (CacheChunk)current;
                if (this.isTracingEnabled) {
                    LOG.trace("Locking " + String.valueOf(cc.getBuffer()) + " due to reuse");
                }
                this.cacheWrapper.reuseBuffer(cc.getBuffer());
                columnStreamData.getCacheBuffers().add(cc.getBuffer());
                currentOffset = cc.getEnd();
                if (this.isTracingEnabled) {
                    LOG.trace("Adding an already-uncompressed buffer " + String.valueOf(cc.getBuffer()));
                }
                this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, cc);
                lastUncompressed = cc;
                next = current.next;
                if (next != null && endCOffset >= 0L && currentOffset < endCOffset && next.getOffset() >= endCOffset) {
                    throw new IOException("Expected data at " + currentOffset + " (reading until " + endCOffset + "), but the next buffer starts at " + next.getOffset());
                }
            } else if (current instanceof IncompleteCb) {
                if (this.isTracingEnabled) {
                    LOG.trace("Cannot read " + String.valueOf(current));
                }
                next = null;
                currentOffset = -1L;
            } else {
                if (!(current instanceof BufferChunk)) {
                    String msg = "Found an unexpected " + current.getClass().getSimpleName() + ": " + String.valueOf(current) + " while looking at " + currentOffset;
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
                BufferChunk bc = (BufferChunk)current;
                ProcCacheChunk newCached = this.addOneCompressionBuffer(bc, columnStreamData.getCacheBuffers(), toDecompress, toRelease, toReleaseCopies, badEstimates);
                lastUncompressed = newCached == null ? lastUncompressed : newCached;
                next = newCached != null ? newCached.next : null;
                long l = currentOffset = next != null ? next.getOffset() : -1L;
            }
            if (next == null || endCOffset >= 0L && currentOffset >= endCOffset) break;
            current = next;
        }
        return lastUncompressed;
    }

    private CacheChunk prepareRangesForUncompressedRead(long cOffset, long endCOffset, long streamOffset, long unlockUntilCOffset, DiskRangeList current, EncodedColumnBatch.ColumnStreamData columnStreamData) throws IOException {
        long currentOffset = cOffset;
        CacheChunk lastUncompressed = null;
        boolean isFirst = true;
        while (true) {
            DiskRangeList next = null;
            assert (current instanceof CacheChunk);
            lastUncompressed = (CacheChunk)current;
            if (this.isTracingEnabled) {
                LOG.trace("Locking " + String.valueOf(lastUncompressed.getBuffer()) + " due to reuse");
            }
            this.cacheWrapper.reuseBuffer(lastUncompressed.getBuffer());
            if (isFirst) {
                columnStreamData.setIndexBaseOffset((int)(lastUncompressed.getOffset() - streamOffset));
                isFirst = false;
            }
            columnStreamData.getCacheBuffers().add(lastUncompressed.getBuffer());
            currentOffset = lastUncompressed.getEnd();
            if (this.isTracingEnabled) {
                LOG.trace("Adding an uncompressed buffer " + String.valueOf(lastUncompressed.getBuffer()));
            }
            this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, lastUncompressed);
            next = current.next;
            if (next == null || endCOffset >= 0L && currentOffset >= endCOffset) break;
            current = next;
        }
        return lastUncompressed;
    }

    private DiskRangeList preReadUncompressedStream(long baseOffset, DiskRangeList start, long streamOffset, long streamEnd, OrcProto.Stream.Kind kind) throws IOException {
        if (streamOffset == streamEnd) {
            return null;
        }
        ArrayList<UncompressedCacheChunk> toCache = null;
        DiskRangeList current = EncodedReaderImpl.findIntersectingPosition(start, streamOffset, streamEnd);
        if (this.isTracingEnabled) {
            LOG.trace("Starting pre-read for [" + streamOffset + "," + streamEnd + ") at " + String.valueOf(current));
        }
        this.trace.logStartStream(kind, streamOffset, streamEnd, streamOffset);
        this.trace.logStartRead(current);
        if (streamOffset > current.getOffset()) {
            current = current.split((long)streamOffset).next;
        }
        long streamLen = streamEnd - streamOffset;
        int partSize = this.determineUncompressedPartSize();
        int partCount = (int)(streamLen / (long)partSize) + (streamLen % (long)partSize != 0L ? 1 : 0);
        CacheChunk lastUncompressed = null;
        MemoryBuffer[] singleAlloc = new MemoryBuffer[1];
        for (int i = 0; i < partCount; ++i) {
            long partOffset = streamOffset + (long)(i * partSize);
            long partEnd = Math.min(partOffset + (long)partSize, streamEnd);
            long hasEntirePartTo = partOffset;
            if (current == null) break;
            assert (partOffset <= current.getOffset());
            if (partOffset == current.getOffset() && current instanceof CacheChunk) {
                assert (current.getOffset() == partOffset && current.getEnd() == partEnd);
                lastUncompressed = (CacheChunk)current;
                current = current.next;
                continue;
            }
            if (current.getOffset() >= partEnd) continue;
            UncompressedCacheChunk candidateCached = null;
            DiskRangeList next = current;
            while (true) {
                boolean noMoreDataForPart;
                boolean bl = noMoreDataForPart = next == null || next.getOffset() >= partEnd;
                if (noMoreDataForPart && hasEntirePartTo < partEnd && candidateCached != null) {
                    lastUncompressed = this.copyAndReplaceCandidateToNonCached(candidateCached, partOffset, hasEntirePartTo, this.cacheWrapper, singleAlloc);
                    candidateCached = null;
                }
                current = next;
                if (noMoreDataForPart) break;
                if (current.getEnd() > partEnd) {
                    current = current.split(partEnd);
                }
                if (this.isTracingEnabled) {
                    LOG.trace("Processing uncompressed file data at [" + current.getOffset() + ", " + current.getEnd() + ")");
                }
                this.trace.logUncompressedData(current.getOffset(), current.getEnd());
                BufferChunk curBc = (BufferChunk)current;
                long hadEntirePartTo = hasEntirePartTo;
                long l = hasEntirePartTo = hasEntirePartTo == current.getOffset() ? current.getEnd() : -1L;
                if (hasEntirePartTo == -1L) {
                    if (candidateCached != null) {
                        assert (hadEntirePartTo != -1L);
                        this.copyAndReplaceCandidateToNonCached(candidateCached, partOffset, hadEntirePartTo, this.cacheWrapper, singleAlloc);
                        candidateCached = null;
                    }
                    lastUncompressed = this.copyAndReplaceUncompressedToNonCached(curBc, this.cacheWrapper, singleAlloc);
                    next = lastUncompressed.next;
                    continue;
                }
                if (candidateCached == null) {
                    candidateCached = new UncompressedCacheChunk(curBc);
                } else {
                    candidateCached.addChunk(curBc);
                }
                next = current.next;
            }
            if (candidateCached == null) continue;
            if (toCache == null) {
                toCache = new ArrayList<UncompressedCacheChunk>(partCount - i);
            }
            toCache.add(candidateCached);
        }
        if (toCache == null) {
            return lastUncompressed;
        }
        MemoryBuffer[] targetBuffers = toCache.size() == 1 ? singleAlloc : new MemoryBuffer[toCache.size()];
        targetBuffers[0] = null;
        DiskRange[] cacheKeys = new DiskRange[toCache.size()];
        int ix = 0;
        for (UncompressedCacheChunk chunk : toCache) {
            cacheKeys[ix] = chunk;
            ++ix;
        }
        this.allocateMultiple(targetBuffers, (int)(partCount == 1 ? streamLen : (long)partSize));
        ix = 0;
        for (UncompressedCacheChunk candidateCached : toCache) {
            candidateCached.setBuffer(targetBuffers[ix]);
            ByteBuffer dest = candidateCached.getBuffer().getByteBufferRaw();
            this.copyAndReplaceUncompressedChunks(candidateCached, dest, candidateCached, true);
            candidateCached.clear();
            lastUncompressed = candidateCached;
            ++ix;
        }
        if (this.fileKey != null) {
            long[] collisionMask = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, targetBuffers, baseOffset, this.tag);
            this.processCacheCollisions(collisionMask, toCache, targetBuffers, null);
        }
        return lastUncompressed;
    }

    private int determineUncompressedPartSize() {
        long orcCbSizeDefault = ((Number)OrcConf.BUFFER_SIZE.getDefaultValue()).longValue();
        int maxAllocSize = this.cacheWrapper.getAllocator().getMaxAllocation();
        return (int)Math.min((long)maxAllocSize, orcCbSizeDefault);
    }

    private static void copyUncompressedChunk(ByteBuffer src, ByteBuffer dest) {
        int startPos = dest.position();
        int startLim = dest.limit();
        dest.put(src);
        int newPos = dest.position();
        if (newPos > startLim) {
            throw new AssertionError((Object)("After copying, buffer [" + startPos + ", " + startLim + ") became [" + newPos + ", " + dest.limit() + ")"));
        }
        dest.position(startPos);
        dest.limit(newPos);
    }

    private CacheChunk copyAndReplaceCandidateToNonCached(UncompressedCacheChunk candidateCached, long partOffset, long candidateEnd, DataCache cacheWrapper, MemoryBuffer[] singleAlloc) {
        singleAlloc[0] = null;
        this.trace.logPartialUncompressedData(partOffset, candidateEnd, true);
        this.allocateMultiple(singleAlloc, (int)(candidateEnd - partOffset));
        MemoryBuffer buffer = singleAlloc[0];
        cacheWrapper.reuseBuffer(buffer);
        ByteBuffer dest = buffer.getByteBufferRaw();
        CacheChunk tcc = new CacheChunk(buffer, partOffset, candidateEnd);
        this.copyAndReplaceUncompressedChunks(candidateCached, dest, tcc, false);
        return tcc;
    }

    private void allocateMultiple(MemoryBuffer[] dest, int size) {
        if (this.allocator != null) {
            this.allocator.allocateMultiple(dest, size, this.cacheWrapper.getDataBufferFactory(), this.isStopped);
        } else {
            this.cacheWrapper.getAllocator().allocateMultiple(dest, size, this.cacheWrapper.getDataBufferFactory());
        }
    }

    private CacheChunk copyAndReplaceUncompressedToNonCached(BufferChunk bc, DataCache cacheWrapper, MemoryBuffer[] singleAlloc) {
        singleAlloc[0] = null;
        this.trace.logPartialUncompressedData(bc.getOffset(), bc.getEnd(), false);
        this.allocateMultiple(singleAlloc, bc.getLength());
        MemoryBuffer buffer = singleAlloc[0];
        cacheWrapper.reuseBuffer(buffer);
        ByteBuffer dest = buffer.getByteBufferRaw();
        CacheChunk tcc = new CacheChunk(buffer, bc.getOffset(), bc.getEnd());
        EncodedReaderImpl.copyUncompressedChunk(bc.getData(), dest);
        bc.replaceSelfWith((DiskRangeList)tcc);
        return tcc;
    }

    private void copyAndReplaceUncompressedChunks(UncompressedCacheChunk candidateCached, ByteBuffer dest, CacheChunk tcc, boolean isValid) {
        int startPos = dest.position();
        int startLim = dest.limit();
        DiskRangeList next = null;
        for (int i = 0; i < candidateCached.getCount(); ++i) {
            BufferChunk chunk = i == 0 ? candidateCached.getChunk() : (BufferChunk)next;
            dest.put(chunk.getData());
            if (isValid) {
                this.trace.logValidUncompressedChunk(startLim - startPos, (DiskRange)chunk);
            }
            next = chunk.next;
            if (i == 0) {
                chunk.replaceSelfWith((DiskRangeList)tcc);
                continue;
            }
            chunk.removeSelf();
        }
        int newPos = dest.position();
        if (newPos > startLim) {
            throw new AssertionError((Object)("After copying, buffer [" + startPos + ", " + startLim + ") became [" + newPos + ", " + dest.limit() + ")"));
        }
        dest.position(startPos);
        dest.limit(newPos);
    }

    private static void decompressChunk(ByteBuffer src, CompressionCodec codec, ByteBuffer dest) throws IOException {
        int startPos = dest.position();
        int startLim = dest.limit();
        int startSrcPos = src.position();
        int startSrcLim = src.limit();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Decompressing " + src.remaining() + " bytes to dest buffer pos " + dest.position() + ", limit " + dest.limit());
        }
        codec.reset();
        codec.decompress(src, dest);
        dest.position(startPos);
        int newLim = dest.limit();
        if (newLim > startLim) {
            throw new AssertionError((Object)("After codec, buffer [" + startPos + ", " + startLim + ") became [" + dest.position() + ", " + newLim + ")"));
        }
        if (dest.remaining() == 0) {
            throw new IOException("The codec has produced 0 bytes for {" + src.isDirect() + ", " + src.position() + ", " + src.remaining() + "} into {" + dest.isDirect() + ", " + dest.position() + ", " + dest.remaining() + "}");
        }
    }

    private void ponderReleaseInitialRefcount(long unlockUntilCOffset, long streamStartOffset, CacheChunk cc) {
        if (cc.getEnd() > unlockUntilCOffset) {
            return;
        }
        assert (cc.getBuffer() != null);
        try {
            this.releaseInitialRefcount(cc, false);
        }
        catch (AssertionError e) {
            LOG.error("BUG: releasing initial refcount; stream start " + streamStartOffset + ", unlocking until " + unlockUntilCOffset + " from [" + String.valueOf((Object)cc) + "]: " + ((Throwable)((Object)e)).getMessage());
            throw e;
        }
        DiskRangeList prev = cc.prev;
        while (prev != null && prev.getEnd() > streamStartOffset && prev.getClass() == CacheChunk.class) {
            CacheChunk prevCc = (CacheChunk)prev;
            if (prevCc.buffer == null) break;
            try {
                this.releaseInitialRefcount(prevCc, true);
            }
            catch (AssertionError e) {
                LOG.error("BUG: releasing initial refcount; stream start " + streamStartOffset + ", unlocking until " + unlockUntilCOffset + " from [" + String.valueOf((Object)cc) + "] and backtracked to [" + String.valueOf((Object)prevCc) + "]: " + ((Throwable)((Object)e)).getMessage());
                throw e;
            }
            prev = prev.prev;
        }
    }

    private void releaseInitialRefcount(CacheChunk cc, boolean isBacktracking) {
        if (this.isTracingEnabled) {
            LOG.trace("Unlocking " + String.valueOf(cc.getBuffer()) + " for the fetching thread" + (isBacktracking ? "; backtracking" : ""));
        }
        this.cacheWrapper.releaseBuffer(cc.getBuffer());
        cc.setBuffer(null);
    }

    private void processCacheCollisions(long[] collisionMask, List<? extends CacheChunk> toDecompress, MemoryBuffer[] targetBuffers, List<MemoryBuffer> cacheBuffers) {
        if (collisionMask == null) {
            return;
        }
        assert (collisionMask.length >= toDecompress.size() >>> 6);
        long maskVal = -1L;
        for (int i = 0; i < toDecompress.size(); ++i) {
            if ((i & 0x3F) == 0) {
                maskVal = collisionMask[i >>> 6];
            }
            if ((maskVal & 1L) == 1L) {
                CacheChunk replacedChunk = toDecompress.get(i);
                MemoryBuffer replacementBuffer = targetBuffers[i];
                if (this.isTracingEnabled) {
                    LOG.trace("Discarding data due to cache collision: " + String.valueOf(replacedChunk.getBuffer()) + " replaced with " + String.valueOf(replacementBuffer));
                }
                this.trace.logCacheCollision((DiskRange)replacedChunk, replacementBuffer);
                assert (replacedChunk.getBuffer() != replacementBuffer) : i + " was not replaced in the results even though mask is [" + Long.toBinaryString(maskVal) + "]";
                replacedChunk.handleCacheCollision(this.cacheWrapper, replacementBuffer, cacheBuffers);
            }
            maskVal >>= 1;
        }
    }

    private static DiskRangeList findExactPosition(DiskRangeList ranges, long offset) {
        if (offset < 0L) {
            return ranges;
        }
        ranges = EncodedReaderImpl.findUpperBound(ranges, offset);
        if (offset < (ranges = EncodedReaderImpl.findLowerBound(ranges, offset)).getOffset() || offset >= ranges.getEnd()) {
            EncodedReaderImpl.throwRangesError(ranges, offset, offset);
        }
        return ranges;
    }

    private static DiskRangeList findIntersectingPosition(DiskRangeList ranges, long offset, long end) {
        if (offset < 0L) {
            return ranges;
        }
        ranges = EncodedReaderImpl.findUpperBound(ranges, offset);
        ranges = EncodedReaderImpl.findLowerBound(ranges, end);
        while (ranges.prev != null && ranges.prev.getEnd() > offset) {
            if (ranges.prev.getEnd() > ranges.getOffset()) {
                EncodedReaderImpl.throwRangesError(ranges, offset, end);
            }
            ranges = ranges.prev;
        }
        return ranges;
    }

    public static DiskRangeList findLowerBound(DiskRangeList ranges, long end) {
        while (ranges.getOffset() > end) {
            if (ranges.prev.getEnd() > ranges.getOffset()) {
                EncodedReaderImpl.throwRangesError(ranges, end, end);
            }
            ranges = ranges.prev;
        }
        return ranges;
    }

    public static DiskRangeList findUpperBound(DiskRangeList ranges, long offset) {
        while (ranges.getEnd() <= offset) {
            if (ranges.next.getOffset() < ranges.getEnd()) {
                EncodedReaderImpl.throwRangesError(ranges, offset, offset);
            }
            ranges = ranges.next;
        }
        return ranges;
    }

    private static void throwRangesError(DiskRangeList ranges, long offset, long end) {
        IdentityHashMap<DiskRangeList, Boolean> seen = new IdentityHashMap<DiskRangeList, Boolean>();
        seen.put(ranges, true);
        StringBuilder errors = new StringBuilder();
        while (ranges.prev != null) {
            if (ranges.prev.next != ranges) {
                errors.append("inconsistent list going back: [").append(ranges).append("].prev = [").append(ranges.prev).append("]; prev.next = [").append(ranges.prev.next).append("]; ");
                break;
            }
            if (seen.containsKey(ranges.prev)) {
                errors.append("loop: [").append(ranges).append("].prev = [").append(ranges.prev).append("]; ");
                break;
            }
            ranges = ranges.prev;
            seen.put(ranges, true);
        }
        seen.clear();
        seen.put(ranges, true);
        StringBuilder sb = new StringBuilder("Incorrect ranges detected while looking for ");
        if (offset == end) {
            sb.append(offset);
        } else {
            sb.append("[").append(offset).append(", ").append(end).append(")");
        }
        sb.append(": [").append(ranges).append("], ");
        while (ranges.next != null) {
            if (ranges.next.prev != ranges) {
                errors.append("inconsistent list going forward: [").append(ranges).append("].next.prev = [").append(ranges.next.prev).append("]; ");
            }
            if (seen.containsKey(ranges.next)) {
                errors.append("loop: [").append(ranges).append("].next = [").append(ranges.next).append("]; ");
                break;
            }
            ranges = ranges.next;
            sb.append("[").append(ranges).append("], ");
            seen.put(ranges, true);
        }
        sb.append("; ").append((CharSequence)errors);
        String error = sb.toString();
        LOG.error(error);
        throw new RuntimeException(error);
    }

    private ProcCacheChunk addOneCompressionBuffer(BufferChunk current, List<MemoryBuffer> cacheBuffers, List<ProcCacheChunk> toDecompress, IdentityHashMap<ByteBuffer, Boolean> toRelease, List<ByteBuffer> toReleaseCopies, List<IncompleteCb> badEstimates) throws IOException {
        DiskRangeList tmp;
        boolean isUncompressed;
        ByteBuffer slice = null;
        ByteBuffer compressed = current.getData();
        long cbStartOffset = current.getOffset();
        int b0 = -1;
        int b1 = -1;
        int b2 = -1;
        if (compressed.remaining() >= 3) {
            b0 = compressed.get() & 0xFF;
            b1 = compressed.get() & 0xFF;
            b2 = compressed.get() & 0xFF;
        } else {
            int[] bytes = new int[3];
            if ((current = EncodedReaderImpl.readLengthBytesFromSmallBuffers(current, cbStartOffset, bytes, badEstimates, this.isTracingEnabled, this.trace)) == null) {
                return null;
            }
            compressed = current.getData();
            b0 = bytes[0];
            b1 = bytes[1];
            b2 = bytes[2];
        }
        int chunkLength = b2 << 15 | b1 << 7 | b0 >> 1;
        if (chunkLength > this.bufferSize) {
            throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
        }
        int consumedLength = chunkLength + 3;
        long cbEndOffset = cbStartOffset + (long)consumedLength;
        boolean bl = isUncompressed = (b0 & 1) == 1;
        if (this.isTracingEnabled) {
            LOG.trace("Found CB at " + cbStartOffset + ", chunk length " + chunkLength + ", total " + consumedLength + ", " + (isUncompressed ? "not " : "") + "compressed");
        }
        this.trace.logOrcCb(cbStartOffset, chunkLength, isUncompressed);
        if (compressed.remaining() >= chunkLength) {
            slice = compressed.slice();
            slice.limit(chunkLength);
            return this.addOneCompressionBlockByteBuffer(slice, isUncompressed, cbStartOffset, cbEndOffset, chunkLength, current, toDecompress, cacheBuffers, false);
        }
        if (current.getEnd() < cbEndOffset && !current.hasContiguousNext()) {
            badEstimates.add(EncodedReaderImpl.addIncompleteCompressionBuffer(cbStartOffset, (DiskRangeList)current, 0, this.isTracingEnabled, this.trace));
            return null;
        }
        ByteBuffer copy = EncodedReaderImpl.allocateBuffer(chunkLength, compressed.isDirect());
        toReleaseCopies.add(copy);
        int remaining = chunkLength - compressed.remaining();
        int originalPos = compressed.position();
        copy.put(compressed);
        if (this.isTracingEnabled) {
            LOG.trace("Removing partial CB " + String.valueOf(current) + " from ranges after copying its contents");
        }
        this.trace.logPartialCb((DiskRange)current);
        DiskRangeList next = current.next;
        current.removeSelf();
        if (originalPos == 0 && toRelease.remove(compressed).booleanValue()) {
            this.releaseBuffer(compressed, true);
        }
        int extraChunkCount = 0;
        while (true) {
            if (!(next instanceof BufferChunk)) {
                throw new IOException("Trying to extend compressed block into uncompressed block " + String.valueOf(next));
            }
            compressed = next.getData();
            ++extraChunkCount;
            if (compressed.remaining() >= remaining) {
                slice = compressed.slice();
                slice.limit(remaining);
                copy.put(slice);
                ProcCacheChunk cc = this.addOneCompressionBlockByteBuffer(copy, isUncompressed, cbStartOffset, cbEndOffset, remaining, (BufferChunk)next, toDecompress, cacheBuffers, true);
                if (compressed.remaining() <= 0 && toRelease.remove(compressed).booleanValue()) {
                    this.releaseBuffer(compressed, true);
                }
                return cc;
            }
            remaining -= compressed.remaining();
            copy.put(compressed);
            if (toRelease.remove(compressed).booleanValue()) {
                this.releaseBuffer(compressed, true);
            }
            tmp = next;
            DiskRangeList diskRangeList = next = next.hasContiguousNext() ? next.next : null;
            if (next == null) break;
            if (this.isTracingEnabled) {
                LOG.trace("Removing partial CB " + String.valueOf(tmp) + " from ranges after copying its contents");
            }
            this.trace.logPartialCb((DiskRange)tmp);
            tmp.removeSelf();
        }
        badEstimates.add(EncodedReaderImpl.addIncompleteCompressionBuffer(cbStartOffset, tmp, extraChunkCount, this.isTracingEnabled, this.trace));
        return null;
    }

    @VisibleForTesting
    static BufferChunk readLengthBytesFromSmallBuffers(BufferChunk first, long cbStartOffset, int[] result, List<IncompleteCb> badEstimates, boolean isTracingEnabled, IoTrace trace) throws IOException {
        DiskRangeList tmp;
        if (!first.hasContiguousNext()) {
            badEstimates.add(EncodedReaderImpl.addIncompleteCompressionBuffer(cbStartOffset, (DiskRangeList)first, 0, isTracingEnabled, trace));
            return null;
        }
        int ix = EncodedReaderImpl.readLengthBytes(first.getData(), result, 0);
        assert (ix < 3);
        DiskRangeList current = first.next;
        first.removeSelf();
        while (true) {
            if (!(current instanceof BufferChunk)) {
                throw new IOException("Trying to extend compressed block into uncompressed block " + String.valueOf(current));
            }
            BufferChunk currentBc = (BufferChunk)current;
            ix = EncodedReaderImpl.readLengthBytes(currentBc.getData(), result, ix);
            if (ix == 3) {
                return currentBc;
            }
            tmp = current;
            DiskRangeList diskRangeList = current = current.hasContiguousNext() ? current.next : null;
            if (current == null) break;
            if (isTracingEnabled) {
                LOG.trace("Removing partial CB " + String.valueOf(tmp) + " from ranges after copying its contents");
            }
            trace.logPartialCb((DiskRange)tmp);
            tmp.removeSelf();
        }
        badEstimates.add(EncodedReaderImpl.addIncompleteCompressionBuffer(cbStartOffset, tmp, -1, isTracingEnabled, trace));
        return null;
    }

    private static int readLengthBytes(ByteBuffer compressed, int[] bytes, int ix) {
        for (int byteCount = compressed.remaining(); byteCount > 0 && ix < 3; --byteCount) {
            bytes[ix++] = compressed.get() & 0xFF;
        }
        return ix;
    }

    private void releaseBuffers(Collection<ByteBuffer> toRelease, boolean isFromDataReader) {
        if (toRelease == null) {
            return;
        }
        for (ByteBuffer buf : toRelease) {
            this.releaseBuffer(buf, isFromDataReader);
        }
    }

    private void releaseBuffer(ByteBuffer bb, boolean isFromDataReader) {
        if (this.isTracingEnabled) {
            LOG.trace("Releasing the buffer " + System.identityHashCode(bb));
        }
        if (isFromDataReader && this.dataReader.isTrackingDiskRanges()) {
            this.dataReader.releaseBuffer(bb);
            return;
        }
        if (!bb.isDirect() || !CleanerUtil.UNMAP_SUPPORTED) {
            return;
        }
        try {
            CleanerUtil.getCleaner().freeBuffer(bb);
        }
        catch (Exception e) {
            LOG.warn("Unable to clean direct buffers using Cleaner");
        }
    }

    private static IncompleteCb addIncompleteCompressionBuffer(long cbStartOffset, DiskRangeList target, int extraChunkCountToLog, boolean isTracingEnabled, IoTrace trace) {
        IncompleteCb icb = new IncompleteCb(cbStartOffset, target.getEnd());
        if (isTracingEnabled) {
            LOG.trace("Replacing " + String.valueOf(target) + " (and " + extraChunkCountToLog + " previous chunks) with " + String.valueOf((Object)icb) + " in the buffers");
        }
        trace.logInvalidOrcCb(cbStartOffset, target.getEnd());
        target.replaceSelfWith((DiskRangeList)icb);
        return icb;
    }

    private ProcCacheChunk addOneCompressionBlockByteBuffer(ByteBuffer fullCompressionBlock, boolean isUncompressed, long cbStartOffset, long cbEndOffset, int lastChunkLength, BufferChunk lastChunk, List<ProcCacheChunk> toDecompress, List<MemoryBuffer> cacheBuffers, boolean doTrace) {
        MemoryBuffer futureAlloc = this.cacheWrapper.getDataBufferFactory().create();
        cacheBuffers.add(futureAlloc);
        ProcCacheChunk cc = new ProcCacheChunk(cbStartOffset, cbEndOffset, !isUncompressed, fullCompressionBlock, futureAlloc, cacheBuffers.size() - 1);
        toDecompress.add(cc);
        if (this.isTracingEnabled) {
            LOG.trace("Adjusting " + String.valueOf(lastChunk) + " to consume " + lastChunkLength + " compressed bytes");
        }
        if (doTrace) {
            this.trace.logCompositeOrcCb(lastChunkLength, lastChunk.getData().remaining(), (DiskRange)cc);
        }
        lastChunk.getData().position(lastChunk.getData().position() + lastChunkLength);
        if (lastChunk.getData().remaining() <= 0) {
            if (this.isTracingEnabled) {
                LOG.trace("Replacing " + String.valueOf(lastChunk) + " with " + String.valueOf((Object)cc) + " in the buffers");
            }
            lastChunk.replaceSelfWith((DiskRangeList)cc);
        } else {
            if (this.isTracingEnabled) {
                LOG.trace("Adding " + String.valueOf((Object)cc) + " before " + String.valueOf(lastChunk) + " in the buffers");
            }
            lastChunk.insertPartBefore((DiskRangeList)cc);
        }
        return cc;
    }

    private static ByteBuffer allocateBuffer(int size, boolean isDirect) {
        return isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    private static Pools createPools(Reader.PoolFactory pf) {
        Pools pools = new Pools();
        pools.ecbPool = pf.createEncodedColumnBatchPool();
        pools.csdPool = pf.createColumnStreamDataPool();
        return pools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readIndexStreams(OrcIndex index, StripeInformation stripe, List<OrcProto.Stream> streams, boolean[] physicalFileIncludes, boolean[] sargColumns) throws IOException {
        long stripeOffset = stripe.getOffset();
        DiskRangeList indexRanges = EncodedReaderImpl.planIndexReading(this.fileSchema, streams, true, physicalFileIncludes, sargColumns, this.version, index.getBloomFilterKinds());
        if (indexRanges == null) {
            LOG.debug("Nothing to read for stripe [{}]", (Object)stripe);
            return;
        }
        ReadContext[] colCtxs = new ReadContext[physicalFileIncludes.length];
        int colRgIx = -1;
        for (int i = 0; i < physicalFileIncludes.length; ++i) {
            if (!physicalFileIncludes[i] && (sargColumns == null || !sargColumns[i])) continue;
            colCtxs[i] = new ReadContext(i, ++colRgIx);
            if (this.isTracingEnabled) {
                LOG.trace("Creating context: " + colCtxs[i].toString());
            }
            this.trace.logColumnRead(i, colRgIx, OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        long offset = 0L;
        for (OrcProto.Stream stream : streams) {
            long length = stream.getLength();
            int colIx = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (StreamName.getArea((OrcProto.Stream.Kind)streamKind) == StreamName.Area.INDEX && (sargColumns != null && sargColumns[colIx] || physicalFileIncludes[colIx] && streamKind == OrcProto.Stream.Kind.ROW_INDEX)) {
                this.trace.logAddStream(colIx, streamKind, offset, length, -1, true);
                colCtxs[colIx].addStream(offset, stream, -1);
                if (this.isTracingEnabled) {
                    LOG.trace("Adding stream for column " + colIx + ": " + String.valueOf(streamKind) + " at " + offset + ", " + length);
                }
            }
            offset += length;
        }
        boolean hasFileId = this.fileKey != null;
        IdentityHashMap<ByteBuffer, Boolean> toRelease = new IdentityHashMap<ByteBuffer, Boolean>();
        DiskRangeList.MutateHelper toRead = this.getDataFromCacheAndDisk(indexRanges, stripeOffset, hasFileId, toRelease);
        DiskRangeList iter = this.preReadUncompressedStreams(stripeOffset, colCtxs, toRead, toRelease);
        boolean hasError = true;
        try {
            for (int colIx = 0; colIx < colCtxs.length; ++colIx) {
                ReadContext ctx = colCtxs[colIx];
                if (ctx == null) continue;
                for (int streamIx = 0; streamIx < ctx.streamCount; ++streamIx) {
                    StreamContext sctx = ctx.streams[streamIx];
                    try {
                        EncodedColumnBatch.ColumnStreamData csd;
                        long endCOffset;
                        DiskRangeList lastCached;
                        if (this.isTracingEnabled) {
                            LOG.trace("Getting index stream " + String.valueOf(sctx.kind) + " for column " + ctx.colIx + " at " + sctx.offset + ", " + sctx.length);
                        }
                        if ((lastCached = this.readEncodedStream(stripeOffset, iter, sctx.offset, endCOffset = sctx.offset + sctx.length, csd = (EncodedColumnBatch.ColumnStreamData)EncodedReaderImpl.POOLS.csdPool.take(), endCOffset, sctx.offset, toRelease)) != null) {
                            iter = lastCached;
                        }
                        if (this.isTracingEnabled) {
                            this.traceLogBuffersUsedToParse(csd);
                        }
                        CodedInputStream cis = CodedInputStream.newInstance((InputStream)new IndexStream(csd.getCacheBuffers(), sctx.length));
                        cis.setSizeLimit(0x40000000);
                        switch (sctx.kind) {
                            case ROW_INDEX: {
                                OrcProto.RowIndex rowIndex = OrcProto.RowIndex.parseFrom((CodedInputStream)cis);
                                index.getRowGroupIndex()[colIx] = rowIndex;
                                OrcProto.RowIndex tmp = rowIndex;
                                if (!this.isTracingEnabled) break;
                                LOG.trace("Index is " + tmp.toString().replace('\n', ' '));
                                break;
                            }
                            case BLOOM_FILTER: 
                            case BLOOM_FILTER_UTF8: {
                                index.getBloomFilterIndex()[colIx] = OrcProto.BloomFilterIndex.parseFrom((CodedInputStream)cis);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unexpected index stream type " + String.valueOf(sctx.kind)));
                            }
                        }
                        for (MemoryBuffer buf : csd.getCacheBuffers()) {
                            if (buf == null) continue;
                            this.cacheWrapper.releaseBuffer(buf);
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        DiskRangeList drl = toRead == null ? null : toRead.next;
                        LOG.error("Error getting stream " + String.valueOf(sctx.kind) + " for column " + ctx.colIx + " at " + sctx.offset + ", " + sctx.length + "; toRead " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)drl), (Throwable)ex);
                        throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
                    }
                }
            }
            if (this.isTracingEnabled) {
                LOG.trace("Disk ranges after preparing all the data " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)toRead.next));
            }
            hasError = false;
        }
        finally {
            try {
                if (toRead != null) {
                    this.releaseInitialRefcounts(toRead.next);
                }
                this.releaseBuffers(toRelease.keySet(), true);
            }
            catch (Throwable t) {
                if (!hasError) {
                    throw new IOException(t);
                }
                LOG.error("Error during the cleanup after another error; ignoring", t);
            }
        }
    }

    private void traceLogBuffersUsedToParse(EncodedColumnBatch.ColumnStreamData csd) {
        Object s = "Buffers ";
        if (csd.getCacheBuffers() != null) {
            for (MemoryBuffer buf : csd.getCacheBuffers()) {
                ByteBuffer bb = buf.getByteBufferDup();
                s = (String)s + "{" + String.valueOf(buf) + ", " + bb.remaining() + "}, ";
            }
        }
        LOG.trace((String)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskRangeList preReadUncompressedStreams(long stripeOffset, ReadContext[] colCtxs, DiskRangeList.MutateHelper toRead, IdentityHashMap<ByteBuffer, Boolean> toRelease) throws IOException {
        if (this.isCompressed) {
            return toRead.next;
        }
        DiskRangeList iter = toRead.next;
        boolean hasError = true;
        try {
            for (int colIx = 0; colIx < colCtxs.length; ++colIx) {
                ReadContext ctx = colCtxs[colIx];
                if (ctx == null) continue;
                for (int streamIx = 0; streamIx < ctx.streamCount; ++streamIx) {
                    StreamContext sctx = ctx.streams[streamIx];
                    DiskRangeList newIter = this.preReadUncompressedStream(stripeOffset, iter, sctx.offset, sctx.offset + sctx.length, sctx.kind);
                    if (newIter == null) continue;
                    iter = newIter;
                }
            }
            if (toRelease != null) {
                this.releaseBuffers(toRelease.keySet(), true);
                toRelease.clear();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disk ranges after pre-read (file " + String.valueOf(this.fileKey) + ", base offset " + stripeOffset + "): " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)toRead.next));
            }
            iter = toRead.next;
            hasError = false;
        }
        finally {
            if (hasError) {
                try {
                    this.releaseInitialRefcounts(toRead.next);
                    if (toRelease != null) {
                        this.releaseBuffers(toRelease.keySet(), true);
                        toRelease.clear();
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error during the cleanup after another error; ignoring", t);
                }
            }
        }
        return toRead.next;
    }

    static DiskRangeList planIndexReading(TypeDescription fileSchema, List<OrcProto.Stream> streams, boolean ignoreNonUtf8BloomFilter, boolean[] fileIncluded, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds) {
        DiskRangeList.CreateHelper result = new DiskRangeList.CreateHelper();
        if (sargColumns != null) {
            for (OrcProto.Stream stream : streams) {
                int column;
                if (!stream.hasKind() || !stream.hasColumn() || !sargColumns[column = stream.getColumn()]) continue;
                switch (stream.getKind()) {
                    case BLOOM_FILTER: {
                        if (bloomFilterKinds[column] != null || ignoreNonUtf8BloomFilter && EncodedReaderImpl.hadBadBloomFilters(fileSchema.findSubtype(column).getCategory(), version)) break;
                        bloomFilterKinds[column] = OrcProto.Stream.Kind.BLOOM_FILTER;
                        break;
                    }
                    case BLOOM_FILTER_UTF8: {
                        bloomFilterKinds[column] = OrcProto.Stream.Kind.BLOOM_FILTER_UTF8;
                        break;
                    }
                }
            }
        }
        long offset = 0L;
        for (OrcProto.Stream stream : streams) {
            if (stream.hasKind() && stream.hasColumn()) {
                int column = stream.getColumn();
                if (fileIncluded == null || fileIncluded[column]) {
                    boolean needStream = false;
                    switch (stream.getKind()) {
                        case ROW_INDEX: {
                            needStream = true;
                            break;
                        }
                        case BLOOM_FILTER: 
                        case BLOOM_FILTER_UTF8: {
                            needStream = sargColumns != null && bloomFilterKinds[column] == stream.getKind();
                            break;
                        }
                    }
                    if (needStream) {
                        result.addOrMerge(offset, offset + stream.getLength(), true, false);
                    }
                }
            }
            offset += stream.getLength();
        }
        return result.get();
    }

    private static boolean hadBadBloomFilters(TypeDescription.Category category, OrcFile.WriterVersion version) {
        switch (category) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return !version.includes(OrcFile.WriterVersion.HIVE_12055);
            }
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setStopped(AtomicBoolean isStopped) {
        this.isStopped = isStopped;
    }

    static {
        CC_FACTORY = new DataCache.DiskRangeListFactory(){

            public DiskRangeList createCacheChunk(MemoryBuffer buffer, long offset, long end) {
                return new CacheChunk(buffer, offset, end);
            }
        };
    }

    private static class Pools {
        Pool<Reader.OrcEncodedColumnBatch> ecbPool;
        Pool<EncodedColumnBatch.ColumnStreamData> csdPool;

        private Pools() {
        }
    }

    private static class NoopPoolFactory
    implements Reader.PoolFactory {
        private NoopPoolFactory() {
        }

        private <T> Pool<T> createPool(final int size, final Pool.PoolObjectHelper<T> helper) {
            return new Pool<T>(){

                public void offer(T t) {
                }

                public int size() {
                    return size;
                }

                public T take() {
                    return helper.create();
                }
            };
        }

        @Override
        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return this.createPool(0, new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(this){

                public Reader.OrcEncodedColumnBatch create() {
                    return new Reader.OrcEncodedColumnBatch();
                }

                public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
                }
            });
        }

        @Override
        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return this.createPool(0, new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(this){

                public EncodedColumnBatch.ColumnStreamData create() {
                    return new EncodedColumnBatch.ColumnStreamData();
                }

                public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
                }
            });
        }
    }

    private static final class ColumnReadContext
    extends ReadContext {
        public static final int MAX_STREAMS = EncodedReaderImpl.countMaxStreams(StreamName.Area.DATA);
        OrcProto.ColumnEncoding encoding;
        OrcProto.RowIndex rowIndex;

        public ColumnReadContext(int colIx, OrcProto.ColumnEncoding encoding, OrcProto.RowIndex rowIndex, int colRgIx) {
            super(colIx, colRgIx, MAX_STREAMS);
            this.encoding = encoding;
            this.rowIndex = rowIndex;
        }

        @Override
        public void addStream(long offset, OrcProto.Stream stream, int indexIx) {
            this.streams[this.streamCount++] = new StreamContext(stream, offset, indexIx);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" column_index: ").append(this.colIx);
            sb.append(" included_index: ").append(this.includedIx);
            sb.append(" encoding: ").append(this.encoding);
            sb.append(" stream_count: ").append(this.streamCount);
            int i = 0;
            for (StreamContext sc : this.streams) {
                if (sc != null) {
                    sb.append(" stream_").append(i).append(":").append(sc.toString());
                }
                ++i;
            }
            return sb.toString();
        }
    }

    private static class ReadContext {
        public static final int MAX_STREAMS = EncodedReaderImpl.countMaxStreams(StreamName.Area.INDEX);
        int streamCount = 0;
        final StreamContext[] streams;
        int colIx;
        int includedIx;

        protected ReadContext(int colIx, int colRgIx, int maxStreams) {
            this.colIx = colIx;
            this.includedIx = colRgIx;
            this.streamCount = 0;
            this.streams = new StreamContext[maxStreams];
        }

        public ReadContext(int colIx, int colRgIx) {
            this(colIx, colRgIx, MAX_STREAMS);
        }

        public void addStream(long offset, OrcProto.Stream stream, int indexIx) {
            this.streams[this.streamCount++] = new StreamContext(stream, offset, indexIx);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" column_index: ").append(this.colIx);
            sb.append(" included_index: ").append(this.includedIx);
            sb.append(" stream_count: ").append(this.streamCount);
            int i = 0;
            for (StreamContext sc : this.streams) {
                if (sc != null) {
                    sb.append(" stream_").append(i).append(":").append(sc.toString());
                }
                ++i;
            }
            return sb.toString();
        }
    }

    private static final class StreamContext {
        public long offset;
        public long length;
        public int streamIndexOffset;
        public OrcProto.Stream.Kind kind;
        DiskRangeList bufferIter;
        EncodedColumnBatch.ColumnStreamData stripeLevelStream;

        public StreamContext(OrcProto.Stream stream, long streamOffset, int streamIndexOffset) {
            this.kind = stream.getKind();
            this.length = stream.getLength();
            this.offset = streamOffset;
            this.streamIndexOffset = streamIndexOffset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" kind: ").append(this.kind);
            sb.append(" offset: ").append(this.offset);
            sb.append(" length: ").append(this.length);
            sb.append(" index_offset: ").append(this.streamIndexOffset);
            return sb.toString();
        }
    }

    private static class ProcCacheChunk
    extends CacheChunk {
        private ByteBuffer originalData = null;
        private boolean isOriginalDataCompressed;
        private int originalCbIndex;

        public ProcCacheChunk(long cbStartOffset, long cbEndOffset, boolean isCompressed, ByteBuffer originalData, MemoryBuffer targetBuffer, int originalCbIndex) {
            super(targetBuffer, cbStartOffset, cbEndOffset);
            this.isOriginalDataCompressed = isCompressed;
            this.originalData = originalData;
            this.originalCbIndex = originalCbIndex;
        }

        @Override
        public String toString() {
            return super.toString() + ", original is set " + (this.originalData != null) + ", buffer was replaced " + (this.originalCbIndex == -1);
        }

        @Override
        public void handleCacheCollision(DataCache cacheWrapper, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
            assert (this.originalCbIndex >= 0);
            cacheWrapper.releaseBuffer(this.buffer);
            cacheWrapper.reuseBuffer(replacementBuffer);
            this.buffer = replacementBuffer;
            cacheBuffers.set(this.originalCbIndex, replacementBuffer);
            this.originalCbIndex = -1;
        }
    }

    private static class UncompressedCacheChunk
    extends CacheChunk {
        private BufferChunk chunk;
        private int count;

        public UncompressedCacheChunk(BufferChunk bc) {
            super(null, bc.getOffset(), bc.getEnd());
            this.chunk = bc;
            this.count = 1;
        }

        public void addChunk(BufferChunk bc) {
            assert (bc.getOffset() == this.getEnd());
            this.end = bc.getEnd();
            ++this.count;
        }

        public BufferChunk getChunk() {
            return this.chunk;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void handleCacheCollision(DataCache cacheWrapper, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
            assert (cacheBuffers == null);
            cacheWrapper.getAllocator().deallocate(this.getBuffer());
            this.setBuffer(replacementBuffer);
        }

        public void clear() {
            this.chunk = null;
            this.count = -1;
        }
    }

    private static class IndexStream
    extends InputStream {
        private List<MemoryBuffer> ranges;
        private long currentOffset = 0L;
        private long length;
        private ByteBuffer range;
        private int rangeIx = -1;

        public IndexStream(List<MemoryBuffer> input, long length) {
            this.ranges = input;
            this.length = length;
        }

        @Override
        public int read() {
            if (!this.ensureRangeWithData()) {
                return -1;
            }
            ++this.currentOffset;
            return 0xFF & this.range.get();
        }

        private boolean ensureRangeWithData() {
            while (this.range == null || this.range.remaining() <= 0) {
                ++this.rangeIx;
                if (this.rangeIx == this.ranges.size()) {
                    return false;
                }
                this.range = this.ranges.get(this.rangeIx).getByteBufferDup();
            }
            return true;
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            if (!this.ensureRangeWithData()) {
                return -1;
            }
            int actualLength = Math.min(length, this.range.remaining());
            this.range.get(data, offset, actualLength);
            this.currentOffset += (long)actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            if (this.range != null && this.range.remaining() > 0) {
                return this.range.remaining();
            }
            return (int)(this.length - this.currentOffset);
        }

        @Override
        public void close() {
            this.rangeIx = this.ranges.size();
            this.currentOffset = this.length;
            this.ranges.clear();
        }

        public String toString() {
            return "position: " + this.currentOffset + " length: " + this.length + " range: " + this.rangeIx + " offset: " + (this.range == null ? 0 : this.range.position()) + " limit: " + (this.range == null ? 0 : this.range.limit());
        }
    }
}

