/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.add;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableAddPartitionOperation
extends DDLOperation<AlterTableAddPartitionDesc> {
    public AlterTableAddPartitionOperation(DDLOperationContext context, AlterTableAddPartitionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = this.context.getDb().getTable(((AlterTableAddPartitionDesc)this.desc).getDbName(), ((AlterTableAddPartitionDesc)this.desc).getTableName());
        long writeId = this.getWriteId(table);
        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.getPartitions(table, writeId);
        this.addPartitions(table, partitions, writeId);
        return 0;
    }

    private long getWriteId(Table table) throws LockException {
        if (((AlterTableAddPartitionDesc)this.desc).getReplicationSpec().isInReplicationScope() && ((AlterTableAddPartitionDesc)this.desc).getPartitions().get(0).getWriteId() > 0L) {
            return ((AlterTableAddPartitionDesc)this.desc).getPartitions().get(0).getWriteId();
        }
        AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.context.getConf(), table, true);
        if (tableSnapshot != null && tableSnapshot.getWriteId() > 0L) {
            return tableSnapshot.getWriteId();
        }
        return -1L;
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> getPartitions(Table table, long writeId) throws HiveException {
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitions = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(((AlterTableAddPartitionDesc)this.desc).getPartitions().size());
        for (AlterTableAddPartitionDesc.PartitionDesc partitionDesc : ((AlterTableAddPartitionDesc)this.desc).getPartitions()) {
            org.apache.hadoop.hive.metastore.api.Partition partition = this.convertPartitionSpecToMetaPartition(table, partitionDesc);
            if (partition != null && writeId > 0L) {
                partition.setWriteId(writeId);
            }
            partitions.add(partition);
        }
        return partitions;
    }

    private org.apache.hadoop.hive.metastore.api.Partition convertPartitionSpecToMetaPartition(Table table, AlterTableAddPartitionDesc.PartitionDesc partitionSpec) throws HiveException {
        Path location;
        Path path = location = partitionSpec.getLocation() != null ? new Path(table.getPath(), partitionSpec.getLocation()) : null;
        if (location != null) {
            location = new Path(Utilities.getQualifiedPath(this.context.getConf(), location));
        }
        org.apache.hadoop.hive.metastore.api.Partition partition = Partition.createMetaPartitionObject(table, partitionSpec.getPartSpec(), location);
        if (partitionSpec.getPartParams() != null) {
            partition.setParameters(partitionSpec.getPartParams());
        }
        if (partitionSpec.getInputFormat() != null) {
            partition.getSd().setInputFormat(partitionSpec.getInputFormat());
        }
        if (partitionSpec.getOutputFormat() != null) {
            partition.getSd().setOutputFormat(partitionSpec.getOutputFormat());
        }
        if (partitionSpec.getNumBuckets() != -1) {
            partition.getSd().setNumBuckets(partitionSpec.getNumBuckets());
        }
        if (partitionSpec.getCols() != null) {
            partition.getSd().setCols(partitionSpec.getCols());
        }
        if (partitionSpec.getSerializationLib() != null) {
            partition.getSd().getSerdeInfo().setSerializationLib(partitionSpec.getSerializationLib());
        }
        if (partitionSpec.getSerdeParams() != null) {
            partition.getSd().getSerdeInfo().setParameters(partitionSpec.getSerdeParams());
        }
        if (partitionSpec.getBucketCols() != null) {
            partition.getSd().setBucketCols(partitionSpec.getBucketCols());
        }
        if (partitionSpec.getSortCols() != null) {
            partition.getSd().setSortCols(partitionSpec.getSortCols());
        }
        if (partitionSpec.getColStats() != null) {
            partition.setColStats(partitionSpec.getColStats());
            ColumnStatistics statistics = partition.getColStats();
            if (statistics != null && statistics.getEngine() == null) {
                statistics.setEngine("hive");
            }
            partition.setWriteId(partitionSpec.getWriteId());
        }
        return partition;
    }

    private void addPartitions(Table table, List<org.apache.hadoop.hive.metastore.api.Partition> partitions, long writeId) throws HiveException {
        List<Partition> outPartitions = null;
        outPartitions = !((AlterTableAddPartitionDesc)this.desc).getReplicationSpec().isInReplicationScope() ? this.addPartitionsNoReplication(table, partitions) : this.addPartitionsWithReplication(table, partitions, writeId);
        for (Partition outPartition : outPartitions) {
            DDLUtils.addIfAbsentByName(new WriteEntity(outPartition, WriteEntity.WriteType.INSERT), this.context);
        }
    }

    private List<Partition> addPartitionsNoReplication(Table table, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws HiveException {
        ArrayList<Partition> outPartitions = new ArrayList<Partition>();
        for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.context.getDb().addPartitions(partitions, ((AlterTableAddPartitionDesc)this.desc).isIfNotExists(), true)) {
            outPartitions.add(new Partition(table, outPart));
        }
        return outPartitions;
    }

    private List<Partition> addPartitionsWithReplication(Table table, List<org.apache.hadoop.hive.metastore.api.Partition> partitions, long writeId) throws HiveException {
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitionsToAdd = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitionsToAlter = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        ArrayList<String> partitionNames = new ArrayList<String>();
        Map dbParams = this.context.getDb().getDatabase(((AlterTableAddPartitionDesc)this.desc).getDbName()).getParameters();
        for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
            partitionNames.add(this.getPartitionName(table, partition));
            try {
                org.apache.hadoop.hive.metastore.api.Partition p = this.context.getDb().getPartition(table, ((AlterTableAddPartitionDesc)this.desc).getDbName(), ((AlterTableAddPartitionDesc)this.desc).getTableName(), partition.getValues());
                if (!((AlterTableAddPartitionDesc)this.desc).getReplicationSpec().allowReplacementInto(dbParams)) continue;
                partitionsToAlter.add(partition);
            }
            catch (HiveException e) {
                if (e.getCause() instanceof NoSuchObjectException) {
                    partitionsToAdd.add(partition);
                    continue;
                }
                throw e;
            }
        }
        ArrayList<Partition> outPartitions = new ArrayList<Partition>();
        if (!partitionsToAdd.isEmpty()) {
            LOG.debug("Calling AddPartition for {}", partitionsToAdd);
            for (org.apache.hadoop.hive.metastore.api.Partition outPartition : this.context.getDb().addPartitions(partitionsToAdd, ((AlterTableAddPartitionDesc)this.desc).isIfNotExists(), true)) {
                outPartitions.add(new Partition(table, outPartition));
            }
        }
        if (!partitionsToAlter.isEmpty()) {
            LOG.debug("Calling AlterPartition for {}", partitionsToAlter);
            EnvironmentContext environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
            String validWriteIdList = this.getValidWriteIdList(table, writeId);
            this.context.getDb().alterPartitions(((AlterTableAddPartitionDesc)this.desc).getDbName(), ((AlterTableAddPartitionDesc)this.desc).getTableName(), partitionsToAlter, environmentContext, validWriteIdList, writeId);
            for (org.apache.hadoop.hive.metastore.api.Partition outPartition : this.context.getDb().getPartitionsByNames(((AlterTableAddPartitionDesc)this.desc).getDbName(), ((AlterTableAddPartitionDesc)this.desc).getTableName(), partitionNames, table)) {
                outPartitions.add(new Partition(table, outPartition));
            }
        }
        return outPartitions;
    }

    private String getPartitionName(Table table, org.apache.hadoop.hive.metastore.api.Partition partition) throws HiveException {
        try {
            return Warehouse.makePartName(table.getPartitionKeys(), (List)partition.getValues());
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private String getValidWriteIdList(Table table, long writeId) throws LockException {
        if (((AlterTableAddPartitionDesc)this.desc).getReplicationSpec().isInReplicationScope() && ((AlterTableAddPartitionDesc)this.desc).getPartitions().get(0).getWriteId() > 0L) {
            return new ValidReaderWriteIdList(TableName.getDbTable((String)table.getDbName(), (String)table.getTableName()), new long[0], new BitSet(), writeId).writeToString();
        }
        AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.context.getConf(), table, true);
        if (tableSnapshot != null && tableSnapshot.getWriteId() > 0L) {
            return tableSnapshot.getValidWriteIdList();
        }
        return null;
    }
}

