/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.nativetask.INativeComparable;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;

@InterfaceAudience.Private
public class BytesWritableSerializer
implements INativeComparable,
INativeSerializer<BytesWritable> {
    @Override
    public int getLength(BytesWritable w) throws IOException {
        return w.getLength();
    }

    @Override
    public void serialize(BytesWritable w, DataOutput out) throws IOException {
        out.write(w.getBytes(), 0, w.getLength());
    }

    @Override
    public void deserialize(DataInput in, int length, BytesWritable w) throws IOException {
        w.setSize(length);
        in.readFully(w.getBytes(), 0, length);
    }
}

