/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.regex.Pattern;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;

public class DockerVolumeCommand
extends DockerCommand {
    public static final String VOLUME_COMMAND = "volume";
    public static final String VOLUME_CREATE_SUB_COMMAND = "create";
    public static final String VOLUME_LS_SUB_COMMAND = "ls";
    public static final Pattern VOLUME_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_.-]*");
    private String volumeName;
    private String driverName;
    private String subCommand;

    public DockerVolumeCommand(String subCommand) {
        super(VOLUME_COMMAND);
        this.subCommand = subCommand;
        super.addCommandArguments("sub-command", subCommand);
    }

    public DockerVolumeCommand setVolumeName(String volumeName) {
        super.addCommandArguments(VOLUME_COMMAND, volumeName);
        this.volumeName = volumeName;
        return this;
    }

    public DockerVolumeCommand setDriverName(String driverName) {
        super.addCommandArguments("driver", driverName);
        this.driverName = driverName;
        return this;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getSubCommand() {
        return this.subCommand;
    }

    public DockerVolumeCommand setFormat(String format) {
        super.addCommandArguments("format", format);
        return this;
    }
}

