/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.servlet;

import java.util.Map;
import org.apache.hadoop.shaded.com.google.inject.servlet.ServletModuleBinding;
import org.apache.hadoop.shaded.com.google.inject.servlet.UriPatternMatcher;
import org.apache.hadoop.shaded.com.google.inject.servlet.UriPatternType;

class AbstractServletModuleBinding<T>
implements ServletModuleBinding {
    private final Map<String, String> initParams;
    private final T target;
    private final UriPatternMatcher patternMatcher;

    AbstractServletModuleBinding(Map<String, String> initParams, T target, UriPatternMatcher patternMatcher) {
        this.initParams = initParams;
        this.target = target;
        this.patternMatcher = patternMatcher;
    }

    @Override
    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    @Override
    public String getPattern() {
        return this.patternMatcher.getOriginalPattern();
    }

    protected T getTarget() {
        return this.target;
    }

    @Override
    public UriPatternType getUriPatternType() {
        return this.patternMatcher.getPatternType();
    }

    @Override
    public boolean matchesUri(String uri) {
        return this.patternMatcher.matches(uri);
    }
}

