/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.MountTableRefresherService;
import org.apache.hadoop.hdfs.server.federation.router.MountTableRefresherThread;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterMountTableCacheRefresh {
    private static TestingServer curatorTestingServer;
    private static MiniRouterDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableManager mountTableManager;

    @BeforeClass
    public static void setUp() throws Exception {
        curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        String connectString = curatorTestingServer.getConnectString();
        int numNameservices = 2;
        cluster = new MiniRouterDFSCluster(false, numNameservices);
        Configuration conf = new RouterConfigBuilder().refreshCache().admin().rpc().heartbeat().build();
        conf.setClass("dfs.federation.router.file.resolver.client.class", RBFConfigKeys.FEDERATION_FILE_RESOLVER_CLIENT_CLASS_DEFAULT, FileSubclusterResolver.class);
        conf.set("hadoop.zk.address", connectString);
        conf.setBoolean("dfs.federation.router.store.enable", true);
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        RouterStore routerStateManager = routerContext.getRouter().getRouterStateManager();
        mountTableManager = routerContext.getAdminClient().getMountTableManager();
        FederationTestUtils.waitRouterRegistered(routerStateManager, numNameservices, 60000);
    }

    @AfterClass
    public static void destory() {
        try {
            curatorTestingServer.close();
            cluster.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @After
    public void tearDown() throws IOException {
        this.clearEntries();
    }

    private void clearEntries() throws IOException {
        List<MountTable> result = this.getMountTableEntries();
        for (MountTable mountTable : result) {
            RemoveMountTableEntryResponse removeMountTableEntry = mountTableManager.removeMountTableEntry(RemoveMountTableEntryRequest.newInstance((String)mountTable.getSourcePath()));
            Assert.assertTrue((boolean)removeMountTableEntry.getStatus());
        }
    }

    @Test
    public void testMountTableEntriesCacheUpdatedAfterAddAPICall() throws IOException {
        int existingEntriesCount = this.getNumMountTableEntries();
        String srcPath = "/addPath";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/addPathDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        List<MiniRouterDFSCluster.RouterContext> routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            List<MountTable> result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)(1 + existingEntriesCount), (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
        }
    }

    @Test
    public void testMountTableEntriesCacheUpdatedAfterRemoveAPICall() throws IOException {
        String srcPath = "/removePathSrc";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/removePathDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        int addCount = this.getNumMountTableEntries();
        Assert.assertEquals((long)1L, (long)addCount);
        RemoveMountTableEntryResponse removeMountTableEntry = mountTableManager.removeMountTableEntry(RemoveMountTableEntryRequest.newInstance((String)srcPath));
        Assert.assertTrue((boolean)removeMountTableEntry.getStatus());
        int removeCount = this.getNumMountTableEntries();
        Assert.assertEquals((long)(addCount - 1), (long)removeCount);
    }

    @Test
    public void testMountTableEntriesCacheUpdatedAfterUpdateAPICall() throws IOException {
        String srcPath = "/updatePathSrc";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/updatePathDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        int addCount = this.getNumMountTableEntries();
        Assert.assertEquals((long)1L, (long)addCount);
        String key = "ns1";
        String value = "/updatePathDest2";
        MountTable upateEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap(key, value), (long)Time.now(), (long)Time.now());
        UpdateMountTableEntryResponse updateMountTableEntry = mountTableManager.updateMountTableEntry(UpdateMountTableEntryRequest.newInstance((MountTable)upateEntry));
        Assert.assertTrue((boolean)updateMountTableEntry.getStatus());
        MountTable updatedMountTable = this.getMountTableEntry(srcPath);
        Assert.assertNotNull((String)"Updated mount table entrty cannot be null", (Object)updatedMountTable);
        Assert.assertEquals((long)1L, (long)updatedMountTable.getDestinations().size());
        Assert.assertEquals((Object)key, (Object)((RemoteLocation)updatedMountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)value, (Object)((RemoteLocation)updatedMountTable.getDestinations().get(0)).getDest());
    }

    @Test
    public void testCachedRouterClientBehaviourAfterRouterStoped() throws IOException {
        List<MountTable> result;
        String srcPath = "/addPathClientCache";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/addPathClientCacheDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        List<MiniRouterDFSCluster.RouterContext> routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)1L, (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
        }
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            InetSocketAddress adminServerAddress = rc.getRouter().getAdminServerAddress();
            if (routerContext.getRouter().getAdminServerAddress().equals(adminServerAddress)) continue;
            cluster.stopRouter(rc);
            break;
        }
        srcPath = "/addPathClientCache2";
        newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/addPathClientCacheDest2"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        for (MiniRouterDFSCluster.RouterContext rc : this.getRouters()) {
            result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)2L, (long)result.size());
        }
    }

    private List<MiniRouterDFSCluster.RouterContext> getRouters() {
        ArrayList<MiniRouterDFSCluster.RouterContext> result = new ArrayList<MiniRouterDFSCluster.RouterContext>();
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            if (rc.getRouter().getServiceState() != Service.STATE.STARTED) continue;
            result.add(rc);
        }
        return result;
    }

    @Test
    public void testRefreshMountTableEntriesAPI() throws IOException {
        RefreshMountTableEntriesRequest request = RefreshMountTableEntriesRequest.newInstance();
        RefreshMountTableEntriesResponse refreshMountTableEntriesRes = mountTableManager.refreshMountTableEntries(request);
        Assert.assertTrue((boolean)refreshMountTableEntriesRes.getResult());
    }

    @Test(timeout=10000L)
    public void testMountTableEntriesCacheUpdateTimeout() throws IOException {
        MountTableRefresherService mountTableRefresherService = new MountTableRefresherService(routerContext.getRouter()){

            protected MountTableRefresherThread getLocalRefresher(String adminAddress) {
                return new MountTableRefresherThread(null, adminAddress){

                    public void run() {
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
            }
        };
        Configuration config = routerContext.getRouter().getConfig();
        config.setTimeDuration("dfs.federation.router.mount-table.cache.update.timeout", 5L, TimeUnit.SECONDS);
        mountTableRefresherService.init(config);
        mountTableRefresherService.refresh();
    }

    @Test
    public void testRouterClientConnectionExpiration() throws Exception {
        final AtomicInteger createCounter = new AtomicInteger();
        final AtomicInteger removeCounter = new AtomicInteger();
        MountTableRefresherService mountTableRefresherService = new MountTableRefresherService(routerContext.getRouter()){

            protected void closeRouterClient(RouterClient client) {
                super.closeRouterClient(client);
                removeCounter.incrementAndGet();
            }

            protected RouterClient createRouterClient(InetSocketAddress routerSocket, Configuration config) throws IOException {
                createCounter.incrementAndGet();
                return super.createRouterClient(routerSocket, config);
            }
        };
        int clientCacheTime = 2000;
        Configuration config = routerContext.getRouter().getConfig();
        config.setTimeDuration("dfs.federation.router.mount-table.cache.update.client.max.time", (long)clientCacheTime, TimeUnit.MILLISECONDS);
        mountTableRefresherService.init(config);
        mountTableRefresherService.refresh();
        Assert.assertNotEquals((String)"No RouterClient is created.", (long)0L, (long)createCounter.get());
        GenericTestUtils.waitFor(() -> createCounter.get() == removeCounter.get(), (long)100L, (long)(3 * clientCacheTime));
    }

    private int getNumMountTableEntries() throws IOException {
        List<MountTable> records = this.getMountTableEntries();
        int oldEntriesCount = records.size();
        return oldEntriesCount;
    }

    private MountTable getMountTableEntry(String srcPath) throws IOException {
        List<MountTable> mountTableEntries = this.getMountTableEntries();
        for (MountTable mountTable : mountTableEntries) {
            String sourcePath = mountTable.getSourcePath();
            if (!srcPath.equals(sourcePath)) continue;
            return mountTable;
        }
        return null;
    }

    private void addMountTableEntry(MountTableManager mountTableMgr, MountTable newEntry) throws IOException {
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTableMgr.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
    }

    private List<MountTable> getMountTableEntries() throws IOException {
        return this.getMountTableEntries(mountTableManager);
    }

    private List<MountTable> getMountTableEntries(MountTableManager mountTableManagerParam) throws IOException {
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)"/");
        return mountTableManagerParam.getMountTableEntries(request).getEntries();
    }
}

