/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RouterFederationRename;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterFederationRenameBase;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterFederationRenamePermission
extends TestRouterFederationRenameBase {
    private String srcNs;
    private String dstNs;
    private String srcStr;
    private Path srcPath;
    private String dstStr;
    private Path dstPath;
    private UserGroupInformation foo;
    private MiniRouterDFSCluster.RouterContext router;
    private FileSystem routerFS;
    private MiniRouterDFSCluster cluster;

    @BeforeClass
    public static void before() throws Exception {
        TestRouterFederationRenamePermission.globalSetUp();
    }

    @AfterClass
    public static void after() {
        TestRouterFederationRenamePermission.tearDown();
    }

    @Before
    public void testSetup() throws Exception {
        this.setup();
        this.cluster = this.getCluster();
        List<String> nss = this.cluster.getNameservices();
        this.srcNs = nss.get(0);
        this.dstNs = nss.get(1);
        this.srcStr = this.cluster.getFederatedTestDirectoryForNS(this.srcNs) + "/d0/" + GenericTestUtils.getMethodName();
        this.dstStr = this.cluster.getFederatedTestDirectoryForNS(this.dstNs) + "/d0/" + GenericTestUtils.getMethodName();
        this.srcPath = new Path(this.srcStr);
        this.dstPath = new Path(this.dstStr);
        this.foo = UserGroupInformation.createRemoteUser((String)"foo");
        this.router = this.getRouterContext();
        this.routerFS = this.getRouterFileSystem();
    }

    @Test
    public void testRenameSnapshotPath() throws Exception {
        LambdaTestUtils.intercept(IOException.class, (String)"Router federation rename can't rename snapshot path", (String)"Expect IOException.", () -> RouterFederationRename.checkSnapshotPath((RemoteLocation)new RemoteLocation(this.srcNs, "/foo/.snapshot/src", "/src"), (RemoteLocation)new RemoteLocation(this.dstNs, "/foo/dst", "/dst")));
        LambdaTestUtils.intercept(IOException.class, (String)"Router federation rename can't rename snapshot path", (String)"Expect IOException.", () -> RouterFederationRename.checkSnapshotPath((RemoteLocation)new RemoteLocation(this.srcNs, "/foo/src", "/src"), (RemoteLocation)new RemoteLocation(this.dstNs, "/foo/.snapshot/dst", "/dst")));
    }

    @Test
    public void testPermission1() throws Exception {
        LambdaTestUtils.intercept(RemoteException.class, (String)"FileNotFoundException", (String)"Expect FileNotFoundException.", () -> {
            DFSClient client = this.router.getClient(this.foo);
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(this.srcStr, this.dstStr);
        });
    }

    @Test
    public void testPermission2() throws Exception {
        this.createDir(this.routerFS, this.srcStr);
        this.routerFS.setPermission(this.srcPath.getParent(), FsPermission.createImmutable((short)0));
        LambdaTestUtils.intercept(RemoteException.class, (String)"AccessControlException", (String)"Expect AccessControlException.", () -> {
            DFSClient client = this.router.getClient(this.foo);
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(this.srcStr, this.dstStr);
        });
    }

    @Test
    public void testPermission3() throws Exception {
        this.createDir(this.routerFS, this.srcStr);
        this.routerFS.setPermission(this.srcPath.getParent(), FsPermission.createImmutable((short)493));
        LambdaTestUtils.intercept(RemoteException.class, (String)"AccessControlException", (String)"Expect AccessControlException.", () -> {
            DFSClient client = this.router.getClient(this.foo);
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(this.srcStr, this.dstStr);
        });
    }

    @Test
    public void testPermission4() throws Exception {
        this.createDir(this.routerFS, this.srcStr);
        this.routerFS.setAcl(this.srcPath.getParent(), this.buildAcl("not-foo", FsAction.ALL));
        LambdaTestUtils.intercept(RemoteException.class, (String)"AccessControlException", (String)"Expect AccessControlException.", () -> {
            DFSClient client = this.router.getClient(this.foo);
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(this.srcStr, this.dstStr);
        });
    }

    @Test
    public void testPermission5() throws Exception {
        this.createDir(this.routerFS, this.srcStr);
        this.routerFS.setAcl(this.srcPath.getParent(), this.buildAcl("foo", FsAction.ALL));
        Assert.assertFalse((boolean)this.routerFS.exists(this.dstPath.getParent()));
        LambdaTestUtils.intercept(RemoteException.class, (String)"FileNotFoundException", (String)"Expect FileNotFoundException.", () -> {
            DFSClient client = this.router.getClient(this.foo);
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(this.srcStr, this.dstStr);
        });
    }

    @Test
    public void testPermission6() throws Exception {
        this.createDir(this.routerFS, this.srcStr);
        this.routerFS.setAcl(this.srcPath.getParent(), this.buildAcl("foo", FsAction.ALL));
        Assert.assertTrue((boolean)this.routerFS.mkdirs(this.dstPath.getParent()));
        LambdaTestUtils.intercept(RemoteException.class, (String)"AccessControlException", (String)"Expect AccessControlException.", () -> {
            DFSClient client = this.router.getClient(this.foo);
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(this.srcStr, this.dstStr);
        });
    }

    @Test
    public void testPermission7() throws Exception {
        this.createDir(this.routerFS, this.srcStr);
        this.routerFS.setAcl(this.srcPath.getParent(), this.buildAcl("foo", FsAction.ALL));
        Assert.assertTrue((boolean)this.routerFS.mkdirs(this.dstPath.getParent()));
        this.routerFS.setOwner(this.dstPath.getParent(), "foo", "foogroup");
        DFSClient client = this.router.getClient(this.foo);
        ClientProtocol clientProtocol = client.getNamenode();
        clientProtocol.rename(this.srcStr, this.dstStr);
        Assert.assertFalse((boolean)FederationTestUtils.verifyFileExists(this.routerFS, this.srcStr));
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, this.dstStr + "/file"));
    }

    private List<AclEntry> buildAcl(String user, FsAction permission) {
        ArrayList aclEntryList = Lists.newArrayList();
        aclEntryList.add(new AclEntry.Builder().setName(user).setPermission(permission).setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).build());
        aclEntryList.add(new AclEntry.Builder().setPermission(FsAction.ALL).setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).build());
        aclEntryList.add(new AclEntry.Builder().setPermission(FsAction.ALL).setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build());
        aclEntryList.add(new AclEntry.Builder().setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).build());
        return aclEntryList;
    }
}

