/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.CollectionType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivitySubDoc;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun.FlowRunDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.DocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineCollectionReader {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollectionReader.class);
    private final DocumentStoreReader<TimelineEntityDocument> genericEntityDocReader;
    private final DocumentStoreReader<FlowRunDocument> flowRunDocReader;
    private final DocumentStoreReader<FlowActivityDocument> flowActivityDocReader;

    public TimelineCollectionReader(Configuration conf) throws YarnException {
        LOG.info("Initializing TimelineCollectionReader...");
        this.genericEntityDocReader = DocumentStoreFactory.createDocumentStoreReader(conf);
        this.flowRunDocReader = DocumentStoreFactory.createDocumentStoreReader(conf);
        this.flowActivityDocReader = DocumentStoreFactory.createDocumentStoreReader(conf);
    }

    public TimelineEntityDocument readDocument(TimelineReaderContext context) throws IOException {
        LOG.debug("Fetching document for entity type {}", (Object)context.getEntityType());
        switch (TimelineEntityType.valueOf((String)context.getEntityType())) {
            case YARN_APPLICATION: {
                return this.genericEntityDocReader.readDocument(CollectionType.APPLICATION.getCollectionName(), context, TimelineEntityDocument.class);
            }
            case YARN_FLOW_RUN: {
                FlowRunDocument flowRunDoc = this.flowRunDocReader.readDocument(CollectionType.FLOW_RUN.getCollectionName(), context, FlowRunDocument.class);
                FlowRunEntity flowRun = this.createFlowRunEntity(flowRunDoc);
                return new TimelineEntityDocument((TimelineEntity)flowRun);
            }
            case YARN_FLOW_ACTIVITY: {
                FlowActivityDocument flowActivityDoc = this.flowActivityDocReader.readDocument(CollectionType.FLOW_RUN.getCollectionName(), context, FlowActivityDocument.class);
                FlowActivityEntity flowActivity = this.createFlowActivityEntity(context, flowActivityDoc);
                return new TimelineEntityDocument((TimelineEntity)flowActivity);
            }
        }
        return this.genericEntityDocReader.readDocument(CollectionType.ENTITY.getCollectionName(), context, TimelineEntityDocument.class);
    }

    public List<TimelineEntityDocument> readDocuments(TimelineReaderContext context, long documentsSize) throws IOException {
        ArrayList<TimelineEntityDocument> entityDocs = new ArrayList<TimelineEntityDocument>();
        LOG.debug("Fetching documents for entity type {}", (Object)context.getEntityType());
        switch (TimelineEntityType.valueOf((String)context.getEntityType())) {
            case YARN_APPLICATION: {
                return this.genericEntityDocReader.readDocumentList(CollectionType.APPLICATION.getCollectionName(), context, TimelineEntityDocument.class, documentsSize);
            }
            case YARN_FLOW_RUN: {
                List<FlowRunDocument> flowRunDocs = this.flowRunDocReader.readDocumentList(CollectionType.FLOW_RUN.getCollectionName(), context, FlowRunDocument.class, documentsSize);
                for (FlowRunDocument flowRunDoc : flowRunDocs) {
                    entityDocs.add(new TimelineEntityDocument((TimelineEntity)this.createFlowRunEntity(flowRunDoc)));
                }
                return entityDocs;
            }
            case YARN_FLOW_ACTIVITY: {
                List<FlowActivityDocument> flowActivityDocs = this.flowActivityDocReader.readDocumentList(CollectionType.FLOW_ACTIVITY.getCollectionName(), context, FlowActivityDocument.class, documentsSize);
                for (FlowActivityDocument flowActivityDoc : flowActivityDocs) {
                    entityDocs.add(new TimelineEntityDocument((TimelineEntity)this.createFlowActivityEntity(context, flowActivityDoc)));
                }
                return entityDocs;
            }
        }
        return this.genericEntityDocReader.readDocumentList(CollectionType.ENTITY.getCollectionName(), context, TimelineEntityDocument.class, documentsSize);
    }

    public Set<String> fetchEntityTypes(TimelineReaderContext context) {
        LOG.debug("Fetching all entity-types for appId : {}", (Object)context.getAppId());
        return this.genericEntityDocReader.fetchEntityTypes(CollectionType.ENTITY.getCollectionName(), context);
    }

    private FlowActivityEntity createFlowActivityEntity(TimelineReaderContext context, FlowActivityDocument flowActivityDoc) {
        FlowActivityEntity flowActivity = new FlowActivityEntity(context.getClusterId(), flowActivityDoc.getDayTimestamp(), flowActivityDoc.getUser(), flowActivityDoc.getFlowName());
        flowActivity.setId(flowActivityDoc.getId());
        for (FlowActivitySubDoc activity : flowActivityDoc.getFlowActivities()) {
            FlowRunEntity flowRunEntity = new FlowRunEntity();
            flowRunEntity.setUser(flowActivityDoc.getUser());
            flowRunEntity.setName(activity.getFlowName());
            flowRunEntity.setRunId(activity.getFlowRunId());
            flowRunEntity.setVersion(activity.getFlowVersion());
            flowRunEntity.setId(flowRunEntity.getId());
            flowActivity.addFlowRun(flowRunEntity);
        }
        flowActivity.getInfo().put("FROM_ID", flowActivityDoc.getId());
        flowActivity.setCreatedTime(Long.valueOf(flowActivityDoc.getDayTimestamp()));
        return flowActivity;
    }

    private FlowRunEntity createFlowRunEntity(FlowRunDocument flowRunDoc) {
        FlowRunEntity flowRun = new FlowRunEntity();
        flowRun.setRunId(flowRunDoc.getFlowRunId().longValue());
        flowRun.setUser(flowRunDoc.getUsername());
        flowRun.setName(flowRunDoc.getFlowName());
        if (flowRunDoc.getMinStartTime() > 0L) {
            flowRun.setStartTime(flowRunDoc.getMinStartTime());
        }
        if (flowRunDoc.getMaxEndTime() > 0L) {
            flowRun.setMaxEndTime(flowRunDoc.getMaxEndTime());
        }
        if (!DocumentStoreUtils.isNullOrEmpty(flowRunDoc.getFlowVersion())) {
            flowRun.setVersion(flowRunDoc.getFlowVersion());
        }
        flowRun.setMetrics(flowRunDoc.fetchTimelineMetrics());
        flowRun.setId(flowRunDoc.getId());
        flowRun.getInfo().put("FROM_ID", flowRunDoc.getId());
        return flowRun;
    }

    public void close() throws Exception {
        this.genericEntityDocReader.close();
        this.flowRunDocReader.close();
        this.flowActivityDocReader.close();
    }
}

