/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.text.MessageFormat;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public abstract class Param<T> {
    private String name;
    protected T value;

    public Param(String name, T defaultValue) {
        this.name = name;
        this.value = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T parseParam(String str) {
        try {
            this.value = str != null && str.trim().length() > 0 ? this.parse(str) : this.value;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], invalid value [{1}], value must be [{2}]", this.name, str, this.getDomain()));
        }
        return this.value;
    }

    public T value() {
        return this.value;
    }

    protected abstract String getDomain();

    protected abstract T parse(String var1) throws Exception;

    public String toString() {
        return this.value != null ? this.value.toString() : "NULL";
    }
}

