/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.applications.mawo.server.worker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class WorkerId
implements Writable {
    private Text workerId = new Text();
    private Text hostname = new Text();
    private Text ipAdd = new Text();

    public WorkerId() {
        try {
            this.hostname = new Text(InetAddress.getLocalHost().getHostName());
            this.ipAdd = new Text(InetAddress.getLocalHost().getHostAddress().toString());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public final Text getHostname() {
        return this.hostname;
    }

    public final void setHostname(Text wkhostname) {
        this.hostname = wkhostname;
    }

    public final String getIPAddress() {
        return this.ipAdd.toString();
    }

    public final String toString() {
        return this.workerId.toString();
    }

    public final String getWorkerId() {
        return this.workerId.toString();
    }

    public final void setWorkerId(String localworkerId) {
        this.workerId = new Text(localworkerId);
    }

    public final boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerId x = (WorkerId)o;
        return x.getHostname().equals((Object)this.hostname);
    }

    public final void write(DataOutput dataOutput) throws IOException {
        this.workerId.write(dataOutput);
        this.hostname.write(dataOutput);
        this.ipAdd.write(dataOutput);
    }

    public final void readFields(DataInput dataInput) throws IOException {
        this.workerId.readFields(dataInput);
        this.hostname.readFields(dataInput);
        this.ipAdd.readFields(dataInput);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        int workerHash = 0;
        workerHash = this.workerId == null ? 0 : this.workerId.hashCode();
        int hostHash = 0;
        hostHash = this.hostname == null ? 0 : this.hostname.hashCode();
        int ipHash = 0;
        ipHash = this.ipAdd == null ? 0 : this.ipAdd.hashCode();
        result = 31 * result + workerHash;
        result = 31 * result + hostHash;
        result = 31 * result + ipHash;
        return result;
    }
}

