/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.JavaKeyStoreProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.Path;

public class FailureInjectingJavaKeyStoreProvider
extends JavaKeyStoreProvider {
    public static final String SCHEME_NAME = "failjceks";
    private boolean backupFail = false;
    private boolean writeFail = false;

    FailureInjectingJavaKeyStoreProvider(JavaKeyStoreProvider prov) {
        super(prov);
    }

    public void setBackupFail(boolean b) {
        this.backupFail = b;
    }

    public void setWriteFail(boolean b) {
        this.backupFail = b;
    }

    public void writeToNew(Path newPath) throws IOException {
        if (this.writeFail) {
            throw new IOException("Injecting failure on write");
        }
        super.writeToNew(newPath);
    }

    public boolean backupToOld(Path oldPath) throws IOException {
        if (this.backupFail) {
            throw new IOException("Inejection Failure on backup");
        }
        return super.backupToOld(oldPath);
    }

    public static class Factory
    extends KeyProviderFactory {
        public KeyProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (FailureInjectingJavaKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                try {
                    return new FailureInjectingJavaKeyStoreProvider((JavaKeyStoreProvider)new JavaKeyStoreProvider.Factory().createProvider(new URI(providerName.toString().replace(FailureInjectingJavaKeyStoreProvider.SCHEME_NAME, "jceks")), conf));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }
}

