/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source.lookup;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.table.connector.source.lookup.cache.trigger.PeriodicCacheReloadTrigger;

@PublicEvolving
public class LookupOptions {
    public static final ConfigOption<LookupCacheType> CACHE_TYPE = ConfigOptions.key((String)"lookup.cache").enumType(LookupCacheType.class).defaultValue((Object)LookupCacheType.NONE).withDescription(Description.builder().text("The caching strategy for this lookup table, including %s, %s and %s", new InlineElement[]{TextElement.code((String)LookupCacheType.NONE.toString()), TextElement.code((String)LookupCacheType.PARTIAL.toString()), TextElement.code((String)LookupCacheType.FULL.toString())}).build());
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)3).withDescription("The maximum allowed retries if a lookup operation fails");
    public static final ConfigOption<Duration> PARTIAL_CACHE_EXPIRE_AFTER_ACCESS = ConfigOptions.key((String)"lookup.partial-cache.expire-after-access").durationType().noDefaultValue().withDescription("Duration to expire an entry in the cache after accessing");
    public static final ConfigOption<Duration> PARTIAL_CACHE_EXPIRE_AFTER_WRITE = ConfigOptions.key((String)"lookup.partial-cache.expire-after-write").durationType().noDefaultValue().withDescription("Duration to expire an entry in the cache after writing");
    public static final ConfigOption<Boolean> PARTIAL_CACHE_CACHE_MISSING_KEY = ConfigOptions.key((String)"lookup.partial-cache.cache-missing-key").booleanType().defaultValue((Object)true).withDescription("Whether to store an empty value into the cache if the lookup key doesn't match any rows in the table");
    public static final ConfigOption<Long> PARTIAL_CACHE_MAX_ROWS = ConfigOptions.key((String)"lookup.partial-cache.max-rows").longType().noDefaultValue().withDescription("The maximum number of rows to store in the cache");
    public static final ConfigOption<ReloadStrategy> FULL_CACHE_RELOAD_STRATEGY = ConfigOptions.key((String)"lookup.full-cache.reload-strategy").enumType(ReloadStrategy.class).defaultValue((Object)ReloadStrategy.PERIODIC).withDescription(Description.builder().text("Defines which strategy to use to reload full cache: %s - cache is reloaded with fixed intervals without initial delay; %s - cache is reloaded at specified time with fixed intervals multiples of one day", new InlineElement[]{TextElement.code((String)ReloadStrategy.PERIODIC.toString()), TextElement.code((String)ReloadStrategy.TIMED.toString())}).build());
    public static final ConfigOption<Duration> FULL_CACHE_PERIODIC_RELOAD_INTERVAL = ConfigOptions.key((String)"lookup.full-cache.periodic-reload.interval").durationType().noDefaultValue().withDescription("Reload interval of Full cache with PERIODIC reload strategy");
    public static final ConfigOption<PeriodicCacheReloadTrigger.ScheduleMode> FULL_CACHE_PERIODIC_RELOAD_SCHEDULE_MODE = ConfigOptions.key((String)"lookup.full-cache.periodic-reload.schedule-mode").enumType(PeriodicCacheReloadTrigger.ScheduleMode.class).defaultValue((Object)PeriodicCacheReloadTrigger.ScheduleMode.FIXED_DELAY).withDescription(Description.builder().text("Defines which schedule mode to use in PERIODIC reload strategy of Full cache:%s - reload interval is a time between the end of previous and start of the next reload; %s - reload interval is a time between the start of previous and start of the next reload", new InlineElement[]{TextElement.code((String)PeriodicCacheReloadTrigger.ScheduleMode.FIXED_DELAY.toString()), TextElement.code((String)PeriodicCacheReloadTrigger.ScheduleMode.FIXED_RATE.toString())}).build());
    public static final ConfigOption<String> FULL_CACHE_TIMED_RELOAD_ISO_TIME = ConfigOptions.key((String)"lookup.full-cache.timed-reload.iso-time").stringType().noDefaultValue().withDescription("Time in ISO-8601 format when Full cache with TIMED strategy needs to be reloaded. It can be useful when dimension is updated once a few days at specified time. Time can be specified either with timezone or without timezone (target JVM local timezone will be used). For example, '10:15' = local TZ, '10:15Z' = UTC TZ, '10:15+07:00' = UTC +7 TZ");
    public static final ConfigOption<Integer> FULL_CACHE_TIMED_RELOAD_INTERVAL_IN_DAYS = ConfigOptions.key((String)"lookup.full-cache.timed-reload.interval-in-days").intType().defaultValue((Object)1).withDescription("Number of days between reloads of Full cache with TIMED strategy");

    @PublicEvolving
    public static enum ReloadStrategy {
        PERIODIC,
        TIMED;

    }

    @PublicEvolving
    public static enum LookupCacheType {
        NONE,
        PARTIAL,
        FULL;

    }
}

