/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.com.ibm.icu.number;

import java.util.Locale;
import org.apache.flink.table.shaded.com.ibm.icu.impl.number.DecimalFormatProperties;
import org.apache.flink.table.shaded.com.ibm.icu.number.LocalizedNumberFormatter;
import org.apache.flink.table.shaded.com.ibm.icu.number.NumberPropertyMapper;
import org.apache.flink.table.shaded.com.ibm.icu.number.NumberSkeletonImpl;
import org.apache.flink.table.shaded.com.ibm.icu.number.UnlocalizedNumberFormatter;
import org.apache.flink.table.shaded.com.ibm.icu.text.DecimalFormatSymbols;
import org.apache.flink.table.shaded.com.ibm.icu.util.ULocale;

public final class NumberFormatter {
    private static final UnlocalizedNumberFormatter BASE = new UnlocalizedNumberFormatter();
    static final long DEFAULT_THRESHOLD = 3L;

    private NumberFormatter() {
    }

    public static UnlocalizedNumberFormatter with() {
        return BASE;
    }

    public static LocalizedNumberFormatter withLocale(Locale locale) {
        return BASE.locale(locale);
    }

    public static LocalizedNumberFormatter withLocale(ULocale locale) {
        return BASE.locale(locale);
    }

    public static UnlocalizedNumberFormatter forSkeleton(String skeleton) {
        return NumberSkeletonImpl.getOrCreate(skeleton);
    }

    @Deprecated
    public static UnlocalizedNumberFormatter fromDecimalFormat(DecimalFormatProperties properties, DecimalFormatSymbols symbols, DecimalFormatProperties exportedProperties) {
        return NumberPropertyMapper.create(properties, symbols, exportedProperties);
    }

    public static enum DecimalSeparatorDisplay {
        AUTO,
        ALWAYS;

    }

    public static enum SignDisplay {
        AUTO,
        ALWAYS,
        NEVER,
        ACCOUNTING,
        ACCOUNTING_ALWAYS,
        EXCEPT_ZERO,
        ACCOUNTING_EXCEPT_ZERO;

    }

    public static enum GroupingStrategy {
        OFF,
        MIN2,
        AUTO,
        ON_ALIGNED,
        THOUSANDS;

    }

    public static enum UnitWidth {
        NARROW,
        SHORT,
        FULL_NAME,
        ISO_CODE,
        FORMAL,
        VARIANT,
        HIDDEN;

    }
}

