/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern.conditions;

import org.apache.flink.annotation.Internal;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.util.Preconditions;

@Internal
public class SubtypeCondition<T>
extends SimpleCondition<T> {
    private static final long serialVersionUID = -2990017519957561355L;
    private final Class<? extends T> subtype;

    public SubtypeCondition(Class<? extends T> subtype) {
        this.subtype = (Class)Preconditions.checkNotNull(subtype, (String)"The subtype cannot be null.");
    }

    public boolean filter(T value) throws Exception {
        return this.subtype.isAssignableFrom(value.getClass());
    }
}

