# Apache DolphinScheduler安全模型

本文档主要用于描述不同角色用户的工作范围、职责和重点功能，通过对用户权限和功能的介绍辅助用户在了解部署、使用、运维等阶段的注意事项和规则。针对开发者可以通过本文档了解安全漏洞与正常功能的边界。

## Apache DolphinScheduler工作流程

从了解到使用Apache DolphinScheduler，用户一般会经过以下几个阶段。

1.系统部署，配置运行环境

2.创建系统用户，配置对应资源

3.创建工作流定义，配置任务运行

4.系统运维

无论用户使用的是单节点、伪集群、还是集群部署（服务器或云部署），对于系统的使用都会经过以上四个步骤。针对上述四个步骤，一般会涉及到以下三种类型的用户。

## 用户类型

### 1.服务部署人员

服务部署人员需要拥有操作服务器的权限，服务部署人员需要了解相关任务运行的方式，已确保服务器安全边界和环境要求。
(1).对于多租户运行场景，服务器部署用户需要具备创建用户和切换用户权限。
(2).Apache DolphinScheduler中可以运行用户自定的脚本和代码，用户可以通过节点配置运行机器上执行任意命令或代码，服务部署人员需要确认服务启动用户的权限，通过权限保护一些敏感文件，明确部署用户的操作权限边界。
(3).服务器会进行数据源连接操作，执行用户自定义的sql语句，平台不会限制用户执行sql的类型，sql执行的权限与创建创建数据源的用户权限有关。
(4).服务器部署人员需要确保业务所需的worker分组中所有的worker服务器与任务运行所需资源之间的网络和交互安全要求。
(5).对于worker本地任务类型（datax等）需要具备调用对应服务的权限。
(6).Apache DolphinScheduler提供的资源中心可以直接对接本地文件系统，在集群部署环境下，可以通过共享文件方式挂载其他服务器文件到api服务器上实现文件访问，此处服务部署人员需要确保挂载文件目录中包含的文件允许系统用户操作，并且信任操作用户的操作行为。
(7).Apache DolphinScheduler 支持k8s任务类型，k8s集群由运维提供，运维需要保证k8s的服务安全问题，防止出现pod逃逸等安全问题。

### 2.系统管理员

系统管理员拥有Apache DolphinScheduler所有的操作权限，在实际使用中应该确保管理员用户的使用范围，并高度信任管理员用户不会滥用此功能。
(1).管理员用户可以操作队列管理、租户管理、用户管理、告警组管理、worker分组管理、令牌管理等功能，管理员用户可以操作所有的配置，其中包括连接资源所需的敏感凭证等重要信息，要确保使用管理员用户的人员可以操作对应资源。同时管理员用户在用户管理模块可以对资源、数据源、项目等授权操作，管理员用户需要明确授权后用户将对对应资源拥有所有使用权限。
(2).系统管理员用户拥有普通用户所有的操作权限

### 3.系统普通用户

Apache DolphinScheduler的普通用户定义为实际的工作流开发和运营用户，当然也需要维护在工作流开发过程中所需要的部分资源。应该高度信任这些用户不会滥用此功能。
(1).用户可以创建工作流和任务，任务支撑类型列表查看【任务列表】，任务会在worker中执行，用户可以自定义任意命令和代码在指定的worker分组中运行，一定要注意这里的任意命令和代码，用户可以执行Apache DolphinScheduler支持任务类型下的所有任务，包括shell、sql、和跳转至其他服务器执行shell脚本等任务。同时任务运行过程会产生日志，用户可以通过UI页面查看、下载任务运行日志。
(2).用户可以创建数据源连接，可以修改、删除有权限的连接包括对应的配置，尤其是对有权限连接的敏感凭据的操作，这些操作可能会对资源本身或系统造成一定的影响，数据源包括众多种类，具体可以查看官网中【数据源列表】。

### 4.未登录用户

Apache DolphinScheduler不允许未登录用户访问系统。下文中提到的用户不包含该类型用户。

平台正常使用除核心的工作流开发、运行外，还需要配置、管理对应的环境和资源。

## 数据源管理

所有用户均可操作数据源管理，管理员用户可对普通用户进行授权后进行操作。数据源任务运行的对应权限由数据源连接提供，连接配置应尽量控制任务执行权限。数据源配置中，用户可以自定义连接参数，并对所有使用该数据源的任务生效。

## 资源中心

资源中心可以配置本地、分布式文件存储、云对象存储等多种方式，当需要使用资源中心进行相关文件的创建或者上传操作时，所有的文件和资源都会被存储在分布式文件系统HDFS或者远端的对象存储。同时用户可修改有权限文件的内容，在这个过程中需要信任用户不会损坏文件，不会造成其他安全风险。

## 告警管理

告警方式支持列表可查看官网中【告警】，所有用户可将有权限的告警通道配置到各自的流程中。用户可以修改包含敏感凭据的告警配置。告警配置会应用在工作流运行超时、结果等规则的告警中，需要信任用户告警的配置和告警信息的发送不会对告警通道和接受告警人员产生影响。

## 认证方式

Apache DolphinScheduler支持四种认证方式，自身账号密码登录，LDAP, 通过Casdoor实现的SSO登录和通过Oauth2授权登录，并且oauth2授权登录方式可以和其他认证方式同时使用。需要高度信任用户以任何方式登录的用户都不会滥用对应权限和功能。

## 安全中心

管理员用户可以配置队列、租户、用户、告警组、worker分组、令牌、k8s集群、k8s命名空间等资源，需要信用用户对资源的权限分配、使用、维护，都不会对平台和服务本身产生影响。

### 误认为是安全漏洞的示例

以下是以往使用者和开发者提出的一些错误的漏洞情况。

1.利用插件的不安全设置进行攻击或其他操作
用户使用某个插件时，将某些参数设置成不安全的配置，进而通过该配置进行系统攻击，这种问题不属于安全漏洞。这种插件包括但不限于数据源、任务等，用户对于参数的设置属于主动行为，授权事已信任用户的参数配置操作，用户在设置对应的参数或某个配置时认为该配置用户已经完全了解所配置的功能和所带来的风险，所以该类型的问题不属于漏洞。例如在使用mysql驱动链接doris时，在jdbc的连接参数中增加了{"aaa":"dsf&allowLoadLocalInfile=true#"}，该配置可能会将本地的敏感文件发送至服务器，在该过程中，用户按需增加了配置，则信任用户的所有操作。
2.利用部署时的安全配置访问系统进行攻击或其他操作
部署用户在系统部署时应该按照官网的操作，将敏感配置进行修改，该配置属于服务敏感信息，其重要和安全级别等同与服务数据库连接等信息。当其他用户无论通过任何途径获取到敏感配置后，平台变认为该用户为正常授权用户，完全信任授权用户的所有操作。例如用户通过配置文件中获取了auth-token数据，通过该配置进行鉴权并且创建用户，利用创建的用户对系统进行操作，该过程中既然用户获得了平台的鉴权信息，则认为信任用户的所有操作。
3.执行平台在任务执行过程中产生的中间文件
在Apache DolphinScheduler运行任务的过程中会产生部分中间文件，该文件主要是封装任务运行所需的环境和参数等信息，该文件与任务相关，并且与运行的任务存储在同一个节点中，运行这些文件与其他用户在同一个节点中运行同一个任务没有差异。在部署和权限的分配过程中，将对应的worker或其他资源分配给对应的用户，这个操作意味着完全信任该用户对该服务节点的所有操作，包括任务运行和读取、修改服务器中有权限的资源，当然也包括平台所生成的文件。所以该类型问题不属于漏洞。例如remote shell任务会在服务器中生产一个中间文件，用户得知了文件信息，通过shell节点操作该文件，在该过程中，用户具有该节点的权限，则信任用户对该节点的所有操作。
4.已授权用户通过页面输入框输入脚本进行攻击或其他操作
在Apache DolphinScheduler有多个输入框，允许用户按需进行自定义配置，Apache DolphinScheduler作为开源任务调度系统，管理员用户在部署、授权等涉及安全的过程中需要完全信任目标用户的所有授权范围内的操作，用户通过页面或调用接口增加、修改配置的行为如果属于权限范围内的操作，则通过该方式进行攻击或其他操作的行为不属于安全漏洞。
5.通过修改镜像或提供不安全的镜像运行进行攻击或其他操作
Apache DolphinScheduler的本身和任务运行均支持k8s集群，在服务或任务运行之前，用户需要确保镜像的功能和所配置参数，信任服务、任务运行过程中的所有操作。所以在镜像运行之前通过任何途径将任务或参数进行修改进行攻击或其他完成其他操作的行为不属于安全漏洞。
