/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.provider;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.inject.Provider;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

public class DependentProvider<T>
implements Provider<T>,
Serializable {
    private static final long serialVersionUID = 23423413412001L;
    private T instance;
    private CreationalContext<T> creationalContext;
    private transient Bean<T> bean;

    DependentProvider(Bean<T> bean, CreationalContext<T> creationalContext, T instance) {
        this.bean = bean;
        this.creationalContext = creationalContext;
        this.instance = instance;
    }

    public T get() {
        return this.instance;
    }

    public void destroy() {
        if (!BeanManagerProvider.getInstance().getBeanManager().isNormalScope(this.bean.getScope())) {
            this.bean.destroy(this.instance, this.creationalContext);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(this.bean instanceof PassivationCapable)) {
            throw new NotSerializableException("Bean is not PassivationCapable: " + this.bean.toString());
        }
        String passivationId = ((PassivationCapable)this.bean).getId();
        if (passivationId == null) {
            throw new NotSerializableException(this.bean.toString());
        }
        out.writeLong(23423413412001L);
        out.writeObject(passivationId);
        out.writeObject(this.instance);
        out.writeObject(this.creationalContext);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long oldSerialId = in.readLong();
        if (oldSerialId != 23423413412001L) {
            throw new NotSerializableException(this.getClass().getName() + " serialVersion does not match");
        }
        String passivationId = (String)in.readObject();
        this.bean = BeanManagerProvider.getInstance().getBeanManager().getPassivationCapableBean(passivationId);
        this.instance = in.readObject();
        this.creationalContext = (CreationalContext)in.readObject();
    }
}

