/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.mergepoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.torque.generator.control.action.MergepointAction;

public class MergepointMapping {
    private final String name;
    private final List<MergepointAction> actions = new ArrayList<MergepointAction>();

    public MergepointMapping(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
    }

    public MergepointMapping(String name, List<MergepointAction> actions) {
        this(name);
        this.actions.addAll(actions);
    }

    public String getName() {
        return this.name;
    }

    public List<MergepointAction> getActions() {
        return this.actions;
    }

    public void addAction(MergepointAction action) {
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this.actions.add(action);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(name=").append(this.name).append(",actions=").append(this.actions).append(")");
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MergepointMapping other = (MergepointMapping)obj;
        if (!Objects.equals(this.actions, other.actions)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }
}

