/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage;

public class DisconnectMessage_V2
extends DisconnectMessage {
    private SimpleString scaleDownNodeID;

    public DisconnectMessage_V2(SimpleString nodeID, String scaleDownNodeID) {
        super((byte)124);
        this.nodeID = nodeID;
        this.scaleDownNodeID = SimpleString.of((String)scaleDownNodeID);
    }

    public DisconnectMessage_V2() {
        super((byte)124);
    }

    public SimpleString getScaleDownNodeID() {
        return this.scaleDownNodeID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeNullableSimpleString(this.scaleDownNodeID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.scaleDownNodeID = buffer.readNullableSimpleString();
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", nodeID=" + String.valueOf(this.nodeID));
        sb.append(", scaleDownNodeID=" + String.valueOf(this.scaleDownNodeID));
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.scaleDownNodeID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DisconnectMessage_V2)) {
            return false;
        }
        DisconnectMessage_V2 other = (DisconnectMessage_V2)obj;
        return Objects.equals(this.scaleDownNodeID, other.scaleDownNodeID);
    }
}

