/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache.jcache;

import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.cache.AbstractIdentityCache;
import org.apache.cxf.sts.cache.EHCacheIdentityValue;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.cxf.ws.security.utils.JCacheSupport;

@ManagedResource
public class JCacheIdentityCache
extends AbstractIdentityCache
implements Closeable,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(JCacheIdentityCache.class);
    private static final String KEY = "org.apache.cxf.sts.cache.EHCacheIdentityCache";
    private Cache<String, EHCacheIdentityValue> cache;
    private final CacheManager cacheManager;

    public JCacheIdentityCache(IdentityMapper identityMapper, Bus b) {
        this(identityMapper, JCacheIdentityCache.class.getName(), b, null);
    }

    public JCacheIdentityCache(IdentityMapper identityMapper, String key, Bus b, URL configFileURL) {
        this(Caching.getCachingProvider(), identityMapper, key, b, configFileURL);
    }

    JCacheIdentityCache(CachingProvider cachingProvider, IdentityMapper identityMapper, String key, Bus b, URL configFileURL) {
        super(b, identityMapper);
        if (b != null) {
            ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
            InstrumentationManager im = (InstrumentationManager)b.getExtension(InstrumentationManager.class);
            if (im != null) {
                try {
                    im.register((ManagedComponent)this);
                }
                catch (JMException e) {
                    LOG.log(Level.WARNING, "Registering JCacheIdentityCache failed.", e);
                }
            }
        }
        URL xmlConfigURL = configFileURL != null ? configFileURL : this.getDefaultConfigFileURL();
        try {
            this.cacheManager = cachingProvider.getCacheManager(xmlConfigURL.toURI(), this.getClass().getClassLoader());
            this.cache = JCacheSupport.getOrCreate((CacheManager)this.cacheManager, (String)KEY, String.class, EHCacheIdentityValue.class);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Unable to convert " + xmlConfigURL + " to URI", ex);
        }
    }

    @Override
    public void add(String user, String realm, Map<String, String> identities) {
        this.cache.put((Object)(user + "@" + realm), (Object)new EHCacheIdentityValue(identities));
    }

    @Override
    @ManagedOperation
    public Map<String, String> get(String user, String realm) {
        EHCacheIdentityValue value = (EHCacheIdentityValue)this.cache.get((Object)(user + "@" + realm));
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    @Override
    public void remove(String user, String realm) {
        this.cache.remove((Object)(user + "@" + realm));
    }

    @ManagedOperation
    public String getContent() {
        return this.cache.toString();
    }

    @Override
    public synchronized void close() {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(KEY);
            this.cacheManager.close();
            if (super.getBus() != null) {
                ((BusLifeCycleManager)super.getBus().getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }

    private URL getDefaultConfigFileURL() {
        URL url = null;
        if (super.getBus() != null) {
            ResourceManager rm = (ResourceManager)super.getBus().getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource("sts-jcache.xml", URL.class);
        }
        try {
            if (url == null) {
                url = ClassLoaderUtils.getResource((String)"sts-jcache.xml", TokenStoreFactory.class);
            }
            if (url == null) {
                url = new URL("sts-jcache.xml");
            }
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ObjectName getObjectName() throws JMException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("org.apache.cxf").append(':');
        if (super.getBus() != null) {
            buffer.append("bus.id").append('=').append(super.getBus().getId()).append(',');
        }
        buffer.append("type").append('=').append("EHCacheIdentityCache").append(',');
        buffer.append("name").append('=').append("EHCacheIdentityCache-").append(System.identityHashCode(this));
        return new ObjectName(buffer.toString());
    }
}

