/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSourceChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSourceChannel {
    private final ChannelListener.SimpleSetter<? extends R> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<? extends R> closeSetter = new ChannelListener.SimpleSetter();
    private final C framedChannel;
    private final Deque<FrameData> pendingFrameData = new LinkedList<FrameData>();
    private int state = 0;
    private static final int STATE_DONE = 2;
    private static final int STATE_READS_RESUMED = 4;
    private static final int STATE_READS_AWAKEN = 8;
    private static final int STATE_CLOSED = 16;
    private static final int STATE_LAST_FRAME = 32;
    private static final int STATE_IN_LISTENER_LOOP = 64;
    private static final int STATE_STREAM_BROKEN = 128;
    private static final int STATE_RETURNED_MINUS_ONE = 256;
    private static final int STATE_WAITNG_MINUS_ONE = 512;
    private volatile PooledByteBuffer data;
    private int currentDataOriginalSize;
    private long frameDataRemaining;
    private final Object lock = new Object();
    private int waiters;
    private volatile boolean waitingForFrame;
    private int readFrameCount = 0;
    private long maxStreamSize = -1L;
    private long currentStreamSize;
    private ChannelListener[] closeListeners = null;

    public AbstractFramedStreamSourceChannel(C framedChannel) {
        this.framedChannel = framedChannel;
        this.waitingForFrame = true;
    }

    public AbstractFramedStreamSourceChannel(C framedChannel, PooledByteBuffer data, long frameDataRemaining) {
        this.framedChannel = framedChannel;
        this.waitingForFrame = data == null && frameDataRemaining <= 0L;
        this.frameDataRemaining = frameDataRemaining;
        this.currentStreamSize = frameDataRemaining;
        if (data != null) {
            if (!data.getBuffer().hasRemaining()) {
                data.close();
                this.data = null;
                this.waitingForFrame = frameDataRemaining <= 0L;
            } else {
                this.dataReady(null, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        block15: {
            if (Bits.anyAreSet((int)this.state, (int)2)) {
                return -1L;
            }
            this.beforeRead();
            if (this.waitingForFrame) {
                return 0L;
            }
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)32)) {
                Object object = this.lock;
                synchronized (object) {
                    this.state |= 0x100;
                    long l = -1L;
                    return l;
                }
            }
            if (this.data == null) break block15;
            int old = this.data.getBuffer().limit();
            try {
                if (count < (long)this.data.getBuffer().remaining()) {
                    this.data.getBuffer().limit((int)((long)this.data.getBuffer().position() + count));
                }
                long l = target.write(this.data.getBuffer(), position);
                return l;
            }
            finally {
                this.data.getBuffer().limit(old);
                this.decrementFrameDataRemaining();
            }
        }
        long l = 0L;
        return l;
        finally {
            this.exitRead();
        }
    }

    private void decrementFrameDataRemaining() {
        if (!this.data.getBuffer().hasRemaining()) {
            this.frameDataRemaining -= (long)this.currentDataOriginalSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        block17: {
            if (Bits.anyAreSet((int)this.state, (int)2)) {
                return -1L;
            }
            this.beforeRead();
            if (this.waitingForFrame) {
                throughBuffer.position(throughBuffer.limit());
                return 0L;
            }
            if (this.frameDataRemaining != 0L || !Bits.anyAreSet((int)this.state, (int)32)) break block17;
            Object object = this.lock;
            synchronized (object) {
                this.state |= 0x100;
                long l = -1L;
                return l;
            }
        }
        if (this.data != null && this.data.getBuffer().hasRemaining()) {
            int old = this.data.getBuffer().limit();
            try {
                if (count < (long)this.data.getBuffer().remaining()) {
                    this.data.getBuffer().limit((int)((long)this.data.getBuffer().position() + count));
                }
                int written = streamSinkChannel.write(this.data.getBuffer());
                if (this.data.getBuffer().hasRemaining()) {
                    throughBuffer.clear();
                    Buffers.copy((ByteBuffer)throughBuffer, (ByteBuffer)this.data.getBuffer());
                    throughBuffer.flip();
                } else {
                    throughBuffer.position(throughBuffer.limit());
                }
                long l = written;
                return l;
            }
            finally {
                this.data.getBuffer().limit(old);
                this.decrementFrameDataRemaining();
            }
        }
        throughBuffer.position(throughBuffer.limit());
        long l = 0L;
        return l;
        finally {
            this.exitRead();
        }
    }

    public long getMaxStreamSize() {
        return this.maxStreamSize;
    }

    public void setMaxStreamSize(long maxStreamSize) {
        this.maxStreamSize = maxStreamSize;
        if (maxStreamSize > 0L && maxStreamSize < this.currentStreamSize) {
            this.handleStreamTooLarge();
        }
    }

    private void handleStreamTooLarge() {
        IoUtils.safeClose((Closeable)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendReads() {
        Object object = this.lock;
        synchronized (object) {
            this.state &= 0xFFFFFFF3;
        }
    }

    protected void complete() throws IOException {
        this.close();
    }

    protected boolean isComplete() {
        return Bits.anyAreSet((int)this.state, (int)2);
    }

    public void resumeReads() {
        this.resumeReadsInternal(false);
    }

    public boolean isReadResumed() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public void wakeupReads() {
        this.resumeReadsInternal(true);
    }

    public void addCloseTask(ChannelListener<R> channelListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ChannelListener[]{channelListener};
        } else {
            ChannelListener[] old = this.closeListeners;
            this.closeListeners = new ChannelListener[old.length + 1];
            System.arraycopy(old, 0, this.closeListeners, 0, old.length);
            this.closeListeners[old.length] = channelListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeReadsInternal(boolean wakeup) {
        Object object = this.lock;
        synchronized (object) {
            this.state |= 4;
            if (wakeup) {
                this.state |= 8;
            } else if (!Bits.anyAreSet((int)this.state, (int)4)) {
                return;
            }
            if (!Bits.anyAreSet((int)this.state, (int)64)) {
                this.state |= 0x40;
                ((AbstractFramedChannel)this.getFramedChannel()).runInIoThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            boolean readAgain;
                            do {
                                ChannelListener listener = AbstractFramedStreamSourceChannel.this.getReadListener();
                                Object object = AbstractFramedStreamSourceChannel.this.lock;
                                synchronized (object) {
                                    AbstractFramedStreamSourceChannel.this.state &= 0xFFFFFFF7;
                                    if (listener == null || !AbstractFramedStreamSourceChannel.this.isReadResumed()) {
                                        AbstractFramedStreamSourceChannel.this.state &= 0xFFFFFFBF;
                                        return;
                                    }
                                }
                                ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedStreamSourceChannel.this), listener);
                                object = AbstractFramedStreamSourceChannel.this.lock;
                                synchronized (object) {
                                    boolean moreData = AbstractFramedStreamSourceChannel.this.frameDataRemaining > 0L && AbstractFramedStreamSourceChannel.this.data != null || !AbstractFramedStreamSourceChannel.this.pendingFrameData.isEmpty() || Bits.anyAreSet((int)AbstractFramedStreamSourceChannel.this.state, (int)512);
                                    boolean bl = readAgain = (AbstractFramedStreamSourceChannel.this.isReadResumed() && moreData || Bits.allAreSet((int)AbstractFramedStreamSourceChannel.this.state, (int)8)) && Bits.allAreClear((int)AbstractFramedStreamSourceChannel.this.state, (int)144);
                                    if (!readAgain) {
                                        AbstractFramedStreamSourceChannel.this.state &= 0xFFFFFFBF;
                                    }
                                }
                            } while (readAgain);
                        }
                        catch (Error | RuntimeException e) {
                            Object object = AbstractFramedStreamSourceChannel.this.lock;
                            synchronized (object) {
                                AbstractFramedStreamSourceChannel.this.state &= 0xFFFFFFBF;
                            }
                        }
                    }
                });
            }
        }
    }

    private ChannelListener<? super R> getReadListener() {
        return this.readSetter.get();
    }

    public void shutdownReads() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lastFrame() {
        Object object = this.lock;
        synchronized (object) {
            this.state |= 0x20;
        }
        this.waitingForFrame = false;
        if (this.data == null && this.pendingFrameData.isEmpty() && this.frameDataRemaining == 0L) {
            object = this.lock;
            synchronized (object) {
                this.state |= 2;
            }
            ((AbstractFramedChannel)this.getFramedChannel()).notifyFrameReadComplete(this);
            IoUtils.safeClose((Closeable)((Object)this));
        }
    }

    protected boolean isLastFrame() {
        return Bits.anyAreSet((int)this.state, (int)32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable() throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        if (this.data == null && this.pendingFrameData.isEmpty() && !Bits.anyAreSet((int)this.state, (int)144)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.data == null && this.pendingFrameData.isEmpty() && !Bits.anyAreSet((int)this.state, (int)144)) {
                    try {
                        ++this.waiters;
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                    finally {
                        --this.waiters;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable(long l, TimeUnit timeUnit) throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        if (this.data == null && this.pendingFrameData.isEmpty() && !Bits.anyAreSet((int)this.state, (int)144)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.data == null && this.pendingFrameData.isEmpty() && !Bits.anyAreSet((int)this.state, (int)144)) {
                    try {
                        ++this.waiters;
                        this.lock.wait(timeUnit.toMillis(l));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                    finally {
                        --this.waiters;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataReady(FrameHeaderData headerData, PooledByteBuffer frameData) {
        if (Bits.anyAreSet((int)this.state, (int)144)) {
            frameData.close();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean newData = this.pendingFrameData.isEmpty();
            this.pendingFrameData.add(new FrameData(headerData, frameData));
            if (newData && this.waiters > 0) {
                this.lock.notifyAll();
            }
            this.waitingForFrame = false;
        }
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            this.resumeReadsInternal(true);
        }
        if (headerData != null) {
            this.currentStreamSize += headerData.getFrameLength();
            if (this.maxStreamSize > 0L && this.currentStreamSize > this.maxStreamSize) {
                this.handleStreamTooLarge();
            }
        }
    }

    protected long updateFrameDataRemaining(PooledByteBuffer frameData, long frameDataRemaining) {
        return frameDataRemaining;
    }

    protected PooledByteBuffer processFrameData(PooledByteBuffer data, boolean lastFragmentOfFrame) throws IOException {
        return data;
    }

    protected void handleHeaderData(FrameHeaderData headerData) {
    }

    public XnioExecutor getReadThread() {
        return ((AbstractFramedChannel)this.framedChannel).getIoThread();
    }

    public ChannelListener.Setter<? extends R> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends R> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return ((AbstractFramedChannel)this.framedChannel).getWorker();
    }

    public XnioIoThread getIoThread() {
        return ((AbstractFramedChannel)this.framedChannel).getIoThread();
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1L;
        }
        this.beforeRead();
        if (this.waitingForFrame) {
            return 0L;
        }
        try {
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)32)) {
                Object object = this.lock;
                synchronized (object) {
                    this.state |= 0x100;
                }
                long l = -1L;
                return l;
            }
            if (this.data != null) {
                int old = this.data.getBuffer().limit();
                try {
                    long count = Buffers.remaining((Buffer[])dsts, (int)offset, (int)length);
                    if (count < (long)this.data.getBuffer().remaining()) {
                        this.data.getBuffer().limit((int)((long)this.data.getBuffer().position() + count));
                    } else {
                        count = this.data.getBuffer().remaining();
                    }
                    long l = Buffers.copy((int)((int)count), (ByteBuffer[])dsts, (int)offset, (int)length, (ByteBuffer)this.data.getBuffer());
                    return l;
                }
                finally {
                    this.data.getBuffer().limit(old);
                    this.decrementFrameDataRemaining();
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            this.exitRead();
        }
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1;
        }
        if (!dst.hasRemaining()) {
            return 0;
        }
        this.beforeRead();
        if (this.waitingForFrame) {
            return 0;
        }
        try {
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)32)) {
                Object object = this.lock;
                synchronized (object) {
                    this.state |= 0x100;
                }
                int n = -1;
                return n;
            }
            if (this.data != null) {
                int old = this.data.getBuffer().limit();
                try {
                    int count = dst.remaining();
                    if (count < this.data.getBuffer().remaining()) {
                        this.data.getBuffer().limit(this.data.getBuffer().position() + count);
                    } else {
                        count = this.data.getBuffer().remaining();
                    }
                    int n = Buffers.copy((int)count, (ByteBuffer)dst, (ByteBuffer)this.data.getBuffer());
                    return n;
                }
                finally {
                    this.data.getBuffer().limit(old);
                    this.decrementFrameDataRemaining();
                }
            }
            int n = 0;
            return n;
        }
        finally {
            try {
                this.exitRead();
            }
            catch (Throwable e) {
                this.markStreamBroken();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeRead() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)128)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (this.data == null) {
            Object object = this.lock;
            synchronized (object) {
                FrameData pending = this.pendingFrameData.poll();
                if (pending != null) {
                    PooledByteBuffer frameData = pending.getFrameData();
                    boolean hasData = true;
                    if (!frameData.getBuffer().hasRemaining()) {
                        frameData.close();
                        hasData = false;
                    }
                    if (pending.getFrameHeaderData() != null) {
                        this.frameDataRemaining = pending.getFrameHeaderData().getFrameLength();
                        this.handleHeaderData(pending.getFrameHeaderData());
                    }
                    if (hasData) {
                        this.frameDataRemaining = this.updateFrameDataRemaining(frameData, this.frameDataRemaining);
                        this.currentDataOriginalSize = frameData.getBuffer().remaining();
                        try {
                            this.data = this.processFrameData(frameData, this.frameDataRemaining - (long)this.currentDataOriginalSize == 0L);
                        }
                        catch (Throwable e) {
                            frameData.close();
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
                            this.markStreamBroken();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitRead() throws IOException {
        if (this.data != null && !this.data.getBuffer().hasRemaining()) {
            this.data.close();
            this.data = null;
        }
        if (this.frameDataRemaining == 0L) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    ++this.readFrameCount;
                    if (this.pendingFrameData.isEmpty()) {
                        if (Bits.anyAreSet((int)this.state, (int)256)) {
                            this.state |= 2;
                            this.complete();
                            this.close();
                        } else if (Bits.anyAreSet((int)this.state, (int)32)) {
                            this.state |= 0x200;
                        } else {
                            this.waitingForFrame = true;
                        }
                    }
                }
            }
            finally {
                if (this.pendingFrameData.isEmpty()) {
                    ((AbstractFramedChannel)this.framedChannel).notifyFrameReadComplete(this);
                }
            }
        }
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (Bits.anyAreSet((int)this.state, (int)16)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet((int)this.state, (int)16)) {
                return;
            }
            this.state |= 0x10;
            if (Bits.allAreClear((int)this.state, (int)34)) {
                this.state |= 0x80;
                this.channelForciblyClosed();
            }
            if (this.data != null) {
                this.data.close();
                this.data = null;
            }
            while (!this.pendingFrameData.isEmpty()) {
                this.pendingFrameData.poll().frameData.close();
            }
            ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
            if (this.closeListeners != null) {
                for (int i = 0; i < this.closeListeners.length; ++i) {
                    this.closeListeners[i].handleEvent((Channel)((Object)this));
                }
            }
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
    }

    protected void channelForciblyClosed() {
    }

    protected C getFramedChannel() {
        return this.framedChannel;
    }

    protected int getReadFrameCount() {
        return this.readFrameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markStreamBroken() {
        if (Bits.anyAreSet((int)this.state, (int)128)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.state |= 0x80;
            PooledByteBuffer data = this.data;
            if (data != null) {
                try {
                    data.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.data = null;
            }
            for (FrameData frame : this.pendingFrameData) {
                frame.frameData.close();
            }
            this.pendingFrameData.clear();
            if (this.isReadResumed()) {
                this.resumeReadsInternal(true);
            }
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
    }

    private class FrameData {
        private final FrameHeaderData frameHeaderData;
        private final PooledByteBuffer frameData;

        FrameData(FrameHeaderData frameHeaderData, PooledByteBuffer frameData) {
            this.frameHeaderData = frameHeaderData;
            this.frameData = frameData;
        }

        FrameHeaderData getFrameHeaderData() {
            return this.frameHeaderData;
        }

        PooledByteBuffer getFrameData() {
            return this.frameData;
        }
    }
}

