/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdui.impl;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.LangBearing;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdui.Keywords;

public class KeywordsImpl
extends AbstractXMLObject
implements Keywords {
    private String lang;
    @Nonnull
    private List<String> data = Collections.emptyList();

    protected KeywordsImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public List<XMLObject> getOrderedChildren() {
        return null;
    }

    public String getXMLLang() {
        return this.lang;
    }

    public void setXMLLang(String newLang) {
        boolean hasValue = newLang != null && !Strings.isNullOrEmpty((String)newLang);
        this.lang = this.prepareForAssignment(this.lang, newLang);
        this.manageQualifiedAttributeNamespace(LangBearing.XML_LANG_ATTR_NAME, hasValue);
    }

    public List<String> getKeywords() {
        return this.data;
    }

    public void setKeywords(List<String> val) {
        this.data = (List)this.prepareForAssignment(this.data, val);
    }

    public int hashCode() {
        int hash = this.lang == null ? 12 : this.lang.hashCode();
        for (String s : this.data) {
            hash = hash * 31 + s.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Keywords)) {
            return false;
        }
        Keywords other = (Keywords)obj;
        if (this.lang == null ? other.getXMLLang() != null : !this.lang.equals(other.getXMLLang())) {
            return false;
        }
        List otherList = other.getKeywords();
        if (otherList == null) {
            otherList = Collections.emptyList();
        }
        if (otherList.size() != this.data.size()) {
            return false;
        }
        Iterator<String> me = this.data.iterator();
        Iterator him = otherList.iterator();
        while (me.hasNext()) {
            if (me.next().equals(him.next())) continue;
            return false;
        }
        return true;
    }
}

