/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResSchemeTest {
    @Test
    public void testResolveFileString() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile("res:test.properties").exists());
    }

    @Test
    public void testResolveFileStringS() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile("res:/test.properties").exists());
    }

    @Test
    public void testResolveFileStringSS() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile("res://test.properties").exists());
    }

    @Test
    public void testResolveFileStringSSS() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile("res://test.properties").exists());
    }

    @Test
    public void testResolveFileStringSSSnull() {
        Assertions.assertThrows(FileSystemException.class, () -> VFS.getManager().resolveFile("res:///").exists());
    }

    @Test
    public void testResolveFileURI() throws FileSystemException, URISyntaxException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res:test.properties")).exists());
    }

    @Test
    public void testResolveFileURIS() throws FileSystemException, URISyntaxException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res:/test.properties")).exists());
    }

    @Test
    public void testResolveFileURISS() throws FileSystemException, URISyntaxException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res://test.properties")).exists());
    }

    @Test
    public void testResolveFileURISSS() throws FileSystemException, URISyntaxException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res://test.properties")).exists());
    }

    @Test
    public void testResolveURIString() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveURI("res:test.properties").isFile());
    }

    @Test
    public void testResolveURIStringS() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveURI("res:/test.properties").isFile());
    }

    @Test
    public void testResolveURIStringSS() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveURI("res://test.properties").isFile());
    }

    @Test
    public void testResolveURIStringSSS() throws FileSystemException {
        Assertions.assertTrue((boolean)VFS.getManager().resolveURI("res:///test.properties").isFile());
    }

    @Test
    public void testResolveURIStringSSSnull() {
        Assertions.assertThrows(FileSystemException.class, () -> VFS.getManager().resolveURI("res:///").isFile());
    }
}

