/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.ConnectionPoolDataSourceProxy;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCPDSConnectionFactory {
    protected ConnectionPoolDataSourceProxy cpds;

    @BeforeEach
    public void setUp() throws Exception {
        this.cpds = new ConnectionPoolDataSourceProxy((ConnectionPoolDataSource)new DriverAdapterCPDS());
        DriverAdapterCPDS delegate = (DriverAdapterCPDS)this.cpds.getDelegate();
        delegate.setDriver("org.apache.commons.dbcp2.TesterDriver");
        delegate.setUrl("jdbc:apache:commons:testdriver");
        delegate.setUser("userName");
        delegate.setPassword("password");
    }

    @Test
    public void testConnectionErrorCleanup() throws Exception {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, Duration.ofMillis(-1L), false, "userName", "password");
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            PooledConnection pcon1 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
            try (Connection con1 = pcon1.getConnection();){
                PooledConnection pcon2 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
                Assertions.assertEquals((int)2, (int)pool.getNumActive());
                Assertions.assertEquals((int)0, (int)pool.getNumIdle());
                PooledConnectionProxy pc = (PooledConnectionProxy)pcon1;
                Assertions.assertTrue((boolean)pc.getListeners().contains(factory));
                pc.throwConnectionError();
                Assertions.assertEquals((int)1, (int)pool.getNumActive());
                Assertions.assertEquals((int)0, (int)pool.getNumIdle());
                pc.throwConnectionError();
                Assertions.assertEquals((int)1, (int)pool.getNumActive());
                Assertions.assertEquals((int)0, (int)pool.getNumIdle());
                PooledConnection pcon3 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
                Assertions.assertNotEquals((Object)pcon3, (Object)pcon1);
                Assertions.assertFalse((boolean)pc.getListeners().contains(factory));
                Assertions.assertEquals((int)2, (int)pool.getNumActive());
                Assertions.assertEquals((int)0, (int)pool.getNumIdle());
                pcon2.getConnection().close();
                pcon3.getConnection().close();
                Assertions.assertEquals((int)2, (int)pool.getNumIdle());
                Assertions.assertEquals((int)0, (int)pool.getNumActive());
                Assertions.assertThrows(SQLException.class, pc::getConnection, (String)"Expecting SQLException using closed PooledConnection");
                con1.close();
                Assertions.assertEquals((int)2, (int)pool.getNumIdle());
                Assertions.assertEquals((int)0, (int)pool.getNumActive());
                pool.clear();
                Assertions.assertEquals((int)0, (int)pool.getNumIdle());
            }
        }
    }

    @Test
    public void testNullValidationQuery() throws Exception {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, Duration.ofMillis(-1L), false, "userName", "password");
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            pool.setTestOnBorrow(true);
            PooledConnection pcon = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
            Connection con = pcon.getConnection();
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    public void testNullValidationQuery_Deprecated() throws Exception {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, -1, false, "userName", "password");
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            pool.setTestOnBorrow(true);
            PooledConnection pcon = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
            Connection con = pcon.getConnection();
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    public void testSetPasswordThenModCharArray() {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, Duration.ofMillis(-1L), false, "userName", "password");
        char[] pwd = new char[]{'a'};
        factory.setPassword(pwd);
        Assertions.assertEquals((Object)"a", (Object)String.valueOf(factory.getPasswordCharArray()));
        pwd[0] = 98;
        Assertions.assertEquals((Object)"a", (Object)String.valueOf(factory.getPasswordCharArray()));
    }

    @Test
    public void testSetPasswordThenModCharArray_Deprecated() {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, -1, false, "userName", "password");
        char[] pwd = new char[]{'a'};
        factory.setPassword(pwd);
        Assertions.assertEquals((Object)"a", (Object)String.valueOf(factory.getPasswordCharArray()));
        pwd[0] = 98;
        Assertions.assertEquals((Object)"a", (Object)String.valueOf(factory.getPasswordCharArray()));
    }

    @Test
    public void testSharedPoolDSDestroyOnReturn() throws Exception {
        try (PerUserPoolDataSource ds = new PerUserPoolDataSource();){
            ds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.cpds);
            ds.setPerUserMaxTotal("userName", Integer.valueOf(10));
            ds.setPerUserMaxWait("userName", Duration.ofMillis(50L));
            ds.setPerUserMaxIdle("userName", Integer.valueOf(2));
            Connection conn1 = ds.getConnection("userName", "password");
            Connection conn2 = ds.getConnection("userName", "password");
            Connection conn3 = ds.getConnection("userName", "password");
            Assertions.assertEquals((int)3, (int)ds.getNumActive("userName"));
            conn1.close();
            Assertions.assertEquals((int)1, (int)ds.getNumIdle("userName"));
            conn2.close();
            Assertions.assertEquals((int)2, (int)ds.getNumIdle("userName"));
            conn3.close();
            Assertions.assertEquals((int)2, (int)ds.getNumIdle("userName"));
        }
    }
}

