/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.WriteAbortedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BasicDynaBeanTest {
    protected static final String[] properties = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "mappedProperty", "mappedIntProperty", "nullProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty"};
    protected DynaBean bean;

    protected DynaClass createDynaClass() {
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        BasicDynaClass dynaClass = new BasicDynaClass("TestDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intArray", intArray.getClass()), new DynaProperty("intIndexed", intArray.getClass()), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringArray", stringArray.getClass()), new DynaProperty("stringIndexed", stringArray.getClass()), new DynaProperty("stringProperty", String.class)});
        return dynaClass;
    }

    @BeforeEach
    public void setUp() throws Exception {
        DynaClass dynaClass = this.createDynaClass();
        this.bean = dynaClass.newInstance();
        this.bean.set("booleanProperty", (Object)true);
        this.bean.set("booleanSecond", (Object)true);
        this.bean.set("doubleProperty", (Object)321.0);
        this.bean.set("floatProperty", (Object)Float.valueOf(123.0f));
        int[] intArray = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intArray", (Object)intArray);
        int[] intIndexed = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intIndexed", (Object)intIndexed);
        this.bean.set("intProperty", (Object)123);
        ArrayList<String> listIndexed = new ArrayList<String>();
        listIndexed.add("String 0");
        listIndexed.add("String 1");
        listIndexed.add("String 2");
        listIndexed.add("String 3");
        listIndexed.add("String 4");
        this.bean.set("listIndexed", listIndexed);
        this.bean.set("longProperty", (Object)321L);
        HashMap<String, String> mappedProperty = new HashMap<String, String>();
        mappedProperty.put("First Key", "First Value");
        mappedProperty.put("Second Key", "Second Value");
        this.bean.set("mappedProperty", mappedProperty);
        HashMap<String, Integer> mappedIntProperty = new HashMap<String, Integer>();
        mappedIntProperty.put("One", 1);
        mappedIntProperty.put("Two", 2);
        this.bean.set("mappedIntProperty", mappedIntProperty);
        this.bean.set("shortProperty", (Object)987);
        String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringArray", (Object)stringArray);
        String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringIndexed", (Object)stringIndexed);
        this.bean.set("stringProperty", (Object)"This is a string");
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testGetDescriptorArguments() {
        Assertions.assertNull((Object)this.bean.getDynaClass().getDynaProperty("unknown"));
        Assertions.assertThrows(NullPointerException.class, () -> this.bean.getDynaClass().getDynaProperty(null));
    }

    protected void testGetDescriptorBase(String name, Class<?> type) {
        DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty(name);
        Assertions.assertNotNull((Object)descriptor, (String)"Got descriptor");
        Assertions.assertEquals(type, (Object)descriptor.getType(), (String)"Got correct type");
    }

    @Test
    public void testGetDescriptorBoolean() {
        this.testGetDescriptorBase("booleanProperty", Boolean.TYPE);
    }

    @Test
    public void testGetDescriptorDouble() {
        this.testGetDescriptorBase("doubleProperty", Double.TYPE);
    }

    @Test
    public void testGetDescriptorFloat() {
        this.testGetDescriptorBase("floatProperty", Float.TYPE);
    }

    @Test
    public void testGetDescriptorInt() {
        this.testGetDescriptorBase("intProperty", Integer.TYPE);
    }

    @Test
    public void testGetDescriptorLong() {
        this.testGetDescriptorBase("longProperty", Long.TYPE);
    }

    @Test
    public void testGetDescriptors() {
        DynaProperty[] pd = this.bean.getDynaClass().getDynaProperties();
        Assertions.assertNotNull((Object)pd, (String)"Got descriptors");
        int[] count = new int[properties.length];
        for (DynaProperty element : pd) {
            String name = element.getName();
            for (int j = 0; j < properties.length; ++j) {
                if (!name.equals(properties[j])) continue;
                int n = j;
                count[n] = count[n] + 1;
            }
        }
        for (int j = 0; j < properties.length; ++j) {
            if (count[j] < 0) {
                Assertions.fail((String)("Missing property " + properties[j]));
                continue;
            }
            if (count[j] <= 1) continue;
            Assertions.fail((String)("Duplicate property " + properties[j]));
        }
    }

    @Test
    public void testGetDescriptorSecond() {
        this.testGetDescriptorBase("booleanSecond", Boolean.TYPE);
    }

    @Test
    public void testGetDescriptorShort() {
        this.testGetDescriptorBase("shortProperty", Short.TYPE);
    }

    @Test
    public void testGetDescriptorString() {
        this.testGetDescriptorBase("stringProperty", String.class);
    }

    @Test
    public void testGetIndexedArguments() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.bean.get("intArray", -1));
    }

    @Test
    public void testGetIndexedValues() {
        Object value = null;
        for (int i = 0; i < 5; ++i) {
            value = this.bean.get("intArray", i);
            Assertions.assertNotNull((Object)value, (String)("intArray returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intArray returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intArray returned correct " + i));
            value = this.bean.get("intIndexed", i);
            Assertions.assertNotNull((Object)value, (String)("intIndexed returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intIndexed returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intIndexed returned correct " + i));
            value = this.bean.get("listIndexed", i);
            Assertions.assertNotNull((Object)value, (String)("listIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("list returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("listIndexed returned correct " + i));
            value = this.bean.get("stringArray", i);
            Assertions.assertNotNull((Object)value, (String)("stringArray returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringArray returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringArray returned correct " + i));
            value = this.bean.get("stringIndexed", i);
            Assertions.assertNotNull((Object)value, (String)("stringIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringIndexed returned correct " + i));
        }
    }

    @Test
    public void testGetMappedArguments() {
        Object value = this.bean.get("mappedProperty", "unknown");
        Assertions.assertNull((Object)value, (String)"Should not return a value");
    }

    @Test
    public void testGetMappedValues() {
        Object value = null;
        value = this.bean.get("mappedProperty", "First Key");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = this.bean.get("mappedProperty", "Second Key");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = this.bean.get("mappedProperty", "Third Key");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
    }

    @Test
    public void testGetSimpleArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> this.bean.get(null));
    }

    @Test
    public void testGetSimpleBoolean() {
        Object value = this.bean.get("booleanProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Boolean.class, (Object)value, (String)"Got correct type");
        Assertions.assertTrue((boolean)((Boolean)value), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleDouble() {
        Object value = this.bean.get("doubleProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Double.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((double)((Double)value), (double)321.0, (double)0.005, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleFloat() {
        Object value = this.bean.get("floatProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Float.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)123.0f, (float)0.005f, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleInt() {
        Object value = this.bean.get("intProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((int)((Integer)value), (int)123, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleLong() {
        Object value = this.bean.get("longProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Long.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((long)((Long)value), (long)321L, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleShort() {
        Object value = this.bean.get("shortProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Short.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((short)((Short)value), (short)987, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleString() {
        Object value = this.bean.get("stringProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((String)value), (Object)"This is a string", (String)"Got correct value");
    }

    @Test
    public void testMappedContains() {
        Assertions.assertTrue((boolean)this.bean.contains("mappedProperty", "First Key"), (String)"Can see first key");
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "Unknown Key"), (String)"Can not see unknown key");
    }

    @Test
    public void testMappedRemove() {
        Assertions.assertTrue((boolean)this.bean.contains("mappedProperty", "First Key"), (String)"Can see first key");
        this.bean.remove("mappedProperty", "First Key");
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "First Key"), (String)"Can not see first key");
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "Unknown Key"), (String)"Can not see unknown key");
        this.bean.remove("mappedProperty", "Unknown Key");
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "Unknown Key"), (String)"Can not see unknown key");
    }

    @Test
    public void testNotSerializableException() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            Assertions.assertThrows(NotSerializableException.class, () -> oos.writeObject(this.bean));
            oos.flush();
        }
        this.bean = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
            ObjectInputStream ois = new ObjectInputStream(bais);
            Assertions.assertThrows(WriteAbortedException.class, () -> {
                this.bean = (DynaBean)ois.readObject();
            });
        }
        Assertions.assertNull((Object)this.bean);
    }

    @Test
    public void testSetIndexedArguments() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.bean.set("intArray", -1, (Object)0));
    }

    @Test
    public void testSetIndexedValues() {
        Object value = null;
        this.bean.set("intArray", 0, (Object)1);
        value = this.bean.get("intArray", 0);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 0");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 0");
        Assertions.assertEquals((int)1, (int)((Integer)value), (String)"Returned correct new value 0");
        this.bean.set("intIndexed", 1, (Object)11);
        value = this.bean.get("intIndexed", 1);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 1");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 1");
        Assertions.assertEquals((int)11, (int)((Integer)value), (String)"Returned correct new value 1");
        this.bean.set("listIndexed", 2, (Object)"New Value 2");
        value = this.bean.get("listIndexed", 2);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 2");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 2");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 2");
        this.bean.set("stringArray", 3, (Object)"New Value 3");
        value = this.bean.get("stringArray", 3);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 3");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 3");
        Assertions.assertEquals((Object)"New Value 3", (Object)((String)value), (String)"Returned correct new value 3");
        this.bean.set("stringIndexed", 4, (Object)"New Value 4");
        value = this.bean.get("stringIndexed", 4);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 4");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 4");
        Assertions.assertEquals((Object)"New Value 4", (Object)((String)value), (String)"Returned correct new value 4");
    }

    @Test
    public void testSetMappedValues() {
        this.bean.set("mappedProperty", "First Key", (Object)"New First Value");
        Assertions.assertEquals((Object)"New First Value", (Object)((String)this.bean.get("mappedProperty", "First Key")), (String)"Can replace old value");
        this.bean.set("mappedProperty", "Fourth Key", (Object)"Fourth Value");
        Assertions.assertEquals((Object)"Fourth Value", (Object)((String)this.bean.get("mappedProperty", "Fourth Key")), (String)"Can set new value");
    }

    @Test
    public void testSetSimpleBoolean() {
        boolean oldValue = (Boolean)this.bean.get("booleanProperty");
        boolean newValue = !oldValue;
        this.bean.set("booleanProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)((Boolean)this.bean.get("booleanProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleDouble() {
        double oldValue = (Double)this.bean.get("doubleProperty");
        double newValue = oldValue + 1.0;
        this.bean.set("doubleProperty", (Object)newValue);
        Assertions.assertEquals((double)newValue, (double)((Double)this.bean.get("doubleProperty")), (double)0.005, (String)"Matched new value");
    }

    @Test
    public void testSetSimpleFloat() {
        float oldValue = ((Float)this.bean.get("floatProperty")).floatValue();
        float newValue = oldValue + 1.0f;
        this.bean.set("floatProperty", (Object)Float.valueOf(newValue));
        Assertions.assertEquals((float)newValue, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f, (String)"Matched new value");
    }

    @Test
    public void testSetSimpleInt() {
        int oldValue = (Integer)this.bean.get("intProperty");
        int newValue = oldValue + 1;
        this.bean.set("intProperty", (Object)newValue);
        Assertions.assertEquals((int)newValue, (int)((Integer)this.bean.get("intProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleLong() {
        long oldValue = (Long)this.bean.get("longProperty");
        long newValue = oldValue + 1L;
        this.bean.set("longProperty", (Object)newValue);
        Assertions.assertEquals((long)newValue, (long)((Long)this.bean.get("longProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleShort() {
        short oldValue = (Short)this.bean.get("shortProperty");
        short newValue = (short)(oldValue + 1);
        this.bean.set("shortProperty", (Object)newValue);
        Assertions.assertEquals((short)newValue, (short)((Short)this.bean.get("shortProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleString() {
        String oldValue = (String)this.bean.get("stringProperty");
        String newValue = oldValue + " Extra Value";
        this.bean.set("stringProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)((String)this.bean.get("stringProperty")), (String)"Matched new value");
    }
}

