/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.Arrays;
import java.util.Collection;
import org.apache.cassandra.spark.bulkwriter.SqlToCqlTypeConverter;
import org.apache.cassandra.spark.bulkwriter.TableSchemaTestCommon;
import org.apache.cassandra.spark.data.CqlField;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public final class SqlToCqlTypeConverterTest {
    public static Collection<Object[]> dataTypes() {
        return Arrays.asList(SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("bigint"), SqlToCqlTypeConverter.LongConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("blob"), SqlToCqlTypeConverter.BytesConverter.class), SqlToCqlTypeConverterTest.na((CqlField.CqlType)TableSchemaTestCommon.mockListCqlType("int"), SqlToCqlTypeConverter.ListConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("decimal"), SqlToCqlTypeConverter.BigDecimalConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("timestamp"), SqlToCqlTypeConverter.TimestampConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("time"), SqlToCqlTypeConverter.TimeConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("uuid"), SqlToCqlTypeConverter.UUIDConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("varint"), SqlToCqlTypeConverter.BigIntegerConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("timeuuid"), SqlToCqlTypeConverter.TimeUUIDConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("inet"), SqlToCqlTypeConverter.InetAddressConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("date"), SqlToCqlTypeConverter.DateConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("duration"), SqlToCqlTypeConverter.DurationConverter.class), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockMapCqlType("int", "int"), SqlToCqlTypeConverter.MapConverter.class), SqlToCqlTypeConverterTest.na((CqlField.CqlType)TableSchemaTestCommon.mockSetCqlType("inet"), SqlToCqlTypeConverter.SetConverter.class), SqlToCqlTypeConverterTest.na((CqlField.CqlType)TableSchemaTestCommon.mockUdtCqlType("udtType", "f1", "text", "f2", "int", "f3", "timeuuid"), SqlToCqlTypeConverter.UdtConverter.class), SqlToCqlTypeConverterTest.na((CqlField.CqlType)TableSchemaTestCommon.mockCqlCustom("org.apache.cassandra.db.marshal.DateType"), SqlToCqlTypeConverter.TimestampConverter.class));
    }

    @ParameterizedTest(name="{index}: {0} -> {1}")
    @MethodSource(value={"dataTypes"})
    public void testConverter(CqlField.CqlType dt, Class<?> expectedConverter) {
        SqlToCqlTypeConverterTest.assertConverterType(dt, expectedConverter);
    }

    private static Object[] na(CqlField.CqlType dataType, Class<?> converter) {
        return new Object[]{dataType, converter};
    }

    public static Collection<Object[]> noOpDataTypes() {
        return Arrays.asList(SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("ascii")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("boolean")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("counter")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("double")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("float")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("text")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("varchar")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("smallint")), SqlToCqlTypeConverterTest.na(TableSchemaTestCommon.mockCqlType("tinyint")));
    }

    private static Object[] na(CqlField.CqlType dataType) {
        return new Object[]{dataType};
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"noOpDataTypes"})
    public void testNoOpTypes(CqlField.CqlType dataType) {
        SqlToCqlTypeConverterTest.assertConverterType(dataType, SqlToCqlTypeConverter.NoOp.class);
    }

    public static void assertConverterType(CqlField.CqlType dataType, Class expectedType) {
        MatcherAssert.assertThat((Object)SqlToCqlTypeConverter.getConverter((CqlField.CqlType)dataType), (Matcher)CoreMatchers.instanceOf((Class)expectedType));
    }
}

