/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadRecord;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.util.formating.TextTable;

public class StackHisto {
    public static Comparator<SiteInfo> BY_HITS = new HitComparator();
    public static Comparator<SiteInfo> BY_OCCURENCE = new OccurenceComparator();
    public static Comparator<SiteInfo> BY_TERMINAL = new TerminalComparator();
    private String[] conditionNames = new String[0];
    private ThreadSnapshotFilter[] conditionFilters = new ThreadSnapshotFilter[0];
    private Map<StackFrame, SiteInfo> histo = new HashMap<StackFrame, SiteInfo>();
    private int traceCount = 0;
    private Comparator<SiteInfo> histoOrder = BY_OCCURENCE;

    public void addCondition(String name, ThreadSnapshotFilter filter) {
        int n = this.conditionNames.length;
        this.conditionNames = Arrays.copyOf(this.conditionNames, n + 1);
        this.conditionFilters = Arrays.copyOf(this.conditionFilters, n + 1);
        this.conditionNames[n] = name;
        this.conditionFilters[n] = filter;
    }

    public void feed(StackFrameList trace) {
        ++this.traceCount;
        if (trace.depth() == 0) {
            return;
        }
        boolean[] matchVector = this.matchVector(trace);
        HashSet<StackFrame> seen = new HashSet<StackFrame>();
        for (StackFrame e : trace) {
            SiteInfo si = this.getSiteInfo(e);
            ++si.hitCount;
            if (!seen.add(si.site)) continue;
            ++si.occurences;
            for (int m4 = 0; m4 != matchVector.length; ++m4) {
                if (!matchVector[m4]) continue;
                int n = m4;
                si.conditionalCounts[n] = si.conditionalCounts[n] + 1;
            }
        }
        StackFrame last = trace.frameAt(0);
        ++this.getSiteInfo((StackFrame)last).terminalCount;
    }

    public void setHistoOrder(Comparator<SiteInfo> comparator) {
        this.histoOrder = comparator;
    }

    private boolean[] matchVector(StackFrameList trace) {
        boolean[] vec = new boolean[this.conditionNames.length];
        for (int i = 0; i != vec.length; ++i) {
            vec[i] = this.conditionFilters[i].evaluate(new ThreadRecord(trace));
        }
        return vec;
    }

    protected SiteInfo getSiteInfo(StackFrame e) {
        SiteInfo si = this.histo.get(e);
        if (si == null) {
            si = new SiteInfo();
            si.site = e;
            si.conditionNames = this.conditionNames;
            si.conditionalCounts = new int[this.conditionNames.length];
            this.histo.put(e, si);
        }
        return si;
    }

    public String formatHisto() {
        return this.formatHisto(Integer.MAX_VALUE);
    }

    public String formatHistoToCSV() {
        return this.formatHistoToCSV(Integer.MAX_VALUE);
    }

    public String formatHisto(int limit) {
        TextTable tt = new TextTable();
        ArrayList<String> row = new ArrayList<String>();
        row.add("Trc\t(%)");
        row.add("  Frm\t N  ");
        row.add("Term\t(%)");
        for (String name : this.conditionNames) {
            String cf = "  [\t" + name + "\t]";
            row.add(cf);
        }
        row.add("  Frame");
        tt.addRow(row);
        ArrayList<SiteInfo> h2 = new ArrayList<SiteInfo>(this.histo.values());
        Collections.sort(h2, this.histoOrder);
        int n = 0;
        for (SiteInfo si : h2) {
            row.clear();
            String traceN = "\t" + si.getOccurences() + " " + this.formatPct(si.getOccurences(), this.traceCount);
            String frameN = "  " + si.getHitCount() + "  ";
            String termN = "\t" + si.getTerminalCount() + " " + this.formatPct(si.getTerminalCount(), this.traceCount);
            row.add(traceN);
            row.add(frameN);
            row.add(termN);
            for (String name : this.conditionNames) {
                String cf = "  \t" + si.getConditionalCount(name) + " " + this.formatPct(si.getConditionalCount(name), si.getOccurences());
                row.add(cf);
            }
            row.add("  " + si.getSite());
            tt.addRow(row);
            if (limit > ++n) continue;
            break;
        }
        return tt.formatTextTableUnbordered(200);
    }

    public String formatHistoToCSV(int limit) {
        TextTable tt = new TextTable();
        ArrayList<String> row = new ArrayList<String>();
        row.add("Trace N");
        row.add("Frame N");
        row.add("Terminal N");
        for (String name : this.conditionNames) {
            String cf = "[" + name + "]";
            row.add(cf);
        }
        row.add("Frame");
        tt.addRow(row);
        ArrayList<SiteInfo> h2 = new ArrayList<SiteInfo>(this.histo.values());
        Collections.sort(h2, this.histoOrder);
        int n = 0;
        for (SiteInfo si : h2) {
            row.clear();
            String traceN = "" + si.getOccurences();
            String frameN = "" + si.getHitCount();
            String termN = "" + si.getTerminalCount();
            row.add(traceN);
            row.add(frameN);
            row.add(termN);
            for (String name : this.conditionNames) {
                String cf = "" + si.getConditionalCount(name);
                row.add(cf);
            }
            row.add("" + si.getSite());
            tt.addRow(row);
            if (limit > ++n) continue;
            break;
        }
        return TextTable.formatCsv(tt);
    }

    private String formatPct(int num, int denom) {
        return String.format("%3d%%", 100 * num / denom);
    }

    private static class TerminalComparator
    implements Comparator<SiteInfo> {
        private TerminalComparator() {
        }

        @Override
        public int compare(SiteInfo o1, SiteInfo o2) {
            int term1 = o1.terminalCount;
            int term2 = o2.terminalCount;
            int c = Integer.valueOf(term2).compareTo(term1);
            return c != 0 ? c : Integer.valueOf(o2.occurences).compareTo(o1.occurences);
        }
    }

    private static class OccurenceComparator
    implements Comparator<SiteInfo> {
        private OccurenceComparator() {
        }

        @Override
        public int compare(SiteInfo o1, SiteInfo o2) {
            return Integer.valueOf(o2.occurences).compareTo(o1.occurences);
        }
    }

    private static class HitComparator
    implements Comparator<SiteInfo> {
        private HitComparator() {
        }

        @Override
        public int compare(SiteInfo o1, SiteInfo o2) {
            return Integer.valueOf(o2.hitCount).compareTo(o1.hitCount);
        }
    }

    public static class SiteInfo {
        StackFrame site;
        int hitCount;
        int occurences;
        int terminalCount;
        String[] conditionNames;
        int[] conditionalCounts;

        public StackFrame getSite() {
            return this.site;
        }

        public int getHitCount() {
            return this.hitCount;
        }

        public int getTerminalCount() {
            return this.terminalCount;
        }

        public int getOccurences() {
            return this.occurences;
        }

        public int getConditionalCount(String condition) {
            if (this.conditionNames == null) {
                return 0;
            }
            for (int i = 0; i != this.conditionNames.length; ++i) {
                if (!condition.equals(this.conditionNames[i])) continue;
                return this.conditionalCounts[i];
            }
            return 0;
        }
    }
}

