/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.net.SocketException;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.UnrecoverableIllegalStateException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.HeapUtils;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JVMStabilityInspector {
    private static final Logger logger = LoggerFactory.getLogger(JVMStabilityInspector.class);
    private static Killer killer = new Killer();
    private static Object lock = new Object();
    private static boolean printingHeapHistogram;
    public static OnKillHook killerHook;
    private static final Set<String> FORCE_HEAP_OOM_IGNORE_SET;

    private JVMStabilityInspector() {
    }

    public static void uncaughtException(Thread thread, Throwable t2) {
        try {
            StorageMetrics.uncaughtExceptions.inc();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger.error("Exception in thread {}", (Object)thread, (Object)t2);
        Tracing.trace("Exception in thread {}", (Object)thread, (Object)t2);
        for (Throwable t22 = t2; t22 != null; t22 = t22.getCause()) {
            if (t22 == t2 || !(t22 instanceof FSError) && !(t22 instanceof CorruptSSTableException)) continue;
            logger.error("Exception in thread {}", (Object)thread, (Object)t22);
        }
        JVMStabilityInspector.inspectThrowable(t2);
    }

    public static void inspectThrowable(Throwable t2) throws OutOfMemoryError {
        JVMStabilityInspector.inspectThrowable(t2, JVMStabilityInspector::inspectDiskError);
    }

    public static void inspectCommitLogThrowable(Throwable t2) {
        JVMStabilityInspector.inspectThrowable(t2, JVMStabilityInspector::inspectCommitLogError);
    }

    private static void inspectDiskError(Throwable t2) {
        if (t2 instanceof CorruptSSTableException) {
            FileUtils.handleCorruptSSTable((CorruptSSTableException)t2);
        } else if (t2 instanceof FSError) {
            FileUtils.handleFSError((FSError)t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inspectThrowable(Throwable t2, Consumer<Throwable> fn) throws OutOfMemoryError {
        boolean isUnstable = false;
        if (t2 instanceof OutOfMemoryError) {
            if (CassandraRelevantProperties.PRINT_HEAP_HISTOGRAM_ON_OUT_OF_MEMORY_ERROR.getBoolean()) {
                Object object = lock;
                synchronized (object) {
                    if (printingHeapHistogram) {
                        return;
                    }
                    printingHeapHistogram = true;
                }
                HeapUtils.logHeapHistogram();
            }
            logger.error("OutOfMemory error letting the JVM handle the error:", t2);
            StorageService.instance.removeShutdownHook();
            JVMStabilityInspector.forceHeapSpaceOomMaybe((OutOfMemoryError)t2);
            throw (OutOfMemoryError)t2;
        }
        if (t2 instanceof UnrecoverableIllegalStateException) {
            isUnstable = true;
        }
        HeapUtils.maybeCreateHeapDump();
        if (t2 instanceof InterruptedException) {
            throw new UncheckedInterruptedException((InterruptedException)t2);
        }
        if (DatabaseDescriptor.getDiskFailurePolicy() == Config.DiskFailurePolicy.die && (t2 instanceof FSError || t2 instanceof CorruptSSTableException)) {
            isUnstable = true;
        }
        if ((t2 instanceof FileNotFoundException || t2 instanceof FileSystemException || t2 instanceof SocketException) && t2.getMessage() != null && t2.getMessage().contains("Too many open files")) {
            isUnstable = true;
        }
        if (isUnstable) {
            if (!StorageService.instance.isDaemonSetupCompleted()) {
                FileUtils.handleStartupFSError(t2);
            }
            killer.killCurrentJVM(t2);
        }
        try {
            fn.accept(t2);
        }
        catch (Error | Exception e) {
            logger.warn("Unexpected error while handling unexpected error", e);
        }
        if (t2.getCause() != null) {
            JVMStabilityInspector.inspectThrowable(t2.getCause(), fn);
        }
    }

    private static void forceHeapSpaceOomMaybe(OutOfMemoryError oom) {
        if (FORCE_HEAP_OOM_IGNORE_SET.contains(oom.getMessage())) {
            return;
        }
        logger.error("Force heap space OutOfMemoryError in the presence of", (Throwable)oom);
        ArrayList<long[]> ignored = new ArrayList<long[]>();
        while (true) {
            ignored.add(new long[0x3FFFFFFF]);
        }
    }

    private static void inspectCommitLogError(Throwable t2) {
        if (!StorageService.instance.isDaemonSetupCompleted()) {
            logger.error("Exiting due to error while processing commit log during initialization.", t2);
            killer.killCurrentJVM(t2, true);
        } else if (DatabaseDescriptor.getCommitFailurePolicy() == Config.CommitFailurePolicy.die) {
            killer.killCurrentJVM(t2);
        }
    }

    public static void killCurrentJVM(Throwable t2, boolean quiet) {
        killer.killCurrentJVM(t2, quiet);
    }

    public static void userFunctionTimeout(Throwable t2) {
        switch (DatabaseDescriptor.getUserFunctionTimeoutPolicy()) {
            case die: {
                ScheduledExecutors.nonPeriodicTasks.schedule(() -> killer.killCurrentJVM(t2), 250L, TimeUnit.MILLISECONDS);
                break;
            }
            case die_immediate: {
                killer.killCurrentJVM(t2);
                break;
            }
            case ignore: {
                logger.error(t2.getMessage());
            }
        }
    }

    @VisibleForTesting
    public static Killer replaceKiller(Killer newKiller) {
        Killer oldKiller = killer;
        killer = newKiller;
        return oldKiller;
    }

    static {
        FORCE_HEAP_OOM_IGNORE_SET = ImmutableSet.of("Java heap space", "GC Overhead limit exceeded");
    }

    public static interface OnKillHook {
        public boolean execute(Throwable var1);
    }

    @VisibleForTesting
    public static class Killer {
        private final AtomicBoolean killing = new AtomicBoolean();

        protected void killCurrentJVM(Throwable t2) {
            this.killCurrentJVM(t2, false);
        }

        protected void killCurrentJVM(Throwable t2, boolean quiet) {
            boolean doExit;
            if (!quiet) {
                t2.printStackTrace(System.err);
                logger.error("JVM state determined to be unstable.  Exiting forcefully due to:", t2);
            }
            boolean bl = doExit = killerHook != null ? killerHook.execute(t2) : true;
            if (doExit && this.killing.compareAndSet(false, true)) {
                StorageService.instance.removeShutdownHook();
                System.exit(100);
            }
        }
    }
}

