/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.ImmutableMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.SnitchProperties;

abstract class AbstractCloudMetadataServiceConnector {
    static final String METADATA_URL_PROPERTY = "metadata_url";
    static final String METADATA_REQUEST_TIMEOUT_PROPERTY = "metadata_request_timeout";
    static final String DEFAULT_METADATA_REQUEST_TIMEOUT = "30s";
    protected final String metadataServiceUrl;
    protected final int requestTimeoutMs;
    private final SnitchProperties properties;

    public AbstractCloudMetadataServiceConnector(SnitchProperties snitchProperties) {
        this.properties = snitchProperties;
        String parsedMetadataServiceUrl = this.properties.get(METADATA_URL_PROPERTY, null);
        try {
            URL url = new URL(parsedMetadataServiceUrl);
            url.toURI();
            this.metadataServiceUrl = parsedMetadataServiceUrl;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
            throw new ConfigurationException(String.format("Snitch metadata service URL '%s' is invalid. Please review snitch properties defined in the configured '%s' configuration file.", parsedMetadataServiceUrl, CassandraRelevantProperties.CASSANDRA_RACKDC_PROPERTIES.getKey()), ex);
        }
        String metadataRequestTimeout = this.properties.get(METADATA_REQUEST_TIMEOUT_PROPERTY, DEFAULT_METADATA_REQUEST_TIMEOUT);
        try {
            this.requestTimeoutMs = new DurationSpec.IntMillisecondsBound(metadataRequestTimeout).toMilliseconds();
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException(String.format("%s as value of %s is invalid duration! " + ex.getMessage(), metadataRequestTimeout, METADATA_REQUEST_TIMEOUT_PROPERTY));
        }
    }

    public SnitchProperties getProperties() {
        return this.properties;
    }

    public final String apiCall(String query) throws IOException {
        return this.apiCall(this.metadataServiceUrl, query, "GET", ImmutableMap.of(), 200);
    }

    public final String apiCall(String query, Map<String, String> extraHeaders) throws IOException {
        return this.apiCall(this.metadataServiceUrl, query, "GET", extraHeaders, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String apiCall(String url, String query, String method, Map<String, String> extraHeaders, int expectedResponseCode) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url + query).openConnection();
            extraHeaders.forEach(conn::setRequestProperty);
            conn.setRequestMethod(method);
            conn.setConnectTimeout(this.requestTimeoutMs);
            if (conn.getResponseCode() != expectedResponseCode) {
                throw new HttpException(conn.getResponseCode(), conn.getResponseMessage());
            }
            int cl = conn.getContentLength();
            if (cl == -1) {
                String string = null;
                return string;
            }
            byte[] b = new byte[cl];
            try (DataInputStream d = new DataInputStream((InputStream)conn.getContent());){
                d.readFully(b);
            }
            String string = new String(b, StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public String toString() {
        return String.format("%s{%s=%s,%s=%s}", this.getClass().getName(), METADATA_URL_PROPERTY, this.metadataServiceUrl, METADATA_REQUEST_TIMEOUT_PROPERTY, this.requestTimeoutMs);
    }

    public static class DefaultCloudMetadataServiceConnector
    extends AbstractCloudMetadataServiceConnector {
        public DefaultCloudMetadataServiceConnector(SnitchProperties properties) {
            super(properties);
        }
    }

    public static final class HttpException
    extends IOException {
        public final int responseCode;
        public final String responseMessage;

        public HttpException(int responseCode, String responseMessage) {
            super("HTTP response code: " + responseCode + " (" + responseMessage + ")");
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
        }
    }
}

