/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.openhft.chronicle.core.onoes.LogLevel;
import org.jetbrains.annotations.NotNull;

public class ExceptionKey {
    public final LogLevel level;
    public final Class<?> clazz;
    public final String message;
    public final Throwable throwable;

    public ExceptionKey(LogLevel level, Class<?> clazz, String message, Throwable throwable) {
        this.level = level;
        this.clazz = clazz;
        this.message = message;
        this.throwable = throwable;
    }

    public LogLevel level() {
        return this.level;
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public String message() {
        return this.message;
    }

    public Throwable throwable() {
        return this.throwable;
    }

    public int hashCode() {
        int result = this.level.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionKey that = (ExceptionKey)o;
        if (this.level != that.level) {
            return false;
        }
        if (!this.clazz.equals(that.clazz)) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.throwable != null ? this.throwable.equals(that.throwable) : that.throwable == null;
    }

    @NotNull
    public String toString() {
        @NotNull StringWriter sw = new StringWriter();
        if (this.throwable != null) {
            this.throwable.printStackTrace(new PrintWriter(sw));
        }
        return "ExceptionKey{level=" + (Object)((Object)this.level) + ", clazz=" + this.clazz + ", message='" + this.message + '\'' + ", throwable=" + sw + '}';
    }
}

