/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;

public class CdcKryoRegister {
    private static final ThreadLocal<Kryo> KRYO = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        new CdcKryoRegister().registerClasses(kryo);
        return kryo;
    });

    public static Kryo kryo() {
        return KRYO.get();
    }

    public void registerClasses(Kryo kryo) {
        kryo.register(CassandraInstance.class, (Serializer)CassandraInstance.SERIALIZER);
        kryo.register(ReplicationFactor.class, (Serializer)ReplicationFactor.SERIALIZER);
        kryo.register(Marker.class, (Serializer)Marker.SERIALIZER);
        kryo.register(CdcState.class, (Serializer)CdcState.SERIALIZER);
        kryo.register(PartitionUpdateWrapper.Digest.class, (Serializer)PartitionUpdateWrapper.DIGEST_SERIALIZER);
    }
}

