/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OffsetFormat;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.core.util.ThrowingConsumerNonCapturing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HexDumpBytes
implements Bytes<Void> {
    private static final char[] HEXADECIMAL = "0123456789abcdef".toCharArray();
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]{1,2}");
    private final NativeBytes<Void> base = Bytes.allocateElasticDirect(256L);
    private final Bytes<byte[]> text = Bytes.allocateElasticOnHeap(1024);
    private final Bytes<byte[]> comment = Bytes.allocateElasticOnHeap(64);
    private OffsetFormat offsetFormat = null;
    private long startOfLine = 0L;
    private int indent = 0;
    private int numberWrap = 16;

    public HexDumpBytes() {
    }

    HexDumpBytes(BytesStore base, Bytes text) {
        try {
            this.base.write(base);
            this.text.write(text);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HexDumpBytes fromText(Reader reader) {
        HexDumpBytes tb = new HexDumpBytes();
        TextBytesReader reader2 = new TextBytesReader(reader, tb.text);
        try (Scanner sc = new Scanner(reader2);){
            while (sc.hasNext()) {
                if (sc.hasNext(HEX_PATTERN)) {
                    tb.base.rawWriteByte((byte)Integer.parseInt(sc.next(), 16));
                    continue;
                }
                sc.nextLine();
            }
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return tb;
    }

    public static HexDumpBytes fromText(CharSequence text) {
        return HexDumpBytes.fromText(new StringReader(text.toString()));
    }

    public HexDumpBytes offsetFormat(OffsetFormat offsetFormat) {
        this.offsetFormat = offsetFormat;
        return this;
    }

    public int numberWrap() {
        return this.numberWrap;
    }

    public HexDumpBytes numberWrap(int numberWrap) {
        this.numberWrap = numberWrap;
        return this;
    }

    @Override
    public long readRemaining() {
        return this.base.readRemaining();
    }

    @Override
    public long writeRemaining() {
        return this.base.writeRemaining();
    }

    @Override
    public long readLimit() {
        return this.base.readLimit();
    }

    @Override
    public long writeLimit() {
        return this.base.writeLimit();
    }

    @Override
    @NotNull
    public String toHexString() {
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this.text.toString();
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object obj) {
        return this.base.equals(obj);
    }

    @Override
    @NotNull
    public String toString() {
        return this.base.toString();
    }

    @Override
    public boolean retainsComments() {
        return true;
    }

    @Override
    public Bytes<Void> comment(CharSequence comment) {
        if (this.comment.readRemaining() > 0L) {
            this.newLine();
        }
        if (comment.length() > 0 && comment.charAt(0) == '#') {
            this.indent = 0;
            ((Bytes)((Bytes)this.text.append('#')).append(comment)).append('\n');
            this.startOfLine = this.text.writePosition();
        } else {
            this.comment.clear().append(comment);
        }
        return this;
    }

    @Override
    public BytesOut indent(int n) {
        this.indent += n;
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this;
    }

    private long lineLength() {
        return this.text.writePosition() - this.startOfLine;
    }

    private void newLine() {
        if (this.comment.readRemaining() > 0L) {
            while (this.lineLength() < (long)(this.numberWrap * 3 - 3)) {
                this.text.append("   ");
            }
            while (this.lineLength() < (long)(this.numberWrap * 3)) {
                this.text.append(' ');
            }
            this.text.append("# ");
            this.text.append(this.comment);
            this.comment.clear();
        }
        this.text.append('\n');
        this.startOfLine = this.text.writePosition();
    }

    private void appendOffset(long offset) {
        if (this.offsetFormat == null) {
            return;
        }
        this.offsetFormat.append(offset, this.text);
        long wp = this.text.writePosition();
        if (wp > 0L && this.text.peekUnsignedByte(wp - 1L) > 32) {
            this.text.append(' ');
        }
        this.startOfLine = this.text.writePosition();
    }

    @Override
    public BytesStore copy() {
        return new HexDumpBytes(this.base, this.text);
    }

    @Override
    public boolean isElastic() {
        return this.base.isElastic();
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        this.base.ensureCapacity(size);
    }

    @Override
    @NotNull
    public BytesStore bytesStore() {
        return this.base;
    }

    @Override
    @NotNull
    public Bytes compact() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes clear() {
        return this.base.clear();
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    public long capacity() {
        return this.base.capacity();
    }

    @Override
    public long addressForRead(long offset) throws UnsupportedOperationException {
        return this.base.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException {
        if (this.base.compareAndSwapInt(offset & 0xFFFFFFFFL, expected, value)) {
            this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
            return true;
        }
        return false;
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) {
        long off = offset & 0xFFFFFFFFL;
        this.base.testAndSetInt(off, expected, value);
        this.copyToText(off, offset >>> 32, 4);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException {
        if (this.base.compareAndSwapLong(offset & 0xFFFFFFFFL, expected, value)) {
            this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Void underlyingObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(long from, long to, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reserve(ReferenceOwner owner) throws IllegalStateException {
        this.base.reserve(owner);
    }

    @Override
    public void release(ReferenceOwner owner) throws IllegalStateException {
        this.base.release(owner);
        if (this.base.refCount() == 0) {
            this.text.releaseLast();
            this.comment.releaseLast();
        }
    }

    @Override
    public void releaseLast(ReferenceOwner owner) throws IllegalStateException {
        this.base.releaseLast(owner);
        if (this.base.refCount() == 0) {
            this.text.releaseLast();
            this.comment.releaseLast();
        }
    }

    @Override
    public int refCount() {
        return this.base.refCount();
    }

    @Override
    public boolean tryReserve(ReferenceOwner owner) {
        return this.base.tryReserve(owner);
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) {
        return this.base.reservedBy(owner);
    }

    @Override
    @NotNull
    public Bytes<Void> writeByte(long offset, byte i8) throws BufferOverflowException {
        this.base.writeByte(offset & 0xFFFFFFFFL, i8);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 1);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeShort(long offset, short i) throws BufferOverflowException {
        this.base.writeShort(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeInt24(long offset, int i) throws BufferOverflowException {
        this.base.writeInt24(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 3);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeInt(long offset, int i) throws BufferOverflowException {
        return this.writeOrderedInt(offset, i);
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        this.base.writeOrderedInt(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeLong(long offset, long i) throws BufferOverflowException {
        return this.writeOrderedLong(offset, i);
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        this.base.writeOrderedLong(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeFloat(long offset, float d) throws BufferOverflowException {
        this.base.writeFloat(offset & 0xFFFFFFFFL, d);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeDouble(long offset, double d) throws BufferOverflowException {
        this.base.writeDouble(offset & 0xFFFFFFFFL, d);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> write(long writeOffset, RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, IllegalArgumentException, BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> readPosition(long position) throws BufferUnderflowException {
        this.base.readPosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> readLimit(long limit) throws BufferUnderflowException {
        this.base.readLimit(limit);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> readSkip(long bytesToSkip) throws BufferUnderflowException {
        this.base.readSkip(bytesToSkip);
        return this;
    }

    @Override
    public void uncheckedReadSkipOne() {
        this.base.uncheckedReadSkipOne();
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        this.base.uncheckedReadSkipBackOne();
    }

    @Override
    public long readStopBit() throws IORuntimeException {
        return this.base.readStopBit();
    }

    @Override
    public char readStopBitChar() throws IORuntimeException {
        return this.base.readStopBitChar();
    }

    @Override
    public double readStopBitDouble() {
        return this.base.readStopBitDouble();
    }

    @Override
    public double readStopBitDecimal() throws BufferOverflowException {
        return this.base.readStopBitDecimal();
    }

    @Override
    public byte readByte() {
        return this.base.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.base.readUnsignedByte();
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        return this.base.uncheckedReadUnsignedByte();
    }

    @Override
    public short readShort() throws BufferUnderflowException {
        return this.base.readShort();
    }

    @Override
    public int readInt() throws BufferUnderflowException {
        return this.base.readInt();
    }

    @Override
    public long readLong() throws BufferUnderflowException {
        return this.base.readLong();
    }

    @Override
    public float readFloat() throws BufferUnderflowException {
        return this.base.readFloat();
    }

    @Override
    public double readDouble() throws BufferUnderflowException {
        return this.base.readDouble();
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException {
        return this.base.readVolatileInt();
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException {
        return this.base.readVolatileLong();
    }

    @Override
    public int peekUnsignedByte() {
        return this.base.peekUnsignedByte();
    }

    @Override
    public void nativeRead(long address, long size) throws BufferUnderflowException {
        this.base.nativeRead(address, size);
    }

    @Override
    public int lastDecimalPlaces() {
        return this.base.lastDecimalPlaces();
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.base.lastDecimalPlaces(lastDecimalPlaces);
    }

    @Override
    @NotNull
    public BigDecimal readBigDecimal() {
        return this.base.readBigDecimal();
    }

    @Override
    @NotNull
    public BigInteger readBigInteger() {
        return this.base.readBigInteger();
    }

    @Override
    public void readWithLength(long length, @NotNull BytesOut<Void> bytesOut) throws BufferUnderflowException, IORuntimeException {
        this.base.readWithLength(length, bytesOut);
    }

    @Override
    public <T extends ReadBytesMarshallable> T readMarshallableLength16(Class<T> tClass, T object) {
        return this.base.readMarshallableLength16(tClass, object);
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionUnlimited(long position) throws BufferUnderflowException {
        return (Bytes)this.base.readPositionUnlimited(position);
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(long position, long remaining) throws BufferUnderflowException {
        return (Bytes)this.base.readPositionRemaining(position, remaining);
    }

    @Override
    public void readWithLength0(long length, @NotNull ThrowingConsumerNonCapturing<Bytes<Void>, IORuntimeException, BytesOut> bytesConsumer, StringBuilder sb, BytesOut toBytes) throws BufferUnderflowException, IORuntimeException {
        this.base.readWithLength0(length, bytesConsumer, sb, toBytes);
    }

    @Override
    public void readWithLength(long length, @NotNull ThrowingConsumer<Bytes<Void>, IORuntimeException> bytesConsumer) throws BufferUnderflowException, IORuntimeException {
        this.base.readWithLength(length, bytesConsumer);
    }

    @Override
    public boolean readBoolean() {
        return this.base.readBoolean();
    }

    @Override
    public int readUnsignedShort() throws BufferUnderflowException {
        return this.base.readUnsignedShort();
    }

    @Override
    public int readInt24() throws BufferUnderflowException {
        return this.base.readInt24();
    }

    @Override
    public int readUnsignedInt24() throws BufferUnderflowException {
        return this.base.readUnsignedInt24();
    }

    @Override
    public long readUnsignedInt() throws BufferUnderflowException {
        return this.base.readUnsignedInt();
    }

    @Override
    @Nullable
    public String readUtf8() throws BufferUnderflowException, IORuntimeException, IllegalArgumentException {
        return this.base.readUtf8();
    }

    @Override
    @Nullable
    public String readUTF\u0394() throws IORuntimeException, BufferUnderflowException, IllegalArgumentException {
        return this.base.readUTF\u0394();
    }

    @Override
    @Nullable
    public String read8bit() throws IORuntimeException, BufferUnderflowException {
        return this.base.read8bit();
    }

    @Override
    public <ACS extends Appendable & CharSequence> boolean readUtf8(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        return this.base.readUtf8(sb);
    }

    @Override
    public <ACS extends Appendable & CharSequence> boolean readUTF\u0394(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        return this.base.readUTF\u0394(sb);
    }

    @Override
    public boolean read8bit(@NotNull Bytes b) throws BufferUnderflowException, IllegalStateException, BufferOverflowException {
        return this.base.read8bit(b);
    }

    @Override
    public <ACS extends Appendable & CharSequence> boolean read8bit(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        return this.base.read8bit(sb);
    }

    @Override
    public boolean read8bit(@NotNull StringBuilder sb) throws IORuntimeException, BufferUnderflowException {
        return this.base.read8bit(sb);
    }

    @Override
    public int read(@NotNull byte[] bytes) {
        return this.base.read(bytes);
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        return this.base.read(bytes, off, len);
    }

    @Override
    public int read(@NotNull char[] bytes, int off, int len) {
        return this.base.read(bytes, off, len);
    }

    @Override
    public void read(@NotNull ByteBuffer buffer) {
        this.base.read(buffer);
    }

    @Override
    public void read(@NotNull Bytes bytes, int length) {
        this.base.read(bytes, length);
    }

    @Override
    @NotNull
    public <E extends Enum<E>> E readEnum(@NotNull Class<E> eClass) throws IORuntimeException, BufferUnderflowException {
        return this.base.readEnum(eClass);
    }

    @Override
    public void readHistogram(@NotNull Histogram histogram) {
        this.base.readHistogram(histogram);
    }

    @Override
    public void readWithLength(Bytes bytes) {
        this.base.readWithLength(bytes);
    }

    @Override
    @NotNull
    public Bytes<Void> writePosition(long position) throws BufferOverflowException {
        this.base.writePosition(position & 0xFFFFFFFFL);
        this.text.writePosition(position >>> 32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeLimit(long limit) throws BufferOverflowException {
        this.base.writeLimit(limit);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSkip(bytesToSkip);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeByte(byte i8) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeByte(i8);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public long writePosition() {
        return this.base.writePosition() | this.text.writePosition() << 32;
    }

    private void copyToText(long pos) {
        long end;
        if (this.lineLength() == 0L && this.offsetFormat != null) {
            this.appendOffset(pos);
            this.startOfLine = this.text.writePosition();
        }
        if (pos < (end = this.base.writePosition())) {
            this.doIndent();
            do {
                int value = this.base.readUnsignedByte(pos);
                long ll = this.lineLength();
                if (ll >= (long)(this.numberWrap * 3 - 1)) {
                    this.newLine();
                    this.appendOffset(pos);
                    this.doIndent();
                    this.startOfLine = this.text.writePosition();
                }
                ++pos;
                long wp = this.text.writePosition();
                if (wp > 0L && this.text.peekUnsignedByte(wp - 1L) > 32) {
                    this.text.append(' ');
                }
                this.text.appendBase16(value, 2);
            } while (pos < end);
        }
    }

    private void copyToText(long pos, long tpos, int length) {
        if (tpos > 0L && this.text.readUnsignedByte(tpos) <= 32) {
            ++tpos;
        }
        while (length-- > 0) {
            int value = this.base.readUnsignedByte(pos++);
            this.text.writeUnsignedByte(tpos++, HEXADECIMAL[value >> 4]);
            this.text.writeUnsignedByte(tpos++, HEXADECIMAL[value & 0xF]);
            if (length <= 0) continue;
            this.text.writeUnsignedByte(tpos++, 32);
        }
    }

    private void doIndent() {
        if (this.lineLength() == 0L && this.indent > 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.text.append("   ");
            }
            this.startOfLine = this.text.writePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeShort(short i16) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeShort(i16);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeInt(int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeIntAdv(int i, int advance) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeIntAdv(i, advance);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeLong(long i64) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeLong(i64);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeLongAdv(long i64, int advance) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeLongAdv(i64, advance);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeFloat(float f) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeFloat(f);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeDouble(double d) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeDouble(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeDoubleAndInt(double d, int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeDouble(d);
            this.base.writeInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public long realWriteRemaining() {
        return this.base.realWriteRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSome(ByteBuffer buffer) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSome(buffer);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeOrderedInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeOrderedLong(long i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeOrderedLong(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nativeWrite(long address, long size) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.nativeWrite(address, size);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> clearAndPad(long length) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.clearAndPad(length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> prewrite(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewrite(BytesStore bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteByte(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteShort(short i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteInt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteLong(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        return this.base.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(long offset) {
        return this.base.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        return this.base.readShort(offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        return this.base.readInt(offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        return this.base.readLong(offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        return this.base.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        return this.base.readDouble(offset);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        return this.base.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        return this.base.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        return this.base.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        return this.base.readVolatileLong(offset);
    }

    @Override
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException {
        this.base.nativeRead(position, address, size);
    }

    @Override
    public long readPosition() {
        return this.base.readPosition() | this.text.readPosition() << 32;
    }

    @Override
    public void lenient(boolean lenient) {
        this.base.lenient(lenient);
    }

    @Override
    public boolean lenient() {
        return this.base.lenient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMarshallableLength16(WriteBytesMarshallable marshallable) {
        long pos = this.base.writePosition();
        try {
            this.base.writeMarshallableLength16(marshallable);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bytes write(InputStream inputStream) throws IOException {
        long pos = this.base.writePosition();
        try {
            this.base.write(inputStream);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBit(long x) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBit(x);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBit(char x) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBit(x);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBit(double d) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBit(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBitDecimal(double d) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBitDecimal(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUtf8(CharSequence cs) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUtf8(cs);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUtf8(String s2) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUtf8(s2);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUTF\u0394(CharSequence cs) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUTF\u0394(cs);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@Nullable CharSequence cs) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(cs);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@NotNull CharSequence s2, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(s2, start, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.write(cs);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull CharSequence s2, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException {
        long pos = this.base.writePosition();
        try {
            this.base.write(s2, start, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@Nullable String s2) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(s2);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@Nullable BytesStore bs) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(bs);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedByte(int i) throws BufferOverflowException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedByte(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedShort(int u16) throws BufferOverflowException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedShort(u16);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeInt24(int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeInt24(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedInt24(int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedInt24(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedInt(long i) throws BufferOverflowException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull RandomDataInput bytes) {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bytes<Void> write(@NotNull BytesStore bytes) {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSome(@NotNull Bytes bytes) {
        long pos = this.base.writePosition();
        try {
            this.base.writeSome(bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull RandomDataInput bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull byte[] bytes) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeBoolean(boolean flag) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeBoolean(flag);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Enum<E>> Bytes<Void> writeEnum(@NotNull E e) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeEnum(e);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public void writePositionRemaining(long position, long length) {
        this.writePosition(position);
        this.writeLimit(this.base.writePosition + length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHistogram(@NotNull Histogram histogram) {
        long pos = this.base.writePosition();
        try {
            this.base.writeHistogram(histogram);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBigDecimal(@NotNull BigDecimal bd) {
        long pos = this.base.writePosition();
        try {
            this.base.writeBigDecimal(bd);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBigInteger(@NotNull BigInteger bi) {
        long pos = this.base.writePosition();
        try {
            this.base.writeBigInteger(bi);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWithLength(RandomDataInput bytes) {
        long pos = this.base.writePosition();
        try {
            this.base.writeWithLength(bytes);
        }
        finally {
            this.copyToText(pos);
        }
    }

    private static class TextBytesReader
    extends Reader {
        private final Reader reader;
        private final Bytes base;

        public TextBytesReader(Reader reader, Bytes base) {
            this.reader = reader;
            this.base = base;
        }

        @Override
        public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
            int len2 = this.reader.read(cbuf, off, len);
            this.base.append(new String(cbuf, off, len));
            return len2;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

