/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.RequestExecutor;
import org.apache.cassandra.sidecar.client.SidecarClientBlobRestoreExtension;
import org.apache.cassandra.sidecar.client.SidecarClientConfig;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.SidecarInstancesProvider;
import org.apache.cassandra.sidecar.client.SimpleSidecarInstancesProvider;
import org.apache.cassandra.sidecar.client.StreamConsumer;
import org.apache.cassandra.sidecar.client.retry.CreateRestoreJobRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.IgnoreConflictRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.OncePerInstanceRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.client.retry.RunnableOnStatusCodeRetryPolicy;
import org.apache.cassandra.sidecar.client.selection.RandomInstanceSelectionPolicy;
import org.apache.cassandra.sidecar.common.request.AbortRestoreJobRequest;
import org.apache.cassandra.sidecar.common.request.AllServicesConfigRequest;
import org.apache.cassandra.sidecar.common.request.CreateRestoreJobRequest;
import org.apache.cassandra.sidecar.common.request.CreateRestoreJobSliceRequest;
import org.apache.cassandra.sidecar.common.request.DeleteServiceConfigRequest;
import org.apache.cassandra.sidecar.common.request.ImportSSTableRequest;
import org.apache.cassandra.sidecar.common.request.ListCdcSegmentsRequest;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.RestoreJobProgressRequest;
import org.apache.cassandra.sidecar.common.request.RestoreJobSummaryRequest;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.common.request.StreamCdcSegmentRequest;
import org.apache.cassandra.sidecar.common.request.UpdateRestoreJobRequest;
import org.apache.cassandra.sidecar.common.request.UpdateServiceConfigRequest;
import org.apache.cassandra.sidecar.common.request.data.AbortRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.request.data.AllServicesConfigPayload;
import org.apache.cassandra.sidecar.common.request.data.CreateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.request.data.CreateSliceRequestPayload;
import org.apache.cassandra.sidecar.common.request.data.Digest;
import org.apache.cassandra.sidecar.common.request.data.RestoreJobProgressRequestParams;
import org.apache.cassandra.sidecar.common.request.data.UpdateCdcServiceConfigPayload;
import org.apache.cassandra.sidecar.common.request.data.UpdateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.response.ConnectedClientStatsResponse;
import org.apache.cassandra.sidecar.common.response.GossipInfoResponse;
import org.apache.cassandra.sidecar.common.response.HealthResponse;
import org.apache.cassandra.sidecar.common.response.ListCdcSegmentsResponse;
import org.apache.cassandra.sidecar.common.response.ListOperationalJobsResponse;
import org.apache.cassandra.sidecar.common.response.ListSnapshotFilesResponse;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.response.OperationalJobResponse;
import org.apache.cassandra.sidecar.common.response.RingResponse;
import org.apache.cassandra.sidecar.common.response.SSTableImportResponse;
import org.apache.cassandra.sidecar.common.response.SchemaResponse;
import org.apache.cassandra.sidecar.common.response.StreamStatsResponse;
import org.apache.cassandra.sidecar.common.response.TableStatsResponse;
import org.apache.cassandra.sidecar.common.response.TimeSkewResponse;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.response.data.CreateRestoreJobResponsePayload;
import org.apache.cassandra.sidecar.common.response.data.RestoreJobProgressResponsePayload;
import org.apache.cassandra.sidecar.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.sidecar.common.utils.HttpRange;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarClient
implements AutoCloseable,
SidecarClientBlobRestoreExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarClient.class);
    protected RequestExecutor executor;
    protected final RetryPolicy defaultRetryPolicy;
    protected final RetryPolicy ignoreConflictRetryPolicy;
    protected final RetryPolicy oncePerInstanceRetryPolicy;
    protected RequestContext.Builder baseBuilder;

    public SidecarClient(SidecarInstancesProvider instancesProvider, RequestExecutor requestExecutor, SidecarClientConfig sidecarClientConfig, RetryPolicy defaultRetryPolicy) {
        this.defaultRetryPolicy = defaultRetryPolicy;
        this.ignoreConflictRetryPolicy = new IgnoreConflictRetryPolicy(sidecarClientConfig.maxRetries(), sidecarClientConfig.retryDelayMillis(), sidecarClientConfig.maxRetryDelayMillis());
        this.oncePerInstanceRetryPolicy = new OncePerInstanceRetryPolicy(sidecarClientConfig.minimumHealthRetryDelay(), sidecarClientConfig.maximumHealthRetryDelay());
        this.baseBuilder = new RequestContext.Builder().instanceSelectionPolicy(new RandomInstanceSelectionPolicy(instancesProvider)).retryPolicy(defaultRetryPolicy);
        this.executor = requestExecutor;
    }

    public CompletableFuture<HealthResponse> sidecarHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().sidecarHealthRequest().retryPolicy(this.oncePerInstanceRetryPolicy).build());
    }

    public CompletableFuture<HealthResponse> sidecarHealth(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).retryPolicy(this.oncePerInstanceRetryPolicy).sidecarHealthRequest().build());
    }

    @Deprecated
    public CompletableFuture<HealthResponse> cassandraHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().cassandraHealthRequest().retryPolicy(this.oncePerInstanceRetryPolicy).build());
    }

    public CompletableFuture<HealthResponse> cassandraNativeHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().cassandraNativeHealthRequest().retryPolicy(new OncePerInstanceRetryPolicy()).build());
    }

    public CompletableFuture<HealthResponse> cassandraJmxHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().cassandraJmxHealthRequest().retryPolicy(new OncePerInstanceRetryPolicy()).build());
    }

    public CompletableFuture<SchemaResponse> fullSchema() {
        return this.executor.executeRequestAsync(this.requestBuilder().schemaRequest().build());
    }

    public CompletableFuture<SchemaResponse> schema(String keyspace) {
        return this.executor.executeRequestAsync(this.requestBuilder().schemaRequest(keyspace).build());
    }

    public CompletableFuture<RingResponse> ring(String keyspace) {
        return this.executor.executeRequestAsync(this.requestBuilder().ringRequest(keyspace).build());
    }

    public CompletableFuture<NodeSettings> nodeSettings() {
        return this.executor.executeRequestAsync(this.requestBuilder().nodeSettingsRequest().build());
    }

    public CompletableFuture<NodeSettings> nodeSettings(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).nodeSettingsRequest().build());
    }

    public CompletableFuture<GossipInfoResponse> gossipInfo() {
        return this.executor.executeRequestAsync(this.requestBuilder().gossipInfoRequest().build());
    }

    public CompletableFuture<HealthResponse> gossipHealth(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).gossipHealthRequest().build());
    }

    public CompletableFuture<TimeSkewResponse> timeSkew() {
        return this.executor.executeRequestAsync(this.requestBuilder().timeSkewRequest().build());
    }

    public CompletableFuture<TimeSkewResponse> timeSkew(List<? extends SidecarInstance> instances) {
        SimpleSidecarInstancesProvider instancesProvider = new SimpleSidecarInstancesProvider(instances);
        RandomInstanceSelectionPolicy instanceSelectionPolicy = new RandomInstanceSelectionPolicy(instancesProvider);
        return this.executor.executeRequestAsync(this.requestBuilder().instanceSelectionPolicy(instanceSelectionPolicy).timeSkewRequest().build());
    }

    public CompletableFuture<TokenRangeReplicasResponse> tokenRangeReplicas(List<? extends SidecarInstance> instances, String keyspace) {
        SimpleSidecarInstancesProvider instancesProvider = new SimpleSidecarInstancesProvider(instances);
        RandomInstanceSelectionPolicy instanceSelectionPolicy = new RandomInstanceSelectionPolicy(instancesProvider);
        return this.executeRequestAsync(this.requestBuilder().instanceSelectionPolicy(instanceSelectionPolicy).tokenRangeReplicasRequest(keyspace).build());
    }

    public CompletableFuture<ListSnapshotFilesResponse> listSnapshotFiles(SidecarInstance instance, String keyspace, String table, String snapshotName) {
        return this.listSnapshotFiles(instance, keyspace, table, snapshotName, true);
    }

    public CompletableFuture<ListSnapshotFilesResponse> listSnapshotFiles(SidecarInstance instance, String keyspace, String table, String snapshotName, boolean includeSecondaryIndexFiles) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).listSnapshotFilesRequest(keyspace, table, snapshotName, includeSecondaryIndexFiles).build());
    }

    public CompletableFuture<Void> clearSnapshot(SidecarInstance instance, String keyspace, String table, String snapshotName) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).clearSnapshotRequest(keyspace, table, snapshotName).build());
    }

    public CompletableFuture<Void> createSnapshot(SidecarInstance instance, String keyspace, String table, String snapshotName) {
        return this.createSnapshot(instance, keyspace, table, snapshotName, null);
    }

    public CompletableFuture<Void> createSnapshot(SidecarInstance instance, String keyspace, String table, String snapshotName, @Nullable String snapshotTTL) {
        return this.executor.executeRequestAsync(this.requestBuilder().retryPolicy(this.ignoreConflictRetryPolicy).singleInstanceSelectionPolicy(instance).createSnapshotRequest(keyspace, table, snapshotName, snapshotTTL).build());
    }

    @Deprecated
    public void streamSSTableComponent(SidecarInstance instance, String keyspace, String table, String snapshotName, String componentName, HttpRange range, StreamConsumer streamConsumer) {
        this.executor.streamRequest(this.requestBuilder().singleInstanceSelectionPolicy(instance).ssTableComponentRequest(keyspace, table, snapshotName, componentName, range).build(), streamConsumer);
    }

    public void streamSSTableComponent(SidecarInstance instance, ListSnapshotFilesResponse.FileInfo fileInfo, HttpRange range, StreamConsumer streamConsumer) {
        this.executor.streamRequest(this.requestBuilder().singleInstanceSelectionPolicy(instance).ssTableComponentRequest(fileInfo, range).build(), streamConsumer);
    }

    public CompletableFuture<Void> uploadSSTableRequest(SidecarInstance instance, String keyspace, String table, String uploadId, String componentName, Digest digest, String filename) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).uploadSSTableRequest(keyspace, table, uploadId, componentName, digest, filename).build());
    }

    public CompletableFuture<SSTableImportResponse> importSSTableRequest(SidecarInstance instance, String keyspace, String table, String uploadId, ImportSSTableRequest.ImportOptions options) {
        Runnable customLog = () -> LOGGER.info("Request to {} ACCEPTED but not yet complete - will retry until success/failure. uploadId={}", (Object)instance, (Object)uploadId);
        RunnableOnStatusCodeRetryPolicy retryPolicy = new RunnableOnStatusCodeRetryPolicy(customLog, this.defaultRetryPolicy, HttpResponseStatus.ACCEPTED.code(), 10);
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).retryPolicy(retryPolicy).importSSTableRequest(keyspace, table, uploadId, options).build());
    }

    public CompletableFuture<Void> cleanUploadSession(SidecarInstance instance, String uploadId) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).cleanSSTableUploadSessionRequest(uploadId).build());
    }

    public CompletableFuture<ListCdcSegmentsResponse> listCdcSegments(SidecarInstance sidecarInstance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(sidecarInstance).request((Request)new ListCdcSegmentsRequest()).build());
    }

    public void streamCdcSegments(SidecarInstance sidecarInstance, String segment, HttpRange range, StreamConsumer streamConsumer) {
        this.executor.streamRequest(this.requestBuilder().singleInstanceSelectionPolicy(sidecarInstance).request((Request)new StreamCdcSegmentRequest(segment, range)).build(), streamConsumer);
    }

    public <T> CompletableFuture<T> reportSchema(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).reportSchemaRequest().noRetryPolicy().build());
    }

    public CompletableFuture<AllServicesConfigPayload> allServicesConfig() {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new AllServicesConfigRequest()).build());
    }

    public CompletableFuture<UpdateCdcServiceConfigPayload> updateCdcServiceConfig(Service service, Map<String, String> config) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new UpdateServiceConfigRequest(service, new UpdateCdcServiceConfigPayload(config))).build());
    }

    public CompletableFuture<Void> deleteCdcServiceConfig(Service service) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new DeleteServiceConfigRequest(service)).build());
    }

    @Override
    public CompletableFuture<CreateRestoreJobResponsePayload> createRestoreJob(String keyspace, String table, CreateRestoreJobRequestPayload payload) {
        Objects.requireNonNull(payload, "payload cannot be null");
        return this.executor.executeRequestAsync(this.requestBuilder().retryPolicy(new CreateRestoreJobRetryPolicy(this.defaultRetryPolicy)).request((Request)new CreateRestoreJobRequest(keyspace, table, payload)).build());
    }

    @Override
    public CompletableFuture<Void> updateRestoreJob(String keyspace, String table, UUID jobId, UpdateRestoreJobRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new UpdateRestoreJobRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<Void> abortRestoreJob(String keyspace, String table, UUID jobId, AbortRestoreJobRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new AbortRestoreJobRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<RestoreJobSummaryResponsePayload> restoreJobSummary(String keyspace, String table, UUID jobId) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new RestoreJobSummaryRequest(keyspace, table, jobId)).build());
    }

    @Override
    public CompletableFuture<Void> createRestoreJobSlice(SidecarInstance instance, String keyspace, String table, UUID jobId, CreateSliceRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).request((Request)new CreateRestoreJobSliceRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<Void> createRestoreJobSlice(String keyspace, String table, UUID jobId, CreateSliceRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new CreateRestoreJobSliceRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<RestoreJobProgressResponsePayload> restoreJobProgress(RestoreJobProgressRequestParams params) {
        return this.executor.executeRequestAsync(this.requestBuilder().request((Request)new RestoreJobProgressRequest(params)).build());
    }

    public CompletableFuture<ConnectedClientStatsResponse> connectedClientStats(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).connectedClientStatsRequest().build());
    }

    public CompletableFuture<TableStatsResponse> tableStats(SidecarInstance instance, String keyspace, String table) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).tableStatsRequest(keyspace, table).build());
    }

    public CompletableFuture<OperationalJobResponse> operationalJobs(SidecarInstance instance, UUID jobId) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).operationalJobRequest(jobId).build());
    }

    public CompletableFuture<ListOperationalJobsResponse> listOperationalJobs(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).listOperationalJobsRequest().build());
    }

    public CompletableFuture<StreamStatsResponse> streamsStats(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).streamsStatsRequest().build());
    }

    public CompletableFuture<OperationalJobResponse> nodeDecommission(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).nodeDecommissionRequest().build());
    }

    public RequestContext.Builder requestBuilder() {
        return this.baseBuilder.copy();
    }

    public RetryPolicy defaultRetryPolicy() {
        return this.defaultRetryPolicy;
    }

    public <T> CompletableFuture<T> executeRequestAsync(RequestContext context) {
        return this.executor.executeRequestAsync(context);
    }

    @Override
    public void close() throws Exception {
        this.executor.close();
    }
}

