/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.example;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.apache.cassandra.spark.transports.storage.extensions.CoordinationSignalListener;
import org.apache.cassandra.spark.transports.storage.extensions.CredentialChangeListener;
import org.apache.cassandra.spark.transports.storage.extensions.ObjectFailureListener;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageTransportExtension
implements StorageTransportExtension {
    public static final String BUCKET_NAME = "sbw-bucket";
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalStorageTransportExtension.class);
    private String jobId;
    private CoordinationSignalListener coordinationSignalListener;

    public void initialize(String jobId, SparkConf conf, boolean isOnDriver) {
        this.jobId = jobId;
    }

    public StorageTransportConfiguration getStorageConfiguration() {
        ImmutableMap additionalTags = ImmutableMap.of((Object)"additional-key", (Object)"additional-value");
        return new StorageTransportConfiguration(BUCKET_NAME, "us-west-1", BUCKET_NAME, "eu-west-1", "key-prefix", this.generateTokens(), (Map)additionalTags);
    }

    public void onTransportStart(long elapsedMillis) {
    }

    public void setCredentialChangeListener(CredentialChangeListener credentialChangeListener) {
    }

    public void setObjectFailureListener(ObjectFailureListener objectFailureListener) {
    }

    public void onObjectPersisted(String bucket, String key, long sizeInBytes) {
        LOGGER.info("Object {}/{} for job {} persisted with size {} bytes", new Object[]{bucket, key, this.jobId, sizeInBytes});
    }

    public void onAllObjectsPersisted(long objectsCount, long rowCount, long elapsedMillis) {
        LOGGER.info("All {} objects, totaling {} rows, are persisted with elapsed time {}ms", new Object[]{objectsCount, rowCount, elapsedMillis});
    }

    public void onObjectApplied(String bucket, String key, long sizeInBytes, long elapsedMillis) {
    }

    public void onJobSucceeded(long elapsedMillis) {
        LOGGER.info("Job {} succeeded with elapsed time {}ms", (Object)this.jobId, (Object)elapsedMillis);
    }

    public void onJobFailed(long elapsedMillis, Throwable throwable) {
        LOGGER.error("Job {} failed after {}ms", new Object[]{this.jobId, elapsedMillis, throwable});
    }

    private StorageCredentialPair generateTokens() {
        return new StorageCredentialPair("writeRegion", new StorageCredentials("writeKey", "writeSecret", "writeSessionToken"), "readRegion", new StorageCredentials("readKey", "readSecret", "readSessionToken"));
    }

    public void onStageSucceeded(String clusterId, long elapsedMillis) {
        LOGGER.info("Job {} has all objects staged at cluster {} after {}ms", new Object[]{this.jobId, clusterId, elapsedMillis});
    }

    public void onStageFailed(String clusterId, Throwable cause) {
        LOGGER.error("Job {} failed to stage objects at cluster {}", new Object[]{this.jobId, clusterId, cause});
    }

    public void onImportSucceeded(String clusterId, long elapsedMillis) {
        LOGGER.info("Job {} has all objects imported at cluster {} after {}ms", new Object[]{this.jobId, clusterId, elapsedMillis});
    }

    public void onImportFailed(String clusterId, Throwable cause) {
        LOGGER.error("Cluster {} failed to apply objects", (Object)clusterId, (Object)cause);
    }

    public void setCoordinationSignalListener(CoordinationSignalListener listener) {
        this.coordinationSignalListener = listener;
        LOGGER.info("CoordinationSignalListener initialized. listener={}", (Object)listener);
    }
}

