/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.db.guardrails.GuardrailsMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

public abstract class GuardrailsConfigCommand
extends NodeTool.NodeToolCmd {
    private static final Pattern CAMEL_PATTERN = Pattern.compile("([a-z])([A-Z])");
    private static final Map<String, String> toSnakeCaseTranslationMap = Map.of("ZeroTTLOnTWCSEnabled", "zero_ttl_on_twcs_enabled", "ZeroTTLOnTWCSWarned", "zero_ttl_on_twcs_warned", "FieldsPerUDTFailThreshold", "fields_per_udt_fail_threshold", "FieldsPerUDTWarnThreshold", "fields_per_udt_warn_threshold", "FieldsPerUDTThreshold", "fields_per_udt_threshold", "SimpleStrategyEnabled", "simplestrategy_enabled", "NonPartitionRestrictedQueryEnabled", "non_partition_restricted_index_query_enabled");
    private static final Set<String> specialFlags = Set.of("intersect_filtering_query_warned", "zero_ttl_on_twcs_warned");

    void display(NodeProbe probe, Map<String, List<Method>> methods, GuardrailCategory userCategory, boolean verbose) {
        try {
            ArrayList<InternalRow> flags = new ArrayList<InternalRow>();
            ArrayList<InternalRow> thresholds = new ArrayList<InternalRow>();
            ArrayList values = new ArrayList();
            ArrayList others = new ArrayList();
            for (Map.Entry<String, List<Method>> entry : methods.entrySet()) {
                ArrayList<InternalRow> bucket;
                String key = entry.getKey();
                if (key.endsWith("_enabled")) {
                    bucket = flags;
                } else {
                    if (key.endsWith("_threshold")) {
                        if (!verbose) {
                            this.addRow(thresholds, probe.getGuardrailsMBean(), entry.getValue(), entry.getKey());
                            continue;
                        }
                        for (Method method : entry.getValue()) {
                            String guardrailName = GuardrailsConfigCommand.toSnakeCase(method.getName().substring(3));
                            this.addRow(thresholds, probe.getGuardrailsMBean(), method, guardrailName);
                        }
                        continue;
                    }
                    bucket = key.endsWith("_disallowed") || key.endsWith("_ignored") ? values : (key.endsWith("_warned") ? (specialFlags.contains(key) ? flags : values) : others);
                }
                this.addRow(bucket, probe.getGuardrailsMBean(), entry.getValue().get(0), key);
            }
            TableBuilder tb = new TableBuilder();
            LinkedHashMap holder = new LinkedHashMap();
            holder.put(GuardrailCategory.flags, flags);
            holder.put(GuardrailCategory.thresholds, thresholds);
            holder.put(GuardrailCategory.values, values);
            holder.put(GuardrailCategory.others, others);
            if (userCategory != null) {
                this.populateTable(tb, (List)holder.get((Object)userCategory));
            } else if (holder.values().stream().flatMap(list -> Stream.of(list.toArray(new InternalRow[0]))).count() == 1L) {
                for (Map.Entry entry : holder.entrySet()) {
                    this.populateOne(tb, (List)entry.getValue());
                }
            } else {
                for (Map.Entry entry : holder.entrySet()) {
                    this.populateTable(tb, (List)entry.getValue());
                }
            }
            tb.printTo(probe.output().out);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error occured when getting the guardrails config", e);
        }
    }

    private void populateTable(TableBuilder tableBuilder, List<InternalRow> bucket) {
        for (InternalRow row : bucket) {
            tableBuilder.add(row.name, row.value);
        }
    }

    private void populateOne(TableBuilder tableBuilder, List<InternalRow> bucket) {
        if (bucket.size() == 1) {
            tableBuilder.add(bucket.get((int)0).value);
        }
    }

    void constructRow(List<InternalRow> bucket, String guardrailName, String value) {
        bucket.add(new InternalRow(guardrailName, value));
    }

    void addRow(List<InternalRow> bucket, GuardrailsMBean mBean, Method method, String guardrailName) throws Throwable {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.add(method);
        this.addRow(bucket, mBean, methods, guardrailName);
    }

    abstract void addRow(List<InternalRow> var1, GuardrailsMBean var2, List<Method> var3, String var4) throws Throwable;

    @VisibleForTesting
    public static String toSnakeCase(String camelCase) {
        if (camelCase == null || camelCase.isEmpty()) {
            return camelCase;
        }
        String maybeSnakeCase = toSnakeCaseTranslationMap.get(camelCase);
        if (maybeSnakeCase != null) {
            return maybeSnakeCase;
        }
        return CAMEL_PATTERN.matcher(camelCase).replaceAll("$1_$2").toLowerCase();
    }

    public static class InternalRow {
        final String name;
        final String value;

        public InternalRow(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternalRow that = (InternalRow)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "InternalRow{name='" + this.name + "', value='" + this.value + "'}";
        }
    }

    @VisibleForTesting
    public static enum GuardrailCategory {
        values,
        thresholds,
        flags,
        others;


        public static GuardrailCategory parseCategory(String category, PrintStream out) {
            if (category == null) {
                return null;
            }
            try {
                return GuardrailCategory.valueOf(category.toLowerCase());
            }
            catch (IllegalArgumentException ex) {
                String enabledValues = Arrays.stream(GuardrailCategory.values()).map(Enum::name).collect(Collectors.joining(","));
                out.printf("%nError: Illegal value for -c/--category used: '" + category + "'. Supported values are " + enabledValues + ".%n", new Object[0]);
                System.exit(1);
                return null;
            }
        }
    }

    @Command(name="setguardrailsconfig", description="Modify runtime configuration of guardrails.")
    public static class SetGuardrailsConfig
    extends GuardrailsConfigCommand {
        private static final Pattern SETTER_PATTERN = Pattern.compile("^set");
        @Arguments(usage="[<setter> <value1> ...]", description="For flags, possible values are 'true' or 'false'. For thresholds, two values are expected, first for failure, second for warning. For values, enumeration of values expected or one value where multiple items are separated by comma. Setting for thresholds accepting strings and value guardrails are reset by specifying 'null' or '[]' value. For thresholds accepting integers, the reset value is -1.")
        private final List<String> args = new ArrayList<String>();

        @Override
        public void execute(NodeProbe probe) {
            if (this.args.isEmpty()) {
                throw new IllegalStateException("No arguments.");
            }
            String snakeCaseName = this.args.get(0);
            Method setter = this.getAllSetters(probe).entrySet().stream().findFirst().map(o -> (Method)((List)o.getValue()).get(0)).orElseThrow(() -> new IllegalStateException(String.format("Guardrail %s not found.", snakeCaseName)));
            this.sanitizeArguments(setter, this.args);
            this.validateArguments(setter, snakeCaseName, this.args);
            List<String> methodArgs = this.args.subList(1, this.args.size());
            try {
                setter.invoke((Object)probe.getGuardrailsMBean(), this.prepareArguments(methodArgs, setter));
            }
            catch (Exception ex) {
                String reason = ex.getCause() != null && ex.getCause().getMessage() != null ? ex.getCause().getMessage() : ex.getMessage();
                throw new IllegalStateException(String.format("Error occured when setting the config for setter %s with arguments %s: %s", snakeCaseName, methodArgs, reason));
            }
        }

        @Override
        public void addRow(List<InternalRow> bucket, GuardrailsMBean mBean, List<Method> methods, String guardrailName) throws Throwable {
            if (methods.size() == 1) {
                Method method = methods.get(0);
                if (method.getParameterTypes().length == 1) {
                    this.constructRow(bucket, this.sanitizeSetterName(method), method.getParameterTypes()[0].getName());
                } else {
                    this.constructRow(bucket, this.sanitizeSetterName(method), Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.toList()).toString());
                }
            }
        }

        private Map<String, List<Method>> getAllSetters(NodeProbe probe) {
            return Arrays.stream(probe.getGuardrailsMBean().getClass().getDeclaredMethods()).filter(method -> method.getName().startsWith("set") && !method.getName().endsWith("CSV")).filter(method -> this.args.isEmpty() || this.args.contains(SetGuardrailsConfig.toSnakeCase(method.getName().substring(3)))).sorted(Comparator.comparing(Method::getName)).collect(Collectors.groupingBy(method -> SetGuardrailsConfig.toSnakeCase(method.getName().substring(3)))).entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        private String sanitizeSetterName(Method setter) {
            return SetGuardrailsConfig.toSnakeCase(SETTER_PATTERN.matcher(setter.getName()).replaceAll(""));
        }

        private void sanitizeArguments(Method setter, List<String> args) {
            Class<?>[] parameterTypes = setter.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0] == Set.class && args.size() > 2) {
                String guardrail = args.get(0);
                String collectedArguments = String.join((CharSequence)",", args.subList(1, args.size()));
                args.clear();
                args.add(guardrail);
                args.add(collectedArguments);
            }
        }

        private void validateArguments(Method setter, String setterName, List<String> args) {
            if (args.size() != setter.getParameterCount() + 1) {
                throw new IllegalStateException(String.format("%s is expecting %d argument values. Getting %d instead.", setterName, setter.getParameterCount(), args.size() - 1));
            }
        }

        private Object[] prepareArguments(List<String> args, Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] arguments = new Object[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                arguments[i] = this.castType(parameterTypes[i], args.get(i));
            }
            if (method.getName().endsWith("Threshold")) {
                List<Object> thresholdArgs = Arrays.asList(arguments);
                Collections.reverse(thresholdArgs);
                arguments = thresholdArgs.toArray();
            }
            return arguments;
        }

        private Object castType(Class<?> targetType, String value) throws IllegalArgumentException {
            if (targetType == String.class) {
                return value.equals("null") ? "" : value;
            }
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return this.getNumber(value, Integer::parseInt, -1);
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return this.getNumber(value, Long::parseLong, -1);
            }
            if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                return this.getNumber(value, v -> {
                    if (!v.equals("true") && !v.equals("false")) {
                        throw new IllegalStateException("Use 'true' or 'false' values for booleans");
                    }
                    return Boolean.parseBoolean(v);
                }, false);
            }
            if (targetType == Set.class) {
                if (value == null || value.equals("null") || value.equals("[]")) {
                    return new HashSet();
                }
                return new LinkedHashSet<String>(Arrays.asList(value.split(",")));
            }
            throw new IllegalArgumentException(String.format("unsupported type: %s", targetType));
        }

        private <T> T getNumber(String value, Function<String, T> transformer, T defaultValue) {
            if (value == null || value.equals("null")) {
                return defaultValue;
            }
            try {
                return transformer.apply(value);
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException(String.format("Unable to parse value %s", value), ex);
            }
        }
    }

    @Command(name="getguardrailsconfig", description="Print runtime configuration of guardrails.")
    public static class GetGuardrailsConfig
    extends GuardrailsConfigCommand {
        @Option(name={"--category", "-c"}, description="Category of guardrails to filter, can be one of 'values', 'thresholds', 'flags', 'others'.", allowedValues={"values", "thresholds", "flags", "others"})
        private String guardrailCategory;
        @Option(name={"--expand"}, description="Expand all guardrail names so they reflect their counterparts in cassandra.yaml")
        private boolean expand = false;
        @Arguments(description="Specific name of a guardrail to get configuration of.")
        private List<String> args = new ArrayList<String>();

        @Override
        public void execute(NodeProbe probe) {
            String guardrailName;
            GuardrailCategory categoryEnum = GuardrailCategory.parseCategory(this.guardrailCategory, probe.output().out);
            if (this.args.size() > 1) {
                throw new IllegalStateException("Specify only one guardrail name to get the configuration of or no name to get the configuration of all of them.");
            }
            String string = guardrailName = !this.args.isEmpty() ? this.args.get(0) : null;
            if (guardrailName != null && categoryEnum != null) {
                throw new IllegalStateException("Do not specify additional arguments when --category/-c is set.");
            }
            Map<String, List<Method>> allGetters = GetGuardrailsConfig.parseGuardrailNames(probe.getGuardrailsMBean().getClass().getDeclaredMethods(), guardrailName);
            if (allGetters.isEmpty()) {
                assert (guardrailName != null);
                throw new IllegalStateException(String.format("Guardrail %s not found.", guardrailName));
            }
            this.display(probe, allGetters, categoryEnum, this.expand);
        }

        @VisibleForTesting
        public static Map<String, List<Method>> parseGuardrailNames(Method[] guardrailsMethods, String guardrailName) {
            Map<String, List<Method>> allGetters = Arrays.stream(guardrailsMethods).filter(method -> method.getName().startsWith("get") && !method.getName().endsWith("CSV") && !method.getName().endsWith("WarnThreshold") && !method.getName().endsWith("FailThreshold")).filter(method -> guardrailName == null || guardrailName.equals(GetGuardrailsConfig.toSnakeCase(method.getName().substring(3)))).collect(Collectors.groupingBy(method -> GetGuardrailsConfig.toSnakeCase(method.getName().substring(3))));
            Map<String, List<Method>> thresholds = Arrays.stream(guardrailsMethods).filter(method -> method.getName().startsWith("get") && !method.getName().endsWith("CSV") && (method.getName().endsWith("WarnThreshold") || method.getName().endsWith("FailThreshold"))).filter(method -> {
                if (guardrailName == null) {
                    return true;
                }
                String snakeCase = GetGuardrailsConfig.toSnakeCase(method.getName().substring(3));
                String snakeCaseSuccinct = snakeCase.replace("_warn_", "_").replace("_fail_", "_");
                return guardrailName.equals(snakeCase) || guardrailName.equals(snakeCaseSuccinct);
            }).sorted(Comparator.comparing(Method::getName)).collect(Collectors.groupingBy(method -> {
                String methodName = method.getName().substring(3);
                String snakeCase = GetGuardrailsConfig.toSnakeCase(methodName);
                if (snakeCase.endsWith("warn_threshold")) {
                    return snakeCase.replaceAll("_warn_", "_");
                }
                return snakeCase.replaceAll("_fail_", "_");
            }));
            allGetters.putAll(thresholds);
            return allGetters.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        @Override
        public void addRow(List<InternalRow> bucket, GuardrailsMBean mBean, List<Method> methods, String guardrailName) throws Throwable {
            ArrayList<String> values = new ArrayList<String>();
            for (Method method : methods) {
                Class<?> returnType = method.getReturnType();
                Object value = method.invoke((Object)mBean, new Object[0]);
                if (returnType.equals(Integer.TYPE) || returnType.equals(Integer.class) || returnType.equals(Long.TYPE) || returnType.equals(Long.class) || returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class) || returnType.equals(Set.class)) {
                    values.add(value.toString());
                    continue;
                }
                if (returnType.equals(String.class)) {
                    if (value == null || value.toString().isEmpty()) {
                        values.add("null");
                        continue;
                    }
                    values.add(value.toString());
                    continue;
                }
                throw new RuntimeException("Unhandled return type: " + returnType.getTypeName());
            }
            this.constructRow(bucket, guardrailName, values.size() == 1 ? (String)values.get(0) : ((Object)values).toString());
        }
    }
}

