/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.shortestpath;

import org.psjava.algo.graph.shortestpath.Relax;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathAlgorithm;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathCalcStatus;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathResult;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathResultFactory;
import org.psjava.ds.graph.AllEdgeInGraph;
import org.psjava.ds.graph.DirectedWeightedEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.numbersystrem.AddableNumberSystem;
import org.psjava.ds.numbersystrem.InfinitableAddableNumberSystem;
import org.psjava.ds.numbersystrem.InfinitableNumber;
import org.psjava.util.AssertStatus;

public class BellmanFordAlgorithm
implements SingleSourceShortestPathAlgorithm {
    public static BellmanFordAlgorithm getInstance() {
        return new BellmanFordAlgorithm();
    }

    private BellmanFordAlgorithm() {
    }

    @Override
    public <V, W, E extends DirectedWeightedEdge<V, W>> SingleSourceShortestPathResult<V, W, E> calc(Graph<V, E> graph, V from, AddableNumberSystem<W> weightSystem) {
        InfinitableAddableNumberSystem<W> ns = InfinitableAddableNumberSystem.wrap(weightSystem);
        SingleSourceShortestPathCalcStatus<V, W, E> status = BellmanFordAlgorithm.createInitialStatus(graph, from, ns);
        BellmanFordAlgorithm.relaxEnough(graph, status, ns);
        BellmanFordAlgorithm.relaxToCheckNegativeCycle(graph, ns, status);
        return SingleSourceShortestPathResultFactory.create(from, status.distance, status.previous);
    }

    public static <V, E, W> SingleSourceShortestPathCalcStatus<V, W, E> createInitialStatus(Graph<V, E> graph, V from, InfinitableAddableNumberSystem<W> ns) {
        SingleSourceShortestPathCalcStatus status = new SingleSourceShortestPathCalcStatus();
        for (Object v : graph.getVertices()) {
            status.distance.add((InfinitableNumber<W>)v, ns.getInfinity());
        }
        status.distance.replace(from, ns.getZero());
        return status;
    }

    public static <V, W, E extends DirectedWeightedEdge<V, W>> void relaxEnough(Graph<V, E> graph, SingleSourceShortestPathCalcStatus<V, W, E> status, InfinitableAddableNumberSystem<W> ns) {
        for (int i = 0; i < graph.getVertices().size() - 1; ++i) {
            for (DirectedWeightedEdge e : AllEdgeInGraph.wrap(graph)) {
                Relax.relax(status.distance, status.previous, e, ns);
            }
        }
    }

    private static <V, W, E extends DirectedWeightedEdge<V, W>> void relaxToCheckNegativeCycle(Graph<V, E> graph, InfinitableAddableNumberSystem<W> ns, SingleSourceShortestPathCalcStatus<V, W, E> status) {
        for (DirectedWeightedEdge e : AllEdgeInGraph.wrap(graph)) {
            boolean relaxed = Relax.relax(status.distance, status.previous, e, ns);
            AssertStatus.assertTrue(!relaxed, "contains negative cycle");
        }
    }
}

