/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from Redis.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RedisEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Spring Redis component.
     */
    public interface RedisEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRedisEndpointConsumerBuilder advanced() {
            return (AdvancedRedisEndpointConsumerBuilder) this;
        }
        /**
         * List of topic names or name patterns to subscribe to. Multiple names
         * can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param channels the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder channels(String channels) {
            doSetProperty("channels", channels);
            return this;
        }
        /**
         * Default command, which can be overridden by message header. Notice
         * the consumer only supports the following commands: PSUBSCRIBE and
         * SUBSCRIBE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.redis.Command</code> type.
         * 
         * Default: SET
         * Group: common
         * 
         * @param command the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder command(org.apache.camel.component.redis.Command command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Default command, which can be overridden by message header. Notice
         * the consumer only supports the following commands: PSUBSCRIBE and
         * SUBSCRIBE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.redis.Command</code> type.
         * 
         * Default: SET
         * Group: common
         * 
         * @param command the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder command(String command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Reference to a pre-configured RedisConnectionFactory instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.connection.RedisConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder connectionFactory(org.springframework.data.redis.connection.RedisConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Reference to a pre-configured RedisConnectionFactory instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.connection.RedisConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Reference to a pre-configured RedisTemplate instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.core.RedisTemplate&lt;java.lang.Object, java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param redisTemplate the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder redisTemplate(org.springframework.data.redis.core.RedisTemplate<java.lang.Object, java.lang.Object> redisTemplate) {
            doSetProperty("redisTemplate", redisTemplate);
            return this;
        }
        /**
         * Reference to a pre-configured RedisTemplate instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.core.RedisTemplate&lt;java.lang.Object, java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param redisTemplate the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder redisTemplate(String redisTemplate) {
            doSetProperty("redisTemplate", redisTemplate);
            return this;
        }
        /**
         * Reference to a pre-configured RedisSerializer instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.serializer.RedisSerializer&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param serializer the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder serializer(org.springframework.data.redis.serializer.RedisSerializer<java.lang.Object> serializer) {
            doSetProperty("serializer", serializer);
            return this;
        }
        /**
         * Reference to a pre-configured RedisSerializer instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.serializer.RedisSerializer&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param serializer the value to set
         * @return the dsl builder
         */
        default RedisEndpointConsumerBuilder serializer(String serializer) {
            doSetProperty("serializer", serializer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Spring Redis component.
     */
    public interface AdvancedRedisEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RedisEndpointConsumerBuilder basic() {
            return (RedisEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Reference to a pre-configured RedisMessageListenerContainer instance
         * to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.listener.RedisMessageListenerContainer</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param listenerContainer the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder listenerContainer(org.springframework.data.redis.listener.RedisMessageListenerContainer listenerContainer) {
            doSetProperty("listenerContainer", listenerContainer);
            return this;
        }
        /**
         * Reference to a pre-configured RedisMessageListenerContainer instance
         * to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.listener.RedisMessageListenerContainer</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param listenerContainer the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointConsumerBuilder listenerContainer(String listenerContainer) {
            doSetProperty("listenerContainer", listenerContainer);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Spring Redis component.
     */
    public interface RedisEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRedisEndpointProducerBuilder advanced() {
            return (AdvancedRedisEndpointProducerBuilder) this;
        }

        /**
         * List of topic names or name patterns to subscribe to. Multiple names
         * can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param channels the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder channels(String channels) {
            doSetProperty("channels", channels);
            return this;
        }
        /**
         * Default command, which can be overridden by message header. Notice
         * the consumer only supports the following commands: PSUBSCRIBE and
         * SUBSCRIBE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.redis.Command</code> type.
         * 
         * Default: SET
         * Group: common
         * 
         * @param command the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder command(org.apache.camel.component.redis.Command command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Default command, which can be overridden by message header. Notice
         * the consumer only supports the following commands: PSUBSCRIBE and
         * SUBSCRIBE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.redis.Command</code> type.
         * 
         * Default: SET
         * Group: common
         * 
         * @param command the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder command(String command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Reference to a pre-configured RedisConnectionFactory instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.connection.RedisConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder connectionFactory(org.springframework.data.redis.connection.RedisConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Reference to a pre-configured RedisConnectionFactory instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.connection.RedisConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Reference to a pre-configured RedisTemplate instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.core.RedisTemplate&lt;java.lang.Object, java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param redisTemplate the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder redisTemplate(org.springframework.data.redis.core.RedisTemplate<java.lang.Object, java.lang.Object> redisTemplate) {
            doSetProperty("redisTemplate", redisTemplate);
            return this;
        }
        /**
         * Reference to a pre-configured RedisTemplate instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.core.RedisTemplate&lt;java.lang.Object, java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param redisTemplate the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder redisTemplate(String redisTemplate) {
            doSetProperty("redisTemplate", redisTemplate);
            return this;
        }
        /**
         * Reference to a pre-configured RedisSerializer instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.serializer.RedisSerializer&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param serializer the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder serializer(org.springframework.data.redis.serializer.RedisSerializer<java.lang.Object> serializer) {
            doSetProperty("serializer", serializer);
            return this;
        }
        /**
         * Reference to a pre-configured RedisSerializer instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.serializer.RedisSerializer&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param serializer the value to set
         * @return the dsl builder
         */
        default RedisEndpointProducerBuilder serializer(String serializer) {
            doSetProperty("serializer", serializer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Spring Redis component.
     */
    public interface AdvancedRedisEndpointProducerBuilder extends EndpointProducerBuilder {
        default RedisEndpointProducerBuilder basic() {
            return (RedisEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRedisEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Spring Redis component.
     */
    public interface RedisEndpointBuilder
            extends
                RedisEndpointConsumerBuilder,
                RedisEndpointProducerBuilder {
        default AdvancedRedisEndpointBuilder advanced() {
            return (AdvancedRedisEndpointBuilder) this;
        }

        /**
         * List of topic names or name patterns to subscribe to. Multiple names
         * can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param channels the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder channels(String channels) {
            doSetProperty("channels", channels);
            return this;
        }
        /**
         * Default command, which can be overridden by message header. Notice
         * the consumer only supports the following commands: PSUBSCRIBE and
         * SUBSCRIBE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.redis.Command</code> type.
         * 
         * Default: SET
         * Group: common
         * 
         * @param command the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder command(org.apache.camel.component.redis.Command command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Default command, which can be overridden by message header. Notice
         * the consumer only supports the following commands: PSUBSCRIBE and
         * SUBSCRIBE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.redis.Command</code> type.
         * 
         * Default: SET
         * Group: common
         * 
         * @param command the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder command(String command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Reference to a pre-configured RedisConnectionFactory instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.connection.RedisConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder connectionFactory(org.springframework.data.redis.connection.RedisConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Reference to a pre-configured RedisConnectionFactory instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.connection.RedisConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Reference to a pre-configured RedisTemplate instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.core.RedisTemplate&lt;java.lang.Object, java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param redisTemplate the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder redisTemplate(org.springframework.data.redis.core.RedisTemplate<java.lang.Object, java.lang.Object> redisTemplate) {
            doSetProperty("redisTemplate", redisTemplate);
            return this;
        }
        /**
         * Reference to a pre-configured RedisTemplate instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.core.RedisTemplate&lt;java.lang.Object, java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param redisTemplate the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder redisTemplate(String redisTemplate) {
            doSetProperty("redisTemplate", redisTemplate);
            return this;
        }
        /**
         * Reference to a pre-configured RedisSerializer instance to use.
         * 
         * The option is a:
         * <code>org.springframework.data.redis.serializer.RedisSerializer&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param serializer the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder serializer(org.springframework.data.redis.serializer.RedisSerializer<java.lang.Object> serializer) {
            doSetProperty("serializer", serializer);
            return this;
        }
        /**
         * Reference to a pre-configured RedisSerializer instance to use.
         * 
         * The option will be converted to a
         * <code>org.springframework.data.redis.serializer.RedisSerializer&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param serializer the value to set
         * @return the dsl builder
         */
        default RedisEndpointBuilder serializer(String serializer) {
            doSetProperty("serializer", serializer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring Redis component.
     */
    public interface AdvancedRedisEndpointBuilder
            extends
                AdvancedRedisEndpointConsumerBuilder,
                AdvancedRedisEndpointProducerBuilder {
        default RedisEndpointBuilder basic() {
            return (RedisEndpointBuilder) this;
        }

    }

    public interface RedisBuilders {
        /**
         * Spring Redis (camel-spring-redis)
         * Send and receive messages from Redis.
         * 
         * Category: cache
         * Since: 2.11
         * Maven coordinates: org.apache.camel:camel-spring-redis
         * 
         * @return the dsl builder for the headers' name.
         */
        default RedisHeaderNameBuilder springRedis() {
            return RedisHeaderNameBuilder.INSTANCE;
        }
        /**
         * Spring Redis (camel-spring-redis)
         * Send and receive messages from Redis.
         * 
         * Category: cache
         * Since: 2.11
         * Maven coordinates: org.apache.camel:camel-spring-redis
         * 
         * Syntax: <code>spring-redis:host:port</code>
         * 
         * Path parameter: host (required)
         * The host where Redis server is running.
         * 
         * Path parameter: port (required)
         * Redis server port number
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default RedisEndpointBuilder springRedis(String path) {
            return RedisEndpointBuilderFactory.endpointBuilder("spring-redis", path);
        }
        /**
         * Spring Redis (camel-spring-redis)
         * Send and receive messages from Redis.
         * 
         * Category: cache
         * Since: 2.11
         * Maven coordinates: org.apache.camel:camel-spring-redis
         * 
         * Syntax: <code>spring-redis:host:port</code>
         * 
         * Path parameter: host (required)
         * The host where Redis server is running.
         * 
         * Path parameter: port (required)
         * Redis server port number
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port
         * @return the dsl builder
         */
        default RedisEndpointBuilder springRedis(String componentName, String path) {
            return RedisEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Spring Redis component.
     */
    public static class RedisHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final RedisHeaderNameBuilder INSTANCE = new RedisHeaderNameBuilder();

        /**
         * The command to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Redis.Command}.
         */
        public String redisCommand() {
            return "CamelRedis.Command";
        }
        /**
         * The key.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Key}.
         */
        public String redisKey() {
            return "CamelRedis.Key";
        }
        /**
         * The keys.
         * 
         * The option is a: {@code Collection<String>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Keys}.
         */
        public String redisKeys() {
            return "CamelRedis.Keys";
        }
        /**
         * The field.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Field}.
         */
        public String redisField() {
            return "CamelRedis.Field";
        }
        /**
         * The fields.
         * 
         * The option is a: {@code Collection<String>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Fields}.
         */
        public String redisFields() {
            return "CamelRedis.Fields";
        }
        /**
         * The value.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Value}.
         */
        public String redisValue() {
            return "CamelRedis.Value";
        }
        /**
         * The values.
         * 
         * The option is a: {@code Map<String, Object> or Collection<Object>}
         * type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Values}.
         */
        public String redisValues() {
            return "CamelRedis.Values";
        }
        /**
         * Start.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Start}.
         */
        public String redisStart() {
            return "CamelRedis.Start";
        }
        /**
         * End.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.End}.
         */
        public String redisEnd() {
            return "CamelRedis.End";
        }
        /**
         * The timeout.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Timeout}.
         */
        public String redisTimeout() {
            return "CamelRedis.Timeout";
        }
        /**
         * The offset.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Offset}.
         */
        public String redisOffset() {
            return "CamelRedis.Offset";
        }
        /**
         * The destination.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Destination}.
         */
        public String redisDestination() {
            return "CamelRedis.Destination";
        }
        /**
         * The channel.
         * 
         * The option is a: {@code byte[] or String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Channel}.
         */
        public String redisChannel() {
            return "CamelRedis.Channel";
        }
        /**
         * The message.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Message}.
         */
        public String redisMessage() {
            return "CamelRedis.Message";
        }
        /**
         * The index.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Index}.
         */
        public String redisIndex() {
            return "CamelRedis.Index";
        }
        /**
         * The position.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Position}.
         */
        public String redisPosition() {
            return "CamelRedis.Position";
        }
        /**
         * The pivot.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Pivot}.
         */
        public String redisPivot() {
            return "CamelRedis.Pivot";
        }
        /**
         * Count.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Count}.
         */
        public String redisCount() {
            return "CamelRedis.Count";
        }
        /**
         * The timestamp.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Timestamp}.
         */
        public String redisTimestamp() {
            return "CamelRedis.Timestamp";
        }
        /**
         * The pattern.
         * 
         * The option is a: {@code byte[] or String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Pattern}.
         */
        public String redisPattern() {
            return "CamelRedis.Pattern";
        }
        /**
         * The db.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Db}.
         */
        public String redisDb() {
            return "CamelRedis.Db";
        }
        /**
         * The score.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Score}.
         */
        public String redisScore() {
            return "CamelRedis.Score";
        }
        /**
         * The min.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Min}.
         */
        public String redisMin() {
            return "CamelRedis.Min";
        }
        /**
         * The max.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Max}.
         */
        public String redisMax() {
            return "CamelRedis.Max";
        }
        /**
         * Increment.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Increment}.
         */
        public String redisIncrement() {
            return "CamelRedis.Increment";
        }
        /**
         * WithScore.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.WithScore}.
         */
        public String redisWithscore() {
            return "CamelRedis.WithScore";
        }
        /**
         * Latitude.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Latitude}.
         */
        public String redisLatitude() {
            return "CamelRedis.Latitude";
        }
        /**
         * Longitude.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Longitude}.
         */
        public String redisLongitude() {
            return "CamelRedis.Longitude";
        }
        /**
         * Radius.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Redis.Radius}.
         */
        public String redisRadius() {
            return "CamelRedis.Radius";
        }
    }
    static RedisEndpointBuilder endpointBuilder(String componentName, String path) {
        class RedisEndpointBuilderImpl extends AbstractEndpointBuilder implements RedisEndpointBuilder, AdvancedRedisEndpointBuilder {
            public RedisEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new RedisEndpointBuilderImpl(path);
    }
}