/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl.scram;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.ScramClientFunctionality;
import org.apache.activemq.artemis.spi.core.security.scram.ScramException;
import org.apache.activemq.artemis.spi.core.security.scram.ScramUtils;
import org.apache.activemq.artemis.spi.core.security.scram.StringPrep;

public class ScramClientFunctionalityImpl
implements ScramClientFunctionality {
    private static final Pattern SERVER_FIRST_MESSAGE = Pattern.compile("r=([^,]*),s=([^,]*),i=(.*)$");
    private static final Pattern SERVER_FINAL_MESSAGE = Pattern.compile("v=([^,]*)$");
    private static final String GS2_HEADER = "n,,";
    private static final Charset ASCII = Charset.forName("ASCII");
    private final String mDigestName;
    private final String mHmacName;
    private final String mClientNonce;
    private String mClientFirstMessageBare;
    private final boolean mIsSuccessful = false;
    private byte[] mSaltedPassword;
    private String mAuthMessage;
    private ScramClientFunctionality.State mState = ScramClientFunctionality.State.INITIAL;

    public ScramClientFunctionalityImpl(String digestName, String hmacName) {
        this(digestName, hmacName, UUID.randomUUID().toString());
    }

    public ScramClientFunctionalityImpl(String digestName, String hmacName, String clientNonce) {
        this.mDigestName = ScramUtils.requireNonNullAndNotEmpty((String)digestName, (String)"digestName");
        this.mHmacName = ScramUtils.requireNonNullAndNotEmpty((String)hmacName, (String)"hmacName");
        this.mClientNonce = ScramUtils.requireNonNullAndNotEmpty((String)clientNonce, (String)"clientNonce");
    }

    @Override
    public String prepareFirstMessage(String username) throws ScramException {
        if (this.mState != ScramClientFunctionality.State.INITIAL) {
            throw new IllegalStateException("You can call this method only once");
        }
        try {
            this.mClientFirstMessageBare = "n=" + StringPrep.prepAsQueryString((String)username) + ",r=" + this.mClientNonce;
            this.mState = ScramClientFunctionality.State.FIRST_PREPARED;
            return GS2_HEADER + this.mClientFirstMessageBare;
        }
        catch (StringPrep.StringPrepError e) {
            this.mState = ScramClientFunctionality.State.ENDED;
            throw new ScramException("Username contains prohibited character");
        }
    }

    @Override
    public String prepareFinalMessage(String password, String serverFirstMessage) throws ScramException {
        if (this.mState != ScramClientFunctionality.State.FIRST_PREPARED) {
            throw new IllegalStateException("You can call this method once only after calling prepareFirstMessage()");
        }
        Matcher m = SERVER_FIRST_MESSAGE.matcher(serverFirstMessage);
        if (!m.matches()) {
            this.mState = ScramClientFunctionality.State.ENDED;
            return null;
        }
        String nonce = m.group(1);
        if (!nonce.startsWith(this.mClientNonce)) {
            this.mState = ScramClientFunctionality.State.ENDED;
            return null;
        }
        String salt = m.group(2);
        String iterationCountString = m.group(3);
        int iterations = Integer.parseInt(iterationCountString);
        if (iterations <= 0) {
            this.mState = ScramClientFunctionality.State.ENDED;
            return null;
        }
        try {
            this.mSaltedPassword = ScramUtils.generateSaltedPassword((String)password, (byte[])Base64.getDecoder().decode(salt), (int)iterations, (Mac)Mac.getInstance(this.mHmacName));
            String clientFinalMessageWithoutProof = "c=" + Base64.getEncoder().encodeToString(GS2_HEADER.getBytes(ASCII)) + ",r=" + nonce;
            this.mAuthMessage = this.mClientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientKey = ScramUtils.computeHmac((byte[])this.mSaltedPassword, (String)this.mHmacName, (String)"Client Key");
            byte[] storedKey = MessageDigest.getInstance(this.mDigestName).digest(clientKey);
            byte[] clientSignature = ScramUtils.computeHmac((byte[])storedKey, (String)this.mHmacName, (String)this.mAuthMessage);
            byte[] clientProof = (byte[])clientKey.clone();
            for (int i = 0; i < clientProof.length; ++i) {
                int n = i;
                clientProof[n] = (byte)(clientProof[n] ^ clientSignature[i]);
            }
            this.mState = ScramClientFunctionality.State.FINAL_PREPARED;
            return clientFinalMessageWithoutProof + ",p=" + Base64.getEncoder().encodeToString(clientProof);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            this.mState = ScramClientFunctionality.State.ENDED;
            throw new ScramException((Throwable)e);
        }
    }

    @Override
    public void checkServerFinalMessage(String serverFinalMessage) throws ScramException {
        if (this.mState != ScramClientFunctionality.State.FINAL_PREPARED) {
            throw new IllegalStateException("You can call this method only once after calling prepareFinalMessage()");
        }
        Matcher m = SERVER_FINAL_MESSAGE.matcher(serverFinalMessage);
        if (!m.matches()) {
            this.mState = ScramClientFunctionality.State.ENDED;
            throw new ScramException("invalid message format");
        }
        byte[] serverSignature = Base64.getDecoder().decode(m.group(1));
        this.mState = ScramClientFunctionality.State.ENDED;
        if (!Arrays.equals(serverSignature, this.getExpectedServerSignature())) {
            throw new ScramException("Server signature missmatch");
        }
    }

    @Override
    public boolean isSuccessful() {
        if (this.mState == ScramClientFunctionality.State.ENDED) {
            return false;
        }
        throw new IllegalStateException("You cannot call this method before authentication is ended. Use isEnded() to check that");
    }

    @Override
    public boolean isEnded() {
        return this.mState == ScramClientFunctionality.State.ENDED;
    }

    @Override
    public ScramClientFunctionality.State getState() {
        return this.mState;
    }

    private byte[] getExpectedServerSignature() throws ScramException {
        try {
            byte[] serverKey = ScramUtils.computeHmac((byte[])this.mSaltedPassword, (String)this.mHmacName, (String)"Server Key");
            return ScramUtils.computeHmac((byte[])serverKey, (String)this.mHmacName, (String)this.mAuthMessage);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            this.mState = ScramClientFunctionality.State.ENDED;
            throw new ScramException((Throwable)e);
        }
    }
}

