/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;

public interface TaskScheduler {
    default public Clock getClock() {
        return Clock.systemDefaultZone();
    }

    @Nullable
    public ScheduledFuture<?> schedule(Runnable var1, Trigger var2);

    public ScheduledFuture<?> schedule(Runnable var1, Instant var2);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.schedule(task, startTime.toInstant());
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable var1, Instant var2, Duration var3);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.scheduleAtFixedRate(task, startTime.toInstant(), Duration.ofMillis(period));
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable var1, Duration var2);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.scheduleAtFixedRate(task, Duration.ofMillis(period));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, Instant var2, Duration var3);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.scheduleWithFixedDelay(task, startTime.toInstant(), Duration.ofMillis(delay));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, Duration var2);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.scheduleWithFixedDelay(task, Duration.ofMillis(delay));
    }
}

